/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleSocketManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModule
extends AbstractBase
implements Module,
FemaleSocketListener {
    private final FemaleSocketManager.SocketType _rootSocketType;
    private final FemaleSocket _femaleRootSocket;
    private String _socketSystemName = null;
    private final List<Module.Parameter> _parameters = new ArrayList<Module.Parameter>();
    private final List<SymbolTable.VariableData> _localVariables = new ArrayList<SymbolTable.VariableData>();
    private final Map<Thread, ConditionalNG> _currentConditionalNG = new HashMap<Thread, ConditionalNG>();
    private static final Logger log = LoggerFactory.getLogger(DefaultModule.class);

    public DefaultModule(String sys, String user, FemaleSocketManager.SocketType socketType) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._rootSocketType = socketType;
        this._femaleRootSocket = socketType.createSocket(this, this, "Root");
        this._femaleRootSocket.setEnableListeners(false);
        Manager.NameValidity isNameValid = InstanceManager.getDefault(ModuleManager.class).validSystemNameFormat(this.mSystemName);
        if (isNameValid != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("system name is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentConditionalNG(ConditionalNG conditionalNG) {
        DefaultModule defaultModule = this;
        synchronized (defaultModule) {
            this._currentConditionalNG.put(Thread.currentThread(), conditionalNG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConditionalNG getConditionalNG() {
        DefaultModule defaultModule = this;
        synchronized (defaultModule) {
            return this._currentConditionalNG.get(Thread.currentThread());
        }
    }

    @Override
    public Base getParent() {
        return null;
    }

    @Override
    public void setParent(Base parent) {
        throw new UnsupportedOperationException("A Module cannot have a parent");
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameModule");
    }

    @Override
    public void setState(int s) throws JmriException {
        log.warn("Unexpected call to setState in DefaultModule.");
    }

    @Override
    public int getState() {
        log.warn("Unexpected call to getState in DefaultModule.");
        return 1;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage("DefaultModule_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        StringBuilder sb = new StringBuilder(Bundle.getMessage("DefaultModule_Long", this.getDisplayName()));
        if (!this._parameters.isEmpty()) {
            int i;
            ArrayList<String> inParams = new ArrayList<String>();
            ArrayList<String> outParams = new ArrayList<String>();
            ArrayList<String> inOutParams = new ArrayList<String>();
            for (Module.Parameter p : this._parameters) {
                if (p.isInput() && p.isOutput()) {
                    inOutParams.add(p.getName());
                    continue;
                }
                if (p.isInput()) {
                    inParams.add(p.getName());
                    continue;
                }
                if (p.isOutput()) {
                    outParams.add(p.getName());
                    continue;
                }
                throw new RuntimeException("Parameter " + p.getName() + " is neither in or out");
            }
            sb.append(" ::: ");
            boolean addComma = false;
            for (i = 0; i < inParams.size(); ++i) {
                if (i == 0) {
                    sb.append(Bundle.getMessage("DefaultModuleParamInput"));
                    addComma = true;
                } else {
                    sb.append(", ");
                }
                sb.append((String)inParams.get(i));
            }
            if (addComma) {
                sb.append(", ");
            }
            addComma = false;
            for (i = 0; i < outParams.size(); ++i) {
                if (i == 0) {
                    sb.append(Bundle.getMessage("DefaultModuleParamOuput"));
                    addComma = true;
                } else {
                    sb.append(", ");
                }
                sb.append((String)outParams.get(i));
            }
            if (addComma) {
                sb.append(", ");
            }
            for (i = 0; i < inOutParams.size(); ++i) {
                if (i == 0) {
                    sb.append(Bundle.getMessage("DefaultModuleParamInputOutput"));
                } else {
                    sb.append(", ");
                }
                sb.append((String)inOutParams.get(i));
            }
        }
        return sb.toString();
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        if (index != 0) {
            throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
        }
        return this._femaleRootSocket;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, Locale.getDefault(), writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, locale, writer, indent, "", lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, String currentIndent, MutableInt lineNumber) {
        this.printTreeRow(settings, locale, writer, currentIndent, lineNumber);
        this._femaleRootSocket.printTree(settings, locale, writer, indent, currentIndent + indent, lineNumber);
    }

    @Override
    public FemaleSocketManager.SocketType getRootSocketType() {
        return this._rootSocketType;
    }

    @Override
    public FemaleSocket getRootSocket() {
        return this._femaleRootSocket;
    }

    @Override
    public void addParameter(String name, boolean isInput, boolean isOutput) {
        this._parameters.add(new DefaultSymbolTable.DefaultParameter(name, isInput, isOutput));
    }

    @Override
    public void addParameter(Module.Parameter parameter) {
        this._parameters.add(parameter);
    }

    @Override
    public void addLocalVariable(String name, SymbolTable.InitialValueType initialValueType, String initialValueData) {
        this._localVariables.add(new SymbolTable.VariableData(name, initialValueType, initialValueData));
    }

    public List<Module.Parameter> getParameters() {
        return this._parameters;
    }

    public List<SymbolTable.VariableData> getLocalVariables() {
        return this._localVariables;
    }

    @Override
    public void connected(FemaleSocket socket) {
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        this._socketSystemName = null;
    }

    public void setSocketSystemName(String systemName) {
        if (systemName == null || !systemName.equals(this._socketSystemName)) {
            this._femaleRootSocket.disconnect();
        }
        this._socketSystemName = systemName;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    @Override
    public final void setup() {
        if (!this._femaleRootSocket.isConnected() || !this._femaleRootSocket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
            this._femaleRootSocket.disconnect();
            if (this._socketSystemName != null) {
                try {
                    MaleSocket maleSocket = (MaleSocket)this._rootSocketType.getManager().getBySystemName(this._socketSystemName);
                    if (maleSocket != null) {
                        this._femaleRootSocket.connect(maleSocket);
                        maleSocket.setup();
                    }
                    log.error("digital action is not found: {}", (Object)this._socketSystemName);
                }
                catch (SocketAlreadyConnectedException ex) {
                    throw new RuntimeException("socket is already connected");
                }
            }
        } else {
            this._femaleRootSocket.setup();
        }
    }

    @Override
    public final void disposeMe() {
        this._femaleRootSocket.dispose();
    }

    @Override
    protected void registerListenersForThisClass() {
    }

    @Override
    protected void unregisterListenersForThisClass() {
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            this.getUsageTree(0, bean, report, null);
        }
        return report;
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="Specific log message format")
    public void getUsageTree(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("** {} :: {}", (Object)level, (Object)this.getClass().getName());
        this._femaleRootSocket.getUsageTree(++level, bean, report, cdl);
    }

    @Override
    public boolean existsInTree() {
        return true;
    }
}

