/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.Manager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketManager;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultModule;
import jmri.managers.AbstractManager;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleManager
extends AbstractManager<Module>
implements ModuleManager {
    static volatile DefaultModuleManager _instance = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultModuleManager.class);

    public DefaultModuleManager() {
        InstanceManager.getDefault(LogixNGPreferences.class);
    }

    @Override
    public int getXMLOrder() {
        return 270;
    }

    @Override
    public char typeLetter() {
        return 'Q';
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(String systemName) {
        return LogixNG_Manager.validSystemNameFormat(this.getSubSystemNamePrefix(), systemName);
    }

    @Override
    public Module createModule(String systemName, String userName, FemaleSocketManager.SocketType socketType) throws IllegalArgumentException {
        Module x;
        if (userName != null && !userName.equals("") && (x = this.getByUserName(userName)) != null) {
            return null;
        }
        x = this.getBySystemName(systemName);
        if (x != null) {
            return null;
        }
        if (this.validSystemNameFormat(systemName) != Manager.NameValidity.VALID) {
            throw new IllegalArgumentException("SystemName " + systemName + " is not in the correct format");
        }
        x = new DefaultModule(systemName, userName, socketType);
        this.register(x);
        this.updateAutoNumber(systemName);
        return x;
    }

    @Override
    public Module createModule(String userName, FemaleSocketManager.SocketType socketType) throws IllegalArgumentException {
        return this.createModule(this.getAutoSystemName(), userName, socketType);
    }

    @Override
    public Module getModule(String name) {
        Module x = this.getByUserName(name);
        if (x != null) {
            return x;
        }
        return this.getBySystemName(name);
    }

    @Override
    public Module getByUserName(String name) {
        return (Module)this._tuser.get(name);
    }

    @Override
    public Module getBySystemName(String name) {
        return (Module)this._tsys.get(name);
    }

    @Override
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameLogixNGModules" : "BeanNameLogixNGModule");
    }

    @Override
    public boolean resolveAllTrees(List<String> errors) {
        boolean result = true;
        for (Module logixNG_Module : this._tsys.values()) {
            result = result && logixNG_Module.setParentForAllChildren(errors);
        }
        return result;
    }

    @Override
    public void setupAllModules() {
        for (Module logixNG : this._tsys.values()) {
            logixNG.setup();
        }
    }

    @Override
    public void deleteModule(Module x) {
        this.deregister(x);
        x.dispose();
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, PrintWriter writer, String indent, MutableInt lineNumber) {
        this.printTree(settings, Locale.getDefault(), writer, indent, lineNumber);
    }

    @Override
    public void printTree(Base.PrintTreeSettings settings, Locale locale, PrintWriter writer, String indent, MutableInt lineNumber) {
        for (Module module : this.getNamedBeanSet()) {
            module.printTree(settings, locale, writer, indent, "", lineNumber);
            writer.println();
        }
        InstanceManager.getDefault(ModuleManager.class);
    }

    @InvokeOnGuiThread
    public static DefaultModuleManager instance() {
        if (!ThreadingUtil.isGUIThread()) {
            LoggingUtil.warnOnce(log, "instance() called on wrong thread", new Object[0]);
        }
        if (_instance == null) {
            _instance = new DefaultModuleManager();
        }
        return _instance;
    }

    @Override
    public Class<Module> getNamedBeanClass() {
        return Module.class;
    }

    @OverridingMethodsMustInvokeSuper
    public void fireVetoableChange(String p, Object old) throws PropertyVetoException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, p, old, null);
        for (VetoableChangeListener vc : this.vetoableChangeSupport.getVetoableChangeListeners()) {
            vc.vetoableChange(evt);
        }
    }

    @Override
    public final void deleteBean(@Nonnull Module module, @Nonnull String property) throws PropertyVetoException {
        for (int i = 0; i < module.getChildCount(); ++i) {
            FemaleSocket child = module.getChild(i);
            if (!child.isConnected()) continue;
            MaleSocket maleSocket = child.getConnectedSocket();
            maleSocket.getManager().deleteBean(maleSocket, property);
        }
        this.fireVetoableChange(property, module);
        if (property.equals("DoDelete")) {
            this.deregister(module);
            module.dispose();
        }
    }
}

