/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import jmri.InstanceManager;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.Stack;
import jmri.jmrit.logixng.SymbolTable;

public class DefaultStack
implements Stack {
    static final int INITIAL_SIZE = 100;
    static final int GROW_SIZE = 100;
    int _size;
    int _count;
    private Stack.ValueAndType[] _stack = new Stack.ValueAndType[100];

    @Override
    public void push(Stack.ValueAndType valueAndType) {
        if (this._count + 1 >= this._size) {
            Stack.ValueAndType[] newStack = new Stack.ValueAndType[this._size + 100];
            System.arraycopy(this._stack, 0, newStack, 0, this._size);
            this._stack = newStack;
            this._size += 100;
        }
        this._stack[this._count++] = valueAndType;
    }

    @Override
    public Object pop() {
        if (this._count <= 0) {
            throw new ArrayIndexOutOfBoundsException("Stack is empty");
        }
        return this._stack[--this._count]._value;
    }

    @Override
    public Object getValueAtIndex(int index) {
        return this._stack[index]._value;
    }

    @Override
    public void setValueAtIndex(int index, Object value) {
        LogixNGPreferences prefs = InstanceManager.getDefault(LogixNGPreferences.class);
        this._stack[index]._value = prefs.getStrictTypingLocalVariables() ? SymbolTable.validateStrictTyping(this._stack[index]._type, this._stack[index]._value, value) : value;
    }

    @Override
    public Stack.ValueAndType getValueAndTypeAtIndex(int index) {
        return this._stack[index];
    }

    @Override
    public void setValueAndTypeAtIndex(int index, Stack.ValueAndType valueAndType) {
        this._stack[index] = valueAndType;
    }

    @Override
    public int getCount() {
        return this._count;
    }

    @Override
    public void setCount(int newCount) {
        if (newCount < 0 || newCount > this._count) {
            throw new IllegalArgumentException("newCount has invalid value: " + Integer.toString(newCount));
        }
        this._count = newCount;
    }
}

