/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.Stack;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.Bundle;
import jmri.jmrit.logixng.implementation.DefaultStack;

public class DefaultSymbolTable
implements SymbolTable {
    private final SymbolTable _prevSymbolTable;
    private final Stack _stack;
    private final int _firstSymbolIndex;
    private final Map<String, SymbolTable.Symbol> _symbols = new HashMap<String, SymbolTable.Symbol>();

    public DefaultSymbolTable() {
        this._prevSymbolTable = null;
        this._stack = new DefaultStack();
        this._firstSymbolIndex = this._stack.getCount();
    }

    public DefaultSymbolTable(ConditionalNG currentConditionalNG) {
        this._prevSymbolTable = currentConditionalNG.getSymbolTable();
        this._stack = currentConditionalNG.getStack();
        this._firstSymbolIndex = this._stack.getCount();
    }

    public DefaultSymbolTable(SymbolTable prevSymbolTable) {
        this._prevSymbolTable = null;
        this._symbols.putAll(prevSymbolTable.getSymbols());
        this._stack = new DefaultStack();
        for (SymbolTable.Symbol symbol : this._symbols.values()) {
            this._stack.setValueAndTypeAtIndex(symbol.getIndex(), prevSymbolTable.getValueAndType(symbol.getName()));
        }
        this._firstSymbolIndex = this._stack.getCount();
    }

    public SymbolTable getPrevSymbolTable() {
        return this._prevSymbolTable;
    }

    @Override
    public Map<String, SymbolTable.Symbol> getSymbols() {
        return Collections.unmodifiableMap(this._symbols);
    }

    @Override
    public Map<String, Object> getSymbolValues() {
        HashMap<String, Object> symbolValues = new HashMap<String, Object>();
        for (SymbolTable.Symbol symbol : this._symbols.values()) {
            Object value = this._stack.getValueAtIndex(this._firstSymbolIndex + symbol.getIndex());
            symbolValues.put(symbol.getName(), value);
        }
        return Collections.unmodifiableMap(symbolValues);
    }

    @Override
    public Object getValue(String name) {
        SymbolTable.Symbol symbol = this._symbols.get(name);
        if (symbol != null) {
            return this._stack.getValueAtIndex(this._firstSymbolIndex + symbol.getIndex());
        }
        GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).getByUserName(name);
        if (globalVariable != null) {
            return globalVariable.getValue();
        }
        throw new SymbolTable.SymbolNotFound(String.format("Symbol '%s' does not exist in symbol table", name));
    }

    @Override
    public Stack.ValueAndType getValueAndType(String name) {
        SymbolTable.Symbol symbol = this._symbols.get(name);
        if (symbol != null) {
            return this._stack.getValueAndTypeAtIndex(this._firstSymbolIndex + symbol.getIndex());
        }
        throw new SymbolTable.SymbolNotFound(String.format("Symbol '%s' does not exist in symbol table", name));
    }

    @Override
    public boolean hasValue(String name) {
        if (this._symbols.containsKey(name)) {
            return true;
        }
        GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).getByUserName(name);
        return globalVariable != null;
    }

    @Override
    public void setValue(String name, Object value) {
        if (this._symbols.get(name) != null) {
            this._stack.setValueAtIndex(this._firstSymbolIndex + this._symbols.get(name).getIndex(), value);
        } else {
            GlobalVariable globalVariable = InstanceManager.getDefault(GlobalVariableManager.class).getByUserName(name);
            if (globalVariable != null) {
                globalVariable.setValue(value);
            } else {
                throw new IllegalArgumentException(Bundle.getMessage("ExceptionSymbolNotInSymbolTable", name));
            }
        }
    }

    @Override
    public void printSymbolTable(PrintWriter stream) {
        stream.format("printSymbolTable:%n", new Object[0]);
        for (Map.Entry<String, SymbolTable.Symbol> entry : this._symbols.entrySet()) {
            stream.format("Key: %s, Name: %s, Index: %d, Value: %s%n", entry.getKey(), entry.getValue().getName(), entry.getValue().getIndex(), this._stack.getValueAtIndex(this._firstSymbolIndex + entry.getValue().getIndex()));
        }
        stream.format("printSymbolTable done%n", new Object[0]);
    }

    @Override
    public void createSymbols(Collection<? extends SymbolTable.VariableData> symbolDefinitions) throws JmriException {
        this.createSymbols(this, symbolDefinitions);
    }

    @Override
    public void createSymbols(SymbolTable symbolTable, Collection<? extends SymbolTable.VariableData> symbolDefinitions) throws JmriException {
        for (SymbolTable.VariableData variableData : symbolDefinitions) {
            DefaultSymbol symbol = new DefaultSymbol(variableData.getName(), this._stack.getCount() - this._firstSymbolIndex);
            if (this._symbols.containsKey(symbol.getName())) {
                throw new IllegalArgumentException("Symbol table already contains the variable " + symbol.getName());
            }
            SymbolTable.InitialValueType initialValueType = variableData.getInitialValueType();
            Object initialValue = SymbolTable.getInitialValue(SymbolTable.Type.Local, symbol.getName(), initialValueType, variableData.getInitialValueData(), symbolTable, this._symbols);
            this._stack.push(new Stack.ValueAndType(initialValueType, initialValue));
            this._symbols.put(symbol.getName(), symbol);
        }
    }

    @Override
    public void removeSymbols(Collection<? extends SymbolTable.VariableData> symbolDefinitions) throws JmriException {
        symbolDefinitions.forEach(parameter -> this._symbols.remove(parameter.getName()));
    }

    @Override
    public Stack getStack() {
        return this._stack;
    }

    public static class DefaultParameter
    implements Module.Parameter {
        private String _name;
        private boolean _isInput;
        private boolean _isOutput;

        public DefaultParameter(String name, boolean isInput, boolean isOutput) {
            this._name = name;
            this._isInput = isInput;
            this._isOutput = isOutput;
        }

        public DefaultParameter(Module.Parameter parameter) {
            this._name = parameter.getName();
            this._isInput = parameter.isInput();
            this._isOutput = parameter.isOutput();
        }

        @Override
        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        @Override
        public boolean isInput() {
            return this._isInput;
        }

        public void setIsInput(boolean value) {
            this._isInput = value;
        }

        @Override
        public boolean isOutput() {
            return this._isOutput;
        }

        public void setIsOutput(boolean value) {
            this._isOutput = value;
        }
    }

    public static class DefaultSymbol
    implements SymbolTable.Symbol {
        private final String _name;
        private final int _index;

        public DefaultSymbol(String name, int index) {
            this._name = name;
            this._index = index;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public int getIndex() {
            return this._index;
        }
    }
}

