/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.util.List;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.DefaultConditionalNG;
import jmri.jmrit.logixng.implementation.DefaultConditionalNGManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.ThreadingUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionalNGManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultConditionalNGManagerXml.class);

    @Override
    public Element store(Object o) {
        Element conditionalNGs = new Element("LogixNGConditionalNGs");
        this.setStoreElementClass(conditionalNGs);
        ConditionalNG_Manager tm = (ConditionalNG_Manager)o;
        LogixNG_Manager lm = InstanceManager.getDefault(LogixNG_Manager.class);
        if (tm != null) {
            if (lm.getNamedBeanSet().isEmpty()) {
                return null;
            }
            for (LogixNG logixNG : lm.getNamedBeanSet()) {
                for (int i = 0; i < logixNG.getNumConditionalNGs(); ++i) {
                    ConditionalNG conditionalNG = logixNG.getConditionalNG(i);
                    log.debug("ConditionalNG system name is {}", (Object)conditionalNG.getSystemName());
                    boolean enabled = conditionalNG.isEnabled();
                    boolean executeAtStartup = conditionalNG.isExecuteAtStartup();
                    Element elem = new Element("ConditionalNG");
                    elem.addContent((Content)new Element("systemName").addContent(conditionalNG.getSystemName()));
                    this.storeCommon(conditionalNG, elem);
                    elem.addContent((Content)new Element("thread").addContent(Integer.toString(conditionalNG.getStartupThreadId())));
                    Element e2 = new Element("Socket");
                    e2.addContent((Content)new Element("socketName").addContent(conditionalNG.getChild(0).getName()));
                    MaleSocket socket = conditionalNG.getChild(0).getConnectedSocket();
                    String socketSystemName = socket != null ? socket.getSystemName() : ((DefaultConditionalNG)conditionalNG).getSocketSystemName();
                    if (socketSystemName != null) {
                        e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
                    }
                    elem.addContent((Content)e2);
                    elem.setAttribute("enabled", enabled ? "yes" : "no");
                    if (!executeAtStartup) {
                        elem.setAttribute("executeAtStartup", "no");
                    }
                    conditionalNGs.addContent((Content)elem);
                }
            }
        }
        return conditionalNGs;
    }

    public void setStoreElementClass(Element logixngs) {
        logixngs.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedConditionalNG, Element perNodeConditionalNG) {
        this.replaceConditionalNGManager();
        this.loadConditionalNGs(sharedConditionalNG);
        return true;
    }

    public void loadConditionalNGs(Element conditionalNGs) {
        List conditionalNGList = conditionalNGs.getChildren("ConditionalNG");
        log.debug("Found {} ConditionalNGs", (Object)conditionalNGList.size());
        ConditionalNG_Manager tm = InstanceManager.getDefault(ConditionalNG_Manager.class);
        for (int i = 0; i < conditionalNGList.size(); ++i) {
            Element socketSystemName;
            Element conditionalNG_Element = (Element)conditionalNGList.get(i);
            String sysName = this.getSystemName(conditionalNG_Element);
            if (sysName == null) {
                log.warn("unexpected null in systemName {}", (Object)conditionalNG_Element);
                break;
            }
            String userName = this.getUserName(conditionalNG_Element);
            int threadId = 0;
            Element threadElem = conditionalNG_Element.getChild("thread");
            if (threadElem != null) {
                threadId = Integer.parseInt(threadElem.getTextTrim());
            }
            String enabled = "";
            if (conditionalNG_Element.getAttribute("enabled") != null) {
                enabled = conditionalNG_Element.getAttribute("enabled").getValue();
            }
            log.debug("create ConditionalNG: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            LogixNG logixNG = tm.getParentLogixNG(sysName);
            if (logixNG == null) {
                log.warn("unexpected null while finding parent logixNG for '{}'", (Object)conditionalNG_Element);
                break;
            }
            DefaultConditionalNG conditionalNG = (DefaultConditionalNG)tm.createConditionalNG(logixNG, sysName, userName, threadId);
            if (conditionalNG == null) continue;
            this.loadCommon(conditionalNG, conditionalNG_Element);
            Element socketName = conditionalNG_Element.getChild("Socket").getChild("socketName");
            if (socketName != null) {
                conditionalNG.getFemaleSocket().setName(socketName.getTextTrim());
            }
            if ((socketSystemName = conditionalNG_Element.getChild("Socket").getChild("systemName")) != null) {
                conditionalNG.setSocketSystemName(socketSystemName.getTextTrim());
            }
            if (enabled != null && !enabled.equals("")) {
                if (enabled.equals("yes")) {
                    conditionalNG.setEnabled(true);
                } else if (enabled.equals("no")) {
                    conditionalNG.setEnabled(false);
                }
            }
            String executeAtStartup = "";
            if (conditionalNG_Element.getAttribute("executeAtStartup") != null) {
                executeAtStartup = conditionalNG_Element.getAttribute("executeAtStartup").getValue();
            }
            if (executeAtStartup == null || executeAtStartup.equals("")) continue;
            if (executeAtStartup.equals("yes")) {
                conditionalNG.setExecuteAtStartup(true);
                continue;
            }
            if (!executeAtStartup.equals("no")) continue;
            conditionalNG.setExecuteAtStartup(false);
        }
    }

    protected void replaceConditionalNGManager() {
        ConfigureManager cmOD;
        if (InstanceManager.getDefault(ConditionalNG_Manager.class).getClass().getName().equals(DefaultConditionalNGManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(ConditionalNG_Manager.class) != null && (cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(InstanceManager.getDefault(ConditionalNG_Manager.class));
        }
        ThreadingUtil.runOnGUI(() -> {
            DefaultConditionalNGManager pManager = DefaultConditionalNGManager.instance();
            InstanceManager.store(pManager, ConditionalNG_Manager.class);
            ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cmOD != null) {
                cmOD.registerConfig(pManager, 270);
            }
        });
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(ConditionalNG_Manager.class).getXMLOrder();
    }
}

