/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleDigitalActionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.DefaultDigitalActionManager;
import jmri.jmrit.logixng.implementation.DefaultMaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.configurexml.AbstractManagerXml;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.ThreadingUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDigitalActionManagerXml
extends AbstractManagerXml {
    private final Map<String, Class<?>> xmlClasses = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(DefaultDigitalActionManagerXml.class);

    @Override
    public Element store(Object o) {
        Element actions = new Element("LogixNGDigitalActions");
        this.setStoreElementClass(actions);
        DigitalActionManager tm = (DigitalActionManager)o;
        if (tm != null) {
            if (tm.getNamedBeanSet().isEmpty()) {
                return null;
            }
            for (MaleDigitalActionSocket action : tm.getNamedBeanSet()) {
                log.debug("action system name is {}", (Object)action.getSystemName());
                try {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    MaleDigitalActionSocket a = action;
                    elements.add(this.storeMaleSocket(a));
                    while (!(a instanceof DefaultMaleDigitalActionSocket)) {
                        a = (MaleDigitalActionSocket)a.getObject();
                    }
                    Element e = ConfigXmlManager.elementFromObject(a.getObject());
                    if (e != null) {
                        for (Element ee : elements) {
                            e.addContent((Content)ee);
                        }
                        actions.addContent((Content)e);
                        continue;
                    }
                    throw new RuntimeException("Cannot load xml configurator for " + a.getObject().getClass().getName());
                }
                catch (RuntimeException e) {
                    log.error("Error storing action: {}", (Object)e, (Object)e);
                }
            }
        }
        return actions;
    }

    public void setStoreElementClass(Element actions) {
        actions.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedAction, Element perNodeAction) {
        this.replaceActionManager();
        this.loadActions(sharedAction);
        return true;
    }

    public void loadActions(Element actions) {
        List actionList = actions.getChildren();
        log.debug("Found {} actions", (Object)actionList.size());
        for (int i = 0; i < actionList.size(); ++i) {
            String className = ((Element)actionList.get(i)).getAttribute("class").getValue();
            Class<?> clazz = this.xmlClasses.get(className);
            if (clazz == null) {
                try {
                    className = ConfigXmlManager.currentClassName(className);
                    clazz = Class.forName(className);
                    this.xmlClasses.put(className, clazz);
                }
                catch (ClassNotFoundException ex) {
                    log.error("cannot load class {}", (Object)className, (Object)ex);
                }
            }
            if (clazz == null) continue;
            Constructor<?> c = null;
            try {
                c = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                log.error("cannot create constructor", (Throwable)ex);
            }
            if (c == null) continue;
            try {
                AbstractNamedBeanManagerConfigXML o = (AbstractNamedBeanManagerConfigXML)c.newInstance(new Object[0]);
                MaleSocket oldLastItem = InstanceManager.getDefault(DigitalActionManager.class).getLastRegisteredMaleSocket();
                o.load((Element)actionList.get(i), null);
                MaleSocket newLastItem = InstanceManager.getDefault(DigitalActionManager.class).getLastRegisteredMaleSocket();
                if (newLastItem == oldLastItem) {
                    throw new RuntimeException("No new bean has been added. This class: " + this.getClass().getName());
                }
                this.loadMaleSocket((Element)actionList.get(i), newLastItem);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                log.error("cannot create object", (Throwable)ex);
                continue;
            }
            catch (JmriConfigureXmlException ex) {
                log.error("cannot load action", (Throwable)ex);
            }
        }
    }

    protected void replaceActionManager() {
        ConfigureManager cmOD;
        if (InstanceManager.getDefault(DigitalActionManager.class).getClass().getName().equals(DefaultDigitalActionManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(DigitalActionManager.class) != null && (cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(InstanceManager.getDefault(DigitalActionManager.class));
        }
        ThreadingUtil.runOnGUI(() -> {
            DefaultDigitalActionManager pManager = DefaultDigitalActionManager.instance();
            InstanceManager.store(pManager, DigitalActionManager.class);
            ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cmOD != null) {
                cmOD.registerConfig(pManager, 330);
            }
        });
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(DigitalActionManager.class).getXMLOrder();
    }
}

