/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleDigitalExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.DefaultDigitalExpressionManager;
import jmri.jmrit.logixng.implementation.DefaultMaleDigitalExpressionSocket;
import jmri.jmrit.logixng.implementation.configurexml.AbstractManagerXml;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.ThreadingUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDigitalExpressionManagerXml
extends AbstractManagerXml {
    private final Map<String, Class<?>> xmlClasses = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(DefaultDigitalExpressionManagerXml.class);

    @Override
    public Element store(Object o) {
        Element expressions = new Element("LogixNGDigitalExpressions");
        this.setStoreElementClass(expressions);
        DigitalExpressionManager tm = (DigitalExpressionManager)o;
        if (tm != null) {
            if (tm.getNamedBeanSet().isEmpty()) {
                return null;
            }
            for (MaleDigitalExpressionSocket expression : tm.getNamedBeanSet()) {
                log.debug("action system name is {}", (Object)expression.getSystemName());
                try {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    MaleDigitalExpressionSocket a = expression;
                    elements.add(this.storeMaleSocket(a));
                    while (!(a instanceof DefaultMaleDigitalExpressionSocket)) {
                        a = (MaleDigitalExpressionSocket)a.getObject();
                    }
                    Element e = ConfigXmlManager.elementFromObject(a.getObject());
                    if (e != null) {
                        for (Element ee : elements) {
                            e.addContent((Content)ee);
                        }
                        expressions.addContent((Content)e);
                        continue;
                    }
                    throw new RuntimeException("Cannot load xml configurator for " + a.getObject().getClass().getName());
                }
                catch (RuntimeException e) {
                    log.error("Error storing action: {}", (Object)e, (Object)e);
                }
            }
        }
        return expressions;
    }

    public void setStoreElementClass(Element expressions) {
        expressions.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedExpression, Element perNodeExpression) {
        this.replaceExpressionManager();
        this.loadExpressions(sharedExpression);
        return true;
    }

    public void loadExpressions(Element expressions) {
        List expressionList = expressions.getChildren();
        log.debug("Found {} expressions", (Object)expressionList.size());
        for (int i = 0; i < expressionList.size(); ++i) {
            String className = ((Element)expressionList.get(i)).getAttribute("class").getValue();
            Class<?> clazz = this.xmlClasses.get(className);
            if (clazz == null) {
                try {
                    className = ConfigXmlManager.currentClassName(className);
                    clazz = Class.forName(className);
                    this.xmlClasses.put(className, clazz);
                }
                catch (ClassNotFoundException ex) {
                    log.error("cannot load class {}", (Object)className, (Object)ex);
                }
            }
            if (clazz == null) continue;
            Constructor<?> c = null;
            try {
                c = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                log.error("cannot create constructor", (Throwable)ex);
            }
            if (c == null) continue;
            try {
                AbstractNamedBeanManagerConfigXML o = (AbstractNamedBeanManagerConfigXML)c.newInstance(new Object[0]);
                MaleSocket oldLastItem = InstanceManager.getDefault(DigitalExpressionManager.class).getLastRegisteredMaleSocket();
                o.load((Element)expressionList.get(i), null);
                MaleSocket newLastItem = InstanceManager.getDefault(DigitalExpressionManager.class).getLastRegisteredMaleSocket();
                if (newLastItem == oldLastItem) {
                    throw new RuntimeException("No new bean has been added. This class: " + this.getClass().getName() + ", new class: " + className);
                }
                this.loadMaleSocket((Element)expressionList.get(i), newLastItem);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                log.error("cannot create object", (Throwable)ex);
                continue;
            }
            catch (JmriConfigureXmlException ex) {
                log.error("cannot load action", (Throwable)ex);
            }
        }
    }

    protected void replaceExpressionManager() {
        ConfigureManager cmOD;
        if (InstanceManager.getDefault(DigitalExpressionManager.class).getClass().getName().equals(DefaultDigitalExpressionManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(DigitalExpressionManager.class) != null && (cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(InstanceManager.getDefault(DigitalExpressionManager.class));
        }
        ThreadingUtil.runOnGUI(() -> {
            DefaultDigitalExpressionManager pManager = DefaultDigitalExpressionManager.instance();
            InstanceManager.store(pManager, DigitalExpressionManager.class);
            ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cmOD != null) {
                cmOD.registerConfig(pManager, 320);
            }
        });
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(DigitalExpressionManager.class).getXMLOrder();
    }
}

