/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.implementation.DefaultModuleManager;
import jmri.jmrit.logixng.implementation.configurexml.AbstractManagerXml;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.ThreadingUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleManagerXml
extends AbstractManagerXml {
    private final Map<String, Class<?>> xmlClasses = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(DefaultModuleManagerXml.class);

    @Override
    public Element store(Object o) {
        Element expressions = new Element("LogixNGModules");
        this.setStoreElementClass(expressions);
        DefaultModuleManager tm = (DefaultModuleManager)o;
        if (tm != null) {
            if (tm.getNamedBeanSet().isEmpty()) {
                return null;
            }
            for (Module module : tm.getNamedBeanSet()) {
                try {
                    Element e = ConfigXmlManager.elementFromObject(module);
                    if (e == null) continue;
                    expressions.addContent((Content)e);
                }
                catch (RuntimeException e) {
                    log.error("Error storing action: {}", (Object)e, (Object)e);
                }
            }
        }
        return expressions;
    }

    public void setStoreElementClass(Element expressions) {
        expressions.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedExpression, Element perNodeExpression) {
        this.replaceExpressionManager();
        this.loadTables(sharedExpression);
        return true;
    }

    public void loadTables(Element expressions) {
        List expressionList = expressions.getChildren();
        log.debug("Found {} tables", (Object)expressionList.size());
        for (int i = 0; i < expressionList.size(); ++i) {
            String className = ((Element)expressionList.get(i)).getAttribute("class").getValue();
            Class<?> clazz = this.xmlClasses.get(className);
            if (clazz == null) {
                try {
                    clazz = Class.forName(className);
                    this.xmlClasses.put(className, clazz);
                }
                catch (ClassNotFoundException ex) {
                    log.error("cannot load class {}", (Object)className, (Object)ex);
                }
            }
            if (clazz == null) continue;
            Constructor<?> c = null;
            try {
                c = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                log.error("cannot create constructor", (Throwable)ex);
            }
            if (c == null) continue;
            try {
                AbstractNamedBeanManagerConfigXML o = (AbstractNamedBeanManagerConfigXML)c.newInstance(new Object[0]);
                o.load((Element)expressionList.get(i), null);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                log.error("cannot create object", (Throwable)ex);
                continue;
            }
            catch (JmriConfigureXmlException ex) {
                log.error("cannot load action", (Throwable)ex);
            }
        }
    }

    protected void replaceExpressionManager() {
        ConfigureManager cmOD;
        if (InstanceManager.getDefault(ModuleManager.class).getClass().getName().equals(DefaultModuleManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(ModuleManager.class) != null && (cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(InstanceManager.getDefault(ModuleManager.class));
        }
        ThreadingUtil.runOnGUI(() -> {
            DefaultModuleManager pManager = DefaultModuleManager.instance();
            InstanceManager.store(pManager, ModuleManager.class);
            ConfigureManager cmOD = InstanceManager.getNullableDefault(ConfigureManager.class);
            if (cmOD != null) {
                cmOD.registerConfig(pManager, 300);
            }
        });
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(ModuleManager.class).getXMLOrder();
    }
}

