/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.implementation.AbstractMaleSocket;
import jmri.jmrit.logixng.implementation.swing.Bundle;
import jmri.jmrit.logixng.swing.AbstractSwingConfigurator;
import jmri.util.swing.JComboBoxUtil;

public abstract class AbstractMaleSocketSwing
extends AbstractSwingConfigurator {
    private JPanel panel;
    private final JLabel errorHandlingLabel = new JLabel(Bundle.getMessage("MaleSocket_ErrorHandlingLabel"));
    private final JLabel catchAbortExecutionLabel = new JLabel(Bundle.getMessage("MaleSocket_CatchAbortExecutionCheckBox"));
    private final JComboBox<MaleSocket.ErrorHandlingType> errorHandlingComboBox = new JComboBox();
    private final JCheckBox catchAbortExecutionCheckBox = new JCheckBox();
    private JPanel subPanel;

    protected JPanel getSubPanel(@CheckForNull Base object) {
        return null;
    }

    @Override
    public BaseManager<? extends NamedBean> getManager() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public final JPanel getConfigPanel(@Nonnull JPanel buttonPanel) throws IllegalArgumentException {
        this.createPanel(null, buttonPanel);
        return this.panel;
    }

    @Override
    public final JPanel getConfigPanel(@Nonnull Base object, @Nonnull JPanel buttonPanel) throws IllegalArgumentException {
        this.createPanel(object, buttonPanel);
        return this.panel;
    }

    protected final void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (object != null && !(object instanceof AbstractMaleSocket)) {
            throw new IllegalArgumentException("object is not an AbstractMaleSocket: " + object.getClass().getName());
        }
        this.panel = new JPanel();
        AbstractMaleSocket maleSocket = (AbstractMaleSocket)object;
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        this.panel.add((Component)this.errorHandlingLabel, c);
        c.gridx = 1;
        for (MaleSocket.ErrorHandlingType type : MaleSocket.ErrorHandlingType.values()) {
            this.errorHandlingComboBox.addItem(type);
            if (maleSocket == null || maleSocket.getErrorHandlingType() != type) continue;
            this.errorHandlingComboBox.setSelectedItem((Object)type);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.errorHandlingComboBox);
        this.panel.add(this.errorHandlingComboBox, c);
        c.gridx = 0;
        c.gridy = 1;
        this.panel.add((Component)this.catchAbortExecutionLabel, c);
        c.gridx = 1;
        c.fill = 2;
        if (maleSocket != null) {
            this.catchAbortExecutionCheckBox.setSelected(maleSocket.getCatchAbortExecution());
        }
        this.catchAbortExecutionLabel.setLabelFor(this.catchAbortExecutionCheckBox);
        this.panel.add((Component)this.catchAbortExecutionCheckBox, c);
        this.subPanel = this.getSubPanel(object);
        if (this.subPanel != null) {
            JPanel thisPanel = this.panel;
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(thisPanel);
            this.panel.add(this.subPanel);
        }
    }

    @Override
    public final boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        throw new UnsupportedOperationException("Not supported");
    }

    protected void updateObjectForSubPanel(@Nonnull Base object) {
    }

    @Override
    public final void updateObject(@Nonnull Base object) {
        if (!(object instanceof AbstractMaleSocket)) {
            throw new IllegalArgumentException("object is not an AbstractMaleSocket: " + object.getClass().getName());
        }
        AbstractMaleSocket maleSocket = (AbstractMaleSocket)object;
        maleSocket.setErrorHandlingType(this.errorHandlingComboBox.getItemAt(this.errorHandlingComboBox.getSelectedIndex()));
        maleSocket.setCatchAbortExecution(this.catchAbortExecutionCheckBox.isSelected());
        this.updateObjectForSubPanel(object);
    }

    @Override
    public String getExampleSystemName() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getAutoSystemName() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public final void dispose() {
    }
}

