/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.implementation.swing;

import java.awt.Dimension;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.implementation.swing.Bundle;
import jmri.jmrit.logixng.swing.AbstractSwingConfigurator;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.swing.SwingTools;
import jmri.jmrit.logixng.tools.swing.swing.ModuleParametersTableModel;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;

public class DefaultModuleSwing
extends AbstractSwingConfigurator {
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.logixng.tools.swing.LogixNGSwingBundle");
    protected JPanel panel;
    ModuleParametersTableModel _moduleParametersTableModel;

    @Override
    public String getExecuteEvaluateMenuText() {
        return Bundle.getMessage("MenuText_ExecuteEvaluate");
    }

    @Override
    public void executeEvaluate(@Nonnull Base object) {
        if (!(object instanceof MaleSocket)) {
            throw new IllegalArgumentException("object is not a MaleSocket");
        }
        if (!(((MaleSocket)object).getObject() instanceof Module)) {
            throw new IllegalArgumentException("((MaleSocket)object).getObject() is not a Module");
        }
        Module module = (Module)((MaleSocket)object).getObject();
        FemaleSocket femaleSocket = module.getRootSocket();
        if (!femaleSocket.isConnected()) {
            ThreadingUtil.runOnGUIEventually(() -> JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExecuteEvaluate_ActionCompleted"), Bundle.getMessage("ExecuteEvaluate_Title"), -1));
            return;
        }
        Base obj = femaleSocket.getConnectedSocket();
        if (obj == null) {
            throw new NullPointerException("object is null");
        }
        while (obj instanceof MaleSocket) {
            obj = obj.getObject();
        }
        SwingConfiguratorInterface swi = SwingTools.getSwingConfiguratorForClass(obj.getClass());
        swi.executeEvaluate(femaleSocket.getConnectedSocket());
    }

    @Override
    public BaseManager<? extends NamedBean> getManager() {
        return null;
    }

    @Override
    public JPanel getConfigPanel(@Nonnull JPanel buttonPanel) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public JPanel getConfigPanel(@Nonnull Base object, @Nonnull JPanel buttonPanel) throws IllegalArgumentException {
        this.createPanel(object, buttonPanel);
        return this.panel;
    }

    @Override
    public String getExampleSystemName() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getAutoSystemName() {
        throw new UnsupportedOperationException("Not supported");
    }

    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        if (!(object instanceof Module)) {
            throw new IllegalArgumentException("object is not a Module: " + object.getClass().getName());
        }
        Module module = (Module)object;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JTable table = new JTable();
        this._moduleParametersTableModel = new ModuleParametersTableModel(module);
        table.setModel(this._moduleParametersTableModel);
        table.setDefaultRenderer(SymbolTable.InitialValueType.class, new ModuleParametersTableModel.TypeCellRenderer());
        table.setDefaultEditor(SymbolTable.InitialValueType.class, new ModuleParametersTableModel.TypeCellEditor());
        table.setDefaultRenderer(ModuleParametersTableModel.Menu.class, new ModuleParametersTableModel.MenuCellRenderer());
        table.setDefaultEditor(ModuleParametersTableModel.Menu.class, new ModuleParametersTableModel.MenuCellEditor(table, this._moduleParametersTableModel));
        this._moduleParametersTableModel.setColumnForMenu(table);
        JScrollPane scrollpane = new JScrollPane(table);
        scrollpane.setPreferredSize(new Dimension(400, 200));
        this.panel.add(scrollpane);
        JButton add = new JButton(Bundle.getMessage("TableAddParameter"));
        buttonPanel.add(add);
        add.addActionListener(e -> this._moduleParametersTableModel.add());
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        boolean hasErrors = false;
        for (DefaultSymbolTable.DefaultParameter p : this._moduleParametersTableModel.getParameters()) {
            if (p.getName().isEmpty()) {
                errorMessages.add(Bundle.getMessage("ParameterNameIsEmpty", p.getName()));
                hasErrors = true;
            } else if (!SymbolTable.validateName(p.getName())) {
                errorMessages.add(Bundle.getMessage("ParameterNameIsNotValid", p.getName()));
                hasErrors = true;
            }
            if (p.isInput() || p.isOutput()) continue;
            errorMessages.add(Bundle.getMessage("ParameterIsNotInNorOut", p.getName()));
            hasErrors = true;
        }
        return !hasErrors;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof Module)) {
            throw new IllegalArgumentException("object is not a Module: " + object.getClass().getName());
        }
        Module module = (Module)object;
        module.getParameters().clear();
        for (Module.Parameter parameter : this._moduleParametersTableModel.getParameters()) {
            module.addParameter(parameter);
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("DefaultModule_Short");
    }

    @Override
    public void dispose() {
    }
}

