/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.swing;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.NamedBean;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.util.JmriJFrame;
import jmri.util.swing.BeanSelectPanel;

public class LogixNG_DataDialog {
    private final SwingConfiguratorInterface _swi;
    private JmriJFrame _showDialogFrame;
    private Runnable _runOnOk;
    private JTabbedPane _tabbedPane;
    private BeanSelectPanel<? extends NamedBean> _beanPanel;
    private JComboBox<? extends Object> _beanComboBox;
    private JTextField _beanTextField;
    private JPanel _panelDirect;
    private JPanel _panelReference;
    private JPanel _panelLocalVariable;
    private JPanel _panelFormula;
    private JTextField _beanReferenceTextField;
    private JTextField _beanLocalVariableTextField;
    private JTextField _beanFormulaTextField;

    public LogixNG_DataDialog(SwingConfiguratorInterface swi) {
        this._swi = swi;
    }

    public void showDialog(String title, NamedBeanAddressing addressing, BeanSelectPanel<? extends NamedBean> beanPanel, JTextField referenceTextField, JTextField localVariableTextField, JTextField formulaTextField, Runnable runOnOk) {
        if (this.checkOpenDialog()) {
            return;
        }
        this._beanPanel = beanPanel;
        this._beanComboBox = null;
        this._beanTextField = null;
        this.showDialog(title, addressing, referenceTextField, localVariableTextField, formulaTextField, runOnOk);
    }

    public void showDialog(String title, NamedBeanAddressing addressing, JComboBox<? extends Object> comboBox, JTextField referenceTextField, JTextField localVariableTextField, JTextField formulaTextField, Runnable runOnOk) {
        if (this.checkOpenDialog()) {
            return;
        }
        this._beanPanel = null;
        this._beanComboBox = comboBox;
        this._beanTextField = null;
        this.showDialog(title, addressing, referenceTextField, localVariableTextField, formulaTextField, runOnOk);
    }

    public void showDialog(String title, NamedBeanAddressing addressing, JTextField textField, JTextField referenceTextField, JTextField localVariableTextField, JTextField formulaTextField, Runnable runOnOk) {
        if (this.checkOpenDialog()) {
            return;
        }
        this._beanPanel = null;
        this._beanComboBox = null;
        this._beanTextField = textField;
        this.showDialog(title, addressing, referenceTextField, localVariableTextField, formulaTextField, runOnOk);
    }

    private void showDialog(String title, NamedBeanAddressing addressing, JTextField referenceTextField, JTextField localVariableTextField, JTextField formulaTextField, Runnable runOnOk) {
        this._beanReferenceTextField = referenceTextField;
        this._beanLocalVariableTextField = localVariableTextField;
        this._beanFormulaTextField = formulaTextField;
        this._runOnOk = runOnOk;
        this._showDialogFrame = new JmriJFrame(title);
        this._showDialogFrame.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this._showDialogFrame.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this._showDialogFrame.getHeight() / 2);
        Container contentPane = this._showDialogFrame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this._tabbedPane = new JTabbedPane();
        this._panelDirect = new JPanel();
        this._panelReference = new JPanel();
        this._panelLocalVariable = new JPanel();
        this._panelFormula = new JPanel();
        this._tabbedPane.addTab(NamedBeanAddressing.Direct.toString(), this._panelDirect);
        this._tabbedPane.addTab(NamedBeanAddressing.Reference.toString(), this._panelReference);
        this._tabbedPane.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLocalVariable);
        this._tabbedPane.addTab(NamedBeanAddressing.Formula.toString(), this._panelFormula);
        switch (addressing) {
            case Direct: {
                this._tabbedPane.setSelectedComponent(this._panelDirect);
                break;
            }
            case Reference: {
                this._tabbedPane.setSelectedComponent(this._panelReference);
                break;
            }
            case LocalVariable: {
                this._tabbedPane.setSelectedComponent(this._panelLocalVariable);
                break;
            }
            case Formula: {
                this._tabbedPane.setSelectedComponent(this._panelFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid addressing: " + addressing.name());
            }
        }
        if (this._beanPanel != null) {
            this._panelDirect.add(this._beanPanel);
        } else if (this._beanComboBox != null) {
            this._panelDirect.add(this._beanComboBox);
        } else if (this._beanTextField != null) {
            this._panelDirect.add(this._beanTextField);
        }
        this._panelReference.add(this._beanReferenceTextField);
        this._panelLocalVariable.add(this._beanLocalVariableTextField);
        this._panelFormula.add(this._beanFormulaTextField);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(this::cancelDialogPressed);
        JButton okButton = new JButton(Bundle.getMessage("ButtonOK"));
        panel5.add(okButton);
        okButton.addActionListener(e -> {
            this._showDialogFrame.setVisible(false);
            this._showDialogFrame.dispose();
            this._showDialogFrame = null;
            if (this._swi.getJDialog() != null) {
                this._swi.getJDialog().setVisible(true);
            }
            this._runOnOk.run();
        });
        this._showDialogFrame.add(this._tabbedPane);
        this._showDialogFrame.add(panel5);
        this._showDialogFrame.pack();
        this._showDialogFrame.setVisible(true);
    }

    public NamedBeanAddressing getAddressing() {
        if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            return NamedBeanAddressing.Direct;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
            return NamedBeanAddressing.Reference;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
            return NamedBeanAddressing.LocalVariable;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
            return NamedBeanAddressing.Formula;
        }
        throw new IllegalArgumentException("_tabbedPane has unknown selection");
    }

    public boolean checkOpenDialog() {
        if (this._showDialogFrame != null) {
            this._showDialogFrame.requestFocus();
            return true;
        }
        return false;
    }

    void cancelDialogPressed(ActionEvent e) {
        this._showDialogFrame.setVisible(false);
        this._showDialogFrame.dispose();
        this._showDialogFrame = null;
        if (this._swi.getJDialog() != null) {
            this._swi.getJDialog().setVisible(true);
        }
    }

    public void dispose() {
        if (this._showDialogFrame != null) {
            this._showDialogFrame.setVisible(false);
            this._showDialogFrame.dispose();
        }
    }
}

