/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.tools.debugger.AbstractDebuggerMaleSocket;
import jmri.jmrit.logixng.tools.debugger.Debugger;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.tools.swing.DebuggerSymbolTableModel;
import jmri.jmrit.logixng.tools.swing.TreePane;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConditionalNGDebugger
extends JmriJFrame
implements PropertyChangeListener {
    private static final int panelWidth = 700;
    private static final int panelHeight = 500;
    private final Debugger _debugger = InstanceManager.getDefault(Debugger.class);
    private final JPanel _currentTreePanePanel;
    private final TreePane _conditionalNG_TreePane;
    private TreePane _currentTreePane;
    private final List<TreePane> _treePanes = new ArrayList<TreePane>();
    private final JMenuItem _execute;
    private final JMenuItem _runItem;
    private final JMenuItem _stepOverItem;
    private final JMenuItem _stepIntoItem;
    private final TreePane.FemaleSocketDecorator _decorator;
    private final ConditionalNG _conditionalNG;
    private Deque<Module> _lastModuleStack = new LinkedList<Module>();
    private Module _currentModule;
    private AbstractDebuggerMaleSocket _currentMaleSocket;
    private State _currentState = State.None;
    private boolean _run = false;
    private MaleSocket _rootSocket;
    private final JLabel _actionExpressionInfoLabel = new JLabel();
    private final Object _lock = new Object();
    private boolean _continue = false;
    private final DebuggerSymbolTableModel _symbolTableModel;
    private final List<ConditionalNGEventListener> listenerList = new ArrayList<ConditionalNGEventListener>();
    final Map<String, String> logixNGData = new HashMap<String, String>();
    private static final Logger log = LoggerFactory.getLogger(ConditionalNGDebugger.class);

    public ConditionalNGDebugger(@Nonnull ConditionalNG conditionalNG) {
        this._conditionalNG = conditionalNG;
        this._decorator = (femaleSocket, panel) -> {
            if (femaleSocket.isConnected()) {
                MaleSocket maleSocket = femaleSocket.getConnectedSocket();
                AbstractDebuggerMaleSocket debugMaleSocket = (AbstractDebuggerMaleSocket)maleSocket.find(AbstractDebuggerMaleSocket.class);
                if (debugMaleSocket == null) {
                    throw new RuntimeException("AbstractDebuggerMaleSocket is not found");
                }
                boolean breakpointBefore = debugMaleSocket.getBreakpointBefore();
                boolean breakpointAfter = debugMaleSocket.getBreakpointAfter();
                if (breakpointBefore || breakpointAfter) {
                    JPanel newPanel = new JPanel();
                    newPanel.setBorder(BorderFactory.createMatteBorder(breakpointBefore ? 5 : 1, 5, breakpointAfter ? 5 : 1, 1, Color.red));
                    newPanel.add(panel);
                    panel = newPanel;
                }
            }
            if (this._currentMaleSocket != null) {
                Base parent;
                for (parent = this._currentMaleSocket.getParent(); parent != null && !(parent instanceof FemaleSocket); parent = parent.getParent()) {
                }
                if (parent == femaleSocket) {
                    JPanel newPanel = new JPanel();
                    switch (this._currentState) {
                        case Before: {
                            newPanel.setBorder(BorderFactory.createMatteBorder(8, 5, 1, 1, Color.black));
                            break;
                        }
                        case After: {
                            newPanel.setBorder(BorderFactory.createMatteBorder(1, 5, 8, 1, Color.black));
                            break;
                        }
                        default: {
                            return panel;
                        }
                    }
                    newPanel.add(panel);
                    return newPanel;
                }
            }
            return panel;
        };
        this._conditionalNG_TreePane = new TreePane(conditionalNG.getFemaleSocket());
        this._conditionalNG_TreePane.initComponents(this._decorator);
        this._currentTreePanePanel = new JPanel(new CardLayout());
        this._currentTreePane = this._conditionalNG_TreePane;
        this._currentTreePanePanel.add(this._conditionalNG.getSystemName(), this._conditionalNG_TreePane);
        this._treePanes.add(this._conditionalNG_TreePane);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        JMenuItem closeWindowItem = new JMenuItem(Bundle.getMessage("CloseWindow"));
        closeWindowItem.addActionListener(e -> this.dispose());
        fileMenu.add(closeWindowItem);
        menuBar.add(fileMenu);
        JMenu debugMenu = new JMenu(Bundle.getMessage("Debug_MenuDebug"));
        this._execute = new JMenuItem(Bundle.getMessage("Debug_MenuItem_Execute"));
        this._execute.addActionListener(event -> this._conditionalNG.execute());
        debugMenu.add(this._execute);
        debugMenu.addSeparator();
        this._runItem = new JMenuItem(Bundle.getMessage("Debug_MenuItem_Run"));
        this._runItem.addActionListener(event -> this.doRun());
        this._runItem.setAccelerator(KeyStroke.getKeyStroke(118, 2));
        this._runItem.setEnabled(false);
        debugMenu.add(this._runItem);
        this._stepOverItem = new JMenuItem(Bundle.getMessage("Debug_MenuItem_StepOver"));
        this._stepOverItem.addActionListener(e -> this.doStepOver());
        this._stepOverItem.setAccelerator(KeyStroke.getKeyStroke(118, 1));
        this._stepOverItem.setEnabled(false);
        debugMenu.add(this._stepOverItem);
        this._stepIntoItem = new JMenuItem(Bundle.getMessage("Debug_MenuItem_StepInto"));
        this._stepIntoItem.addActionListener(e -> this.doStepInto());
        this._stepIntoItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this._stepIntoItem.setEnabled(false);
        debugMenu.add(this._stepIntoItem);
        menuBar.add(debugMenu);
        this.setJMenuBar(menuBar);
        this.setTitle((Module)null);
        JPanel actionExpressionInfo = new JPanel();
        actionExpressionInfo.add(this._actionExpressionInfoLabel);
        JScrollPane actionExpressionInfoScrollPane = new JScrollPane(actionExpressionInfo);
        actionExpressionInfoScrollPane.setPreferredSize(new Dimension(400, 200));
        JTable table = new JTable();
        this._symbolTableModel = new DebuggerSymbolTableModel();
        table.setModel(this._symbolTableModel);
        JScrollPane variableScrollPane = new JScrollPane(table);
        JSplitPane variableSplitPane = new JSplitPane(0, actionExpressionInfoScrollPane, variableScrollPane);
        variableSplitPane.setOneTouchExpandable(true);
        variableSplitPane.setDividerLocation(50);
        JPanel watchPanel = new JPanel();
        JScrollPane watchScrollPane = new JScrollPane(watchPanel);
        JSplitPane watchSplitPane = new JSplitPane(0, variableSplitPane, watchScrollPane);
        watchSplitPane.setOneTouchExpandable(true);
        watchSplitPane.setDividerLocation(150);
        Dimension minimumWatchSize = new Dimension(100, 150);
        variableScrollPane.setMinimumSize(minimumWatchSize);
        watchScrollPane.setMinimumSize(minimumWatchSize);
        JSplitPane mainSplitPane = new JSplitPane(1, this._currentTreePanePanel, watchSplitPane);
        mainSplitPane.setOneTouchExpandable(true);
        mainSplitPane.setDividerLocation(150);
        Dimension minimumMainSize = new Dimension(100, 50);
        this._currentTreePanePanel.setMinimumSize(minimumMainSize);
        watchSplitPane.setMinimumSize(minimumMainSize);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(mainSplitPane);
        this.initMinimumSize(new Dimension(700, 500));
        this._debugger.addPropertyChangeListener(this);
        this._debugger.setBreak(true);
        this._debugger.activateDebugger(conditionalNG);
        PopupMenu popup = new PopupMenu();
        popup.init();
    }

    private void setTitle(Module module) {
        if (module != null) {
            if (this._conditionalNG.getUserName() == null) {
                if (module.getUserName() == null) {
                    this.setTitle(Bundle.getMessage("TitleDebugConditionalNG_Module", this._conditionalNG.getSystemName(), module.getSystemName()));
                } else {
                    this.setTitle(Bundle.getMessage("TitleDebugConditionalNG_Module", this._conditionalNG.getSystemName(), module.getSystemName(), module.getUserName()));
                }
            } else if (module.getUserName() == null) {
                this.setTitle(Bundle.getMessage("TitleDebugConditionalNG2_Module", this._conditionalNG.getSystemName(), this._conditionalNG.getUserName(), module.getSystemName()));
            } else {
                this.setTitle(Bundle.getMessage("TitleDebugConditionalNG2_Module", this._conditionalNG.getSystemName(), this._conditionalNG.getUserName(), module.getSystemName(), module.getUserName()));
            }
        } else if (this._conditionalNG.getUserName() == null) {
            this.setTitle(Bundle.getMessage("TitleDebugConditionalNG", this._conditionalNG.getSystemName()));
        } else {
            this.setTitle(Bundle.getMessage("TitleDebugConditionalNG2", this._conditionalNG.getSystemName(), this._conditionalNG.getUserName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStepOver() {
        AbstractDebuggerMaleSocket maleSocket = this._currentMaleSocket;
        if (this._currentState == State.After && this._rootSocket == this._currentMaleSocket) {
            this._run = false;
            this._runItem.setEnabled(false);
        }
        this._currentMaleSocket.setStepInto(false);
        this._currentMaleSocket = null;
        this._currentState = State.None;
        this._stepOverItem.setEnabled(false);
        this._stepIntoItem.setEnabled(false);
        this._currentTreePane.updateTree(maleSocket);
        Object object = this._lock;
        synchronized (object) {
            this._continue = true;
            this._lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStepInto() {
        AbstractDebuggerMaleSocket maleSocket = this._currentMaleSocket;
        if (this._currentState == State.After && this._rootSocket == this._currentMaleSocket) {
            this._run = false;
            this._runItem.setEnabled(false);
        }
        this._currentMaleSocket.setStepInto(true);
        this._currentMaleSocket = null;
        this._currentState = State.None;
        this._stepOverItem.setEnabled(false);
        this._stepIntoItem.setEnabled(false);
        this._currentTreePane.updateTree(maleSocket);
        Object object = this._lock;
        synchronized (object) {
            this._continue = true;
            this._lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        this._run = true;
        if (this._currentMaleSocket != null) {
            AbstractDebuggerMaleSocket maleSocket = this._currentMaleSocket;
            if (this._currentState == State.After && this._rootSocket == this._currentMaleSocket) {
                this._run = false;
                this._runItem.setEnabled(false);
            }
            this._currentMaleSocket.setStepInto(false);
            this._currentMaleSocket = null;
            this._currentState = State.None;
            this._stepOverItem.setEnabled(false);
            this._stepIntoItem.setEnabled(false);
            this._currentTreePane.updateTree(maleSocket);
            Object object = this._lock;
            synchronized (object) {
                this._continue = true;
                this._lock.notify();
            }
        }
    }

    public void initMinimumSize(Dimension dimension) {
        this.setMinimumSize(dimension);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.doRun();
        this._debugger.removePropertyChangeListener(this);
        this._debugger.deActivateDebugger();
        this.logixNGData.clear();
        this.logixNGData.put("Finish", this._conditionalNG.getSystemName());
        this.fireLogixNGEvent();
    }

    public void addLogixNGEventListener(ConditionalNGEventListener listener) {
        this.listenerList.add(listener);
    }

    void fireLogixNGEvent() {
        for (ConditionalNGEventListener l : this.listenerList) {
            l.conditionalNGEventOccurred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("StepBefore".equals(evt.getPropertyName()) || "StepAfter".equals(evt.getPropertyName())) {
            String infoString = "";
            this._currentMaleSocket = (AbstractDebuggerMaleSocket)evt.getNewValue();
            if (this._rootSocket == null) {
                this._rootSocket = this._currentMaleSocket;
            }
            AtomicBoolean enableMenuItems = new AtomicBoolean(true);
            Module module = this._currentMaleSocket.getModule();
            if (module != this._currentModule) {
                this.setTitle(module);
                if (!this._lastModuleStack.isEmpty() && module == this._lastModuleStack.peek()) {
                    this._currentTreePanePanel.remove(this._currentTreePane);
                    this._treePanes.remove(this._treePanes.size() - 1);
                    this._currentTreePane = this._treePanes.get(this._treePanes.size() - 1);
                    if (module != null) {
                        ((CardLayout)this._currentTreePanePanel.getLayout()).show(this._currentTreePanePanel, module.getSystemName());
                    } else {
                        ((CardLayout)this._currentTreePanePanel.getLayout()).show(this._currentTreePanePanel, this._conditionalNG.getSystemName());
                    }
                    this._lastModuleStack.pop();
                } else {
                    if (module == null) {
                        throw new NullPointerException("module is null");
                    }
                    this._lastModuleStack.push(this._currentModule);
                    this._currentTreePane = new TreePane(module.getRootSocket());
                    this._currentTreePane.initComponents(this._decorator);
                    this._treePanes.add(this._currentTreePane);
                    this._currentTreePanePanel.add(module.getSystemName(), this._currentTreePane);
                    ((CardLayout)this._currentTreePanePanel.getLayout()).show(this._currentTreePanePanel, module.getSystemName());
                }
                this._currentModule = module;
            }
            switch (evt.getPropertyName()) {
                case "StepBefore": {
                    this._currentState = !this._run || this._currentMaleSocket.getBreakpointBefore() ? State.Before : State.None;
                    infoString = this._currentMaleSocket.getBeforeInfo();
                    break;
                }
                case "StepAfter": {
                    if (!this._run || this._currentMaleSocket.getBreakpointAfter()) {
                        this._currentState = State.After;
                    } else {
                        if (this._rootSocket == this._currentMaleSocket) {
                            this._run = false;
                            ThreadingUtil.runOnGUIEventually(() -> {
                                this._runItem.setEnabled(false);
                                this._stepOverItem.setEnabled(false);
                                this._stepIntoItem.setEnabled(false);
                                enableMenuItems.set(false);
                            });
                        }
                        this._currentState = State.None;
                    }
                    infoString = this._currentMaleSocket.getAfterInfo();
                    break;
                }
                default: {
                    this._currentState = State.None;
                }
            }
            DefaultSymbolTable symbolTable = new DefaultSymbolTable(this._conditionalNG.getSymbolTable());
            String infStr = infoString;
            ThreadingUtil.runOnGUIEventually(() -> {
                if (enableMenuItems.get()) {
                    this._runItem.setEnabled(true);
                    this._stepOverItem.setEnabled(true);
                    this._stepIntoItem.setEnabled(true);
                }
                this._actionExpressionInfoLabel.setText(infStr);
                this._currentTreePane.updateTree(this._currentMaleSocket);
                this._symbolTableModel.update(symbolTable);
            });
            if (this._currentState != State.None) {
                try {
                    Object object = this._lock;
                    synchronized (object) {
                        this._continue = false;
                        while (!this._continue) {
                            this._lock.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    log.error("LogixNG thread was interrupted: {}", (Object)this._conditionalNG.getCurrentThread().getThreadName());
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected class PopupMenu
    extends JPopupMenu
    implements ActionListener {
        private static final String ACTION_COMMAND_BREAKPOINT_BEFORE = "breakpoint_before";
        private static final String ACTION_COMMAND_BREAKPOINT_AFTER = "breakpoint_after";
        private final JTree _tree;
        private FemaleSocket _currentFemaleSocket;
        private TreePath _currentPath;
        private JMenuItem menuItemBreakpointBefore;
        private JMenuItem menuItemBreakpointAfter;

        PopupMenu() {
            if (ConditionalNGDebugger.this._currentTreePane._tree == null) {
                throw new IllegalArgumentException("_tree is null");
            }
            this._tree = ConditionalNGDebugger.this._currentTreePane._tree;
        }

        private void init() {
            this.menuItemBreakpointBefore = new JMenuItem(Bundle.getMessage("PopupMenuBreakpointBefore"));
            this.menuItemBreakpointBefore.addActionListener(this);
            this.menuItemBreakpointBefore.setActionCommand(ACTION_COMMAND_BREAKPOINT_BEFORE);
            this.add(this.menuItemBreakpointBefore);
            this.addSeparator();
            this.menuItemBreakpointAfter = new JMenuItem(Bundle.getMessage("PopupMenuBreakpointAfter"));
            this.menuItemBreakpointAfter.addActionListener(this);
            this.menuItemBreakpointAfter.setActionCommand(ACTION_COMMAND_BREAKPOINT_AFTER);
            this.add(this.menuItemBreakpointAfter);
            this.setOpaque(true);
            this.setLightWeightPopupEnabled(true);
            final PopupMenu popupMenu = this;
            this._tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.openPopupMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.openPopupMenu(e);
                }

                private void openPopupMenu(MouseEvent e) {
                    TreePath path;
                    if (e.isPopupTrigger() && !popupMenu.isVisible() && (path = PopupMenu.this._tree.getClosestPathForLocation(e.getX(), e.getY())) != null) {
                        Rectangle rect = PopupMenu.this._tree.getPathBounds(path);
                        if (e.getY() >= rect.y && e.getY() <= rect.y + rect.height) {
                            FemaleSocket femaleSocket = (FemaleSocket)path.getLastPathComponent();
                            PopupMenu.this._tree.getLocationOnScreen();
                            PopupMenu.this._tree.getX();
                            PopupMenu.this.showPopup(e.getX(), e.getY(), femaleSocket, path);
                        }
                    }
                }
            });
        }

        private void showPopup(int x, int y, FemaleSocket femaleSocket, TreePath path) {
            this._currentFemaleSocket = femaleSocket;
            this._currentPath = path;
            boolean isConnected = femaleSocket.isConnected();
            this.menuItemBreakpointBefore.setEnabled(isConnected);
            this.menuItemBreakpointAfter.setEnabled(isConnected);
            this.show(this._tree, x, y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "breakpoint_before": {
                    MaleSocket maleSocket1 = this._currentFemaleSocket.getConnectedSocket();
                    AbstractDebuggerMaleSocket debugMaleSocket1 = (AbstractDebuggerMaleSocket)maleSocket1.find(AbstractDebuggerMaleSocket.class);
                    if (debugMaleSocket1 == null) {
                        throw new RuntimeException("AbstractDebuggerMaleSocket is not found");
                    }
                    debugMaleSocket1.setBreakpointBefore(!debugMaleSocket1.getBreakpointBefore());
                    for (TreeModelListener l : ConditionalNGDebugger.this._currentTreePane.femaleSocketTreeModel.listeners) {
                        TreeModelEvent tme = new TreeModelEvent((Object)this._currentFemaleSocket, this._currentPath.getPath());
                        l.treeNodesChanged(tme);
                    }
                    ConditionalNGDebugger.this._currentTreePane._tree.updateUI();
                    break;
                }
                case "breakpoint_after": {
                    MaleSocket maleSocket2 = this._currentFemaleSocket.getConnectedSocket();
                    AbstractDebuggerMaleSocket debugMaleSocket2 = (AbstractDebuggerMaleSocket)maleSocket2.find(AbstractDebuggerMaleSocket.class);
                    if (debugMaleSocket2 == null) {
                        throw new RuntimeException("AbstractDebuggerMaleSocket is not found");
                    }
                    debugMaleSocket2.setBreakpointAfter(!debugMaleSocket2.getBreakpointAfter());
                    for (TreeModelListener l : ConditionalNGDebugger.this._currentTreePane.femaleSocketTreeModel.listeners) {
                        TreeModelEvent tme = new TreeModelEvent((Object)this._currentFemaleSocket, this._currentPath.getPath());
                        l.treeNodesChanged(tme);
                    }
                    ConditionalNGDebugger.this._currentTreePane._tree.updateUI();
                    break;
                }
            }
        }
    }

    private static enum State {
        None,
        Before,
        After;

    }

    public static interface ConditionalNGEventListener
    extends EventListener {
        public void conditionalNGEventOccurred();
    }
}

