/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.tools.swing.Bundle;

public class DebuggerSymbolTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    private final List<SymbolTable.Symbol> _symbols = new ArrayList<SymbolTable.Symbol>();
    private SymbolTable _symbolTable = null;

    public void update(SymbolTable symbolTable) {
        this._symbolTable = symbolTable;
        this._symbols.clear();
        for (SymbolTable.Symbol s : symbolTable.getSymbols().values()) {
            this._symbols.add(s);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this._symbols.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnSymbolName");
            }
            case 1: {
                return Bundle.getMessage("ColumnSymbolValue");
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this._symbols.size()) {
            throw new IllegalArgumentException("Invalid row");
        }
        switch (columnIndex) {
            case 0: {
                return this._symbols.get(rowIndex).getName();
            }
            case 1: {
                if (this._symbolTable == null) {
                    return "";
                }
                return this._symbolTable.getValue(this._symbols.get(rowIndex).getName());
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }
}

