/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Frame;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Reference;
import jmri.UserPreferencesManager;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteBean<E extends NamedBean> {
    private final Manager<E> _manager;
    private static final Logger log = LoggerFactory.getLogger(DeleteBean.class);

    public DeleteBean(Manager<E> manager) {
        this._manager = manager;
    }

    public void delete(E x, boolean hasChildren, DeleteTask<E> deleteTask, GetListenersRef<E> getListenersRef, String className) {
        this.delete(x, hasChildren, deleteTask, getListenersRef, className, false);
    }

    public boolean delete(E x, boolean hasChildren, DeleteTask<E> deleteTask, GetListenersRef<E> getListenersRef, String className, boolean modal) {
        Reference<Boolean> reference = new Reference<Boolean>(false);
        UserPreferencesManager p = InstanceManager.getNullableDefault(UserPreferencesManager.class);
        StringBuilder message = new StringBuilder();
        try {
            this._manager.deleteBean(x, "CanDelete");
        }
        catch (PropertyVetoException e2) {
            if (e2.getPropertyChangeEvent().getPropertyName().equals("DoNotDelete")) {
                log.warn("{} : Do Not Delete", (Object)e2.getMessage());
                message.append(Bundle.getMessage("VetoDeleteBean", x.getBeanType(), x.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), e2.getMessage()));
                JmriJOptionPane.showMessageDialog(null, message.toString(), Bundle.getMessage("QuestionTitle"), 0);
                return false;
            }
            message.append(e2.getMessage());
        }
        ArrayList<String> listenerRefs = new ArrayList<String>();
        getListenersRef.getListenerRefsIncludingChildren(x, listenerRefs);
        int listenerRefsCount = listenerRefs.size();
        log.debug("Delete with {}", (Object)listenerRefsCount);
        if (p != null && p.getMultipleChoiceOption(className, "deleteLogixNG") == 2 && message.toString().isEmpty()) {
            deleteTask.deleteBean(x);
        } else {
            String prompt;
            JDialog dialog = new JDialog((Frame)null, modal);
            dialog.setTitle(Bundle.getMessage("QuestionTitle"));
            dialog.setDefaultCloseOperation(2);
            JPanel container = new JPanel();
            container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            container.setLayout(new BoxLayout(container, 1));
            if (listenerRefsCount > 0) {
                prompt = hasChildren ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                JLabel question = new JLabel(Bundle.getMessage(prompt, x.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
                question.setAlignmentX(0.5f);
                container.add(question);
                ArrayList<String> listeners = new ArrayList<String>();
                for (String listenerRef : listenerRefs) {
                    if (listeners.contains(listenerRef)) continue;
                    listeners.add(listenerRef);
                }
                message.append("<br>");
                message.append(Bundle.getMessage("ReminderInUse", listenerRefsCount));
                message.append("<ul>");
                for (String listener : listeners) {
                    message.append("<li>");
                    message.append(listener);
                    message.append("</li>");
                }
                message.append("</ul>");
                JEditorPane pane = new JEditorPane();
                pane.setContentType("text/html");
                pane.setText("<html>" + message.toString() + "</html>");
                pane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(pane);
                container.add(jScrollPane);
            } else {
                prompt = hasChildren ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                String msg = MessageFormat.format(Bundle.getMessage(prompt), x.getSystemName());
                JLabel question = new JLabel(msg);
                question.setAlignmentX(0.5f);
                container.add(question);
            }
            JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
            remember.setFont(remember.getFont().deriveFont(10.0f));
            remember.setAlignmentX(0.5f);
            JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
            JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
            JPanel button = new JPanel();
            button.setAlignmentX(0.5f);
            button.add(yesButton);
            button.add(noButton);
            container.add(button);
            noButton.addActionListener(e -> {
                reference.set(false);
                dialog.dispose();
            });
            yesButton.addActionListener(e -> {
                if (remember.isSelected() && p != null) {
                    p.setMultipleChoiceOption(className, "deleteLogixNG", 2);
                }
                deleteTask.deleteBean(x);
                reference.set(true);
                dialog.dispose();
            });
            container.add(remember);
            container.setAlignmentX(0.5f);
            container.setAlignmentY(0.5f);
            dialog.getContentPane().add(container);
            dialog.pack();
            dialog.getRootPane().setDefaultButton(noButton);
            noButton.requestFocusInWindow();
            dialog.getRootPane().registerKeyboardAction(e -> {
                dialog.setVisible(false);
                dialog.dispose();
            }, KeyStroke.getKeyStroke(27, 0), 2);
            dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
        Boolean result = reference.get();
        return result != null && result != false;
    }

    public static interface GetListenersRef<T> {
        public void getListenerRefsIncludingChildren(T var1, List<String> var2);
    }

    public static interface DeleteTask<T> {
        public void deleteBean(T var1);
    }
}

