/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.util.LogixNG_Thread;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class EditThreadsDialog {
    private final ConditionalNG _conditionalNG;
    private JDialog _editThreadsDialog;
    private LogixNG_Thread _newStartupThread;
    private JLabel _startupThreadNameLabel;
    ThreadTableModel _threadTableModel = null;

    public EditThreadsDialog(ConditionalNG conditionalNG) {
        LogixNG_Thread.getThread(0);
        LogixNG_Thread.getThread(1);
        this._conditionalNG = conditionalNG;
        this._newStartupThread = LogixNG_Thread.getThread(this._conditionalNG.getStartupThreadId());
    }

    public void showDialog() {
        this._editThreadsDialog = new JDialog((Dialog)null, Bundle.getMessage("EditThreadsDialog_Title"), true);
        Container contentPane = this._editThreadsDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this._startupThreadNameLabel = new JLabel(Bundle.getMessage("EditThreadsDialog_StartupThreadName", this._newStartupThread.getThreadName()));
        contentPane.add(this._startupThreadNameLabel);
        this._threadTableModel = new ThreadTableModel();
        JTable conditionalTable = new JTable(this._threadTableModel);
        conditionalTable.setRowSelectionAllowed(false);
        TableColumnModel conditionalColumnModel = conditionalTable.getColumnModel();
        TableColumn sNameColumn = conditionalColumnModel.getColumn(0);
        sNameColumn.setResizable(true);
        sNameColumn.setMinWidth(100);
        sNameColumn.setPreferredWidth(130);
        TableColumn uNameColumn = conditionalColumnModel.getColumn(1);
        uNameColumn.setResizable(true);
        uNameColumn.setMinWidth(210);
        uNameColumn.setPreferredWidth(260);
        TableColumn buttonColumn = conditionalColumnModel.getColumn(2);
        TableColumn buttonDeleteColumn = conditionalColumnModel.getColumn(3);
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        conditionalTable.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        conditionalTable.setDefaultEditor(JButton.class, buttonEditor);
        JButton testButton = new JButton("XXXXXX");
        conditionalTable.setRowHeight(testButton.getPreferredSize().height);
        buttonColumn.setMinWidth(testButton.getPreferredSize().width);
        buttonColumn.setMaxWidth(testButton.getPreferredSize().width);
        buttonColumn.setResizable(false);
        buttonDeleteColumn.setMinWidth(testButton.getPreferredSize().width);
        buttonDeleteColumn.setMaxWidth(testButton.getPreferredSize().width);
        buttonDeleteColumn.setResizable(false);
        JScrollPane conditionalTableScrollPane = new JScrollPane(conditionalTable);
        Dimension dim = conditionalTable.getPreferredSize();
        dim.height = 450;
        conditionalTableScrollPane.getViewport().setPreferredSize(dim);
        contentPane.add(conditionalTableScrollPane);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        contentPane.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton addThread = new JButton(Bundle.getMessage("EditThreadsDialog_ButtonAddThread"));
        panel5.add(addThread);
        addThread.addActionListener(e -> {
            String newName = "";
            if (!LogixNG_Thread.validateNewThreadName(newName)) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EditThreadsDialog_ErrorThreadNameAlreadyExists", newName), Bundle.getMessage("EditThreadsDialog_ErrorTitle"), 0);
                return;
            }
            LogixNG_Thread thread = LogixNG_Thread.createNewThread(newName);
            int row = this._threadTableModel._threads.size();
            this._threadTableModel._threads.add(thread);
            this._threadTableModel.fireTableRowsInserted(row, row);
        });
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(e -> this.abortPressed());
        cancel.setToolTipText(Bundle.getMessage("LogixNG_CancelButtonHint"));
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        panel5.add(ok);
        ok.addActionListener(e -> this.okPressed());
        this._editThreadsDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditThreadsDialog.this.abortPressed();
            }
        });
        contentPane.add(panel5);
        this._editThreadsDialog.setLocationRelativeTo(null);
        this._editThreadsDialog.pack();
        this._editThreadsDialog.setVisible(true);
    }

    private void abortPressed() {
        this._editThreadsDialog.setVisible(false);
        this._editThreadsDialog.dispose();
        this._editThreadsDialog = null;
    }

    private void okPressed() {
        this._editThreadsDialog.setVisible(false);
        this._editThreadsDialog.dispose();
        this._editThreadsDialog = null;
        this._conditionalNG.setStartupThreadId(this._newStartupThread.getThreadId());
    }

    private final class ThreadTableModel
    extends AbstractTableModel {
        public static final int THREAD_ID_COLUMN = 0;
        public static final int THREAD_NAME_COLUMN = 1;
        public static final int BUTTON_SELECT_THREAD_COLUMN = 2;
        public static final int BUTTON_DELETE_COLUMN = 3;
        public static final int NUM_COLUMNS = 4;
        private final List<LogixNG_Thread> _threads = new ArrayList<LogixNG_Thread>(LogixNG_Thread.getThreads());

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2 || c == 3) {
                return JButton.class;
            }
            if (c == 0) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this._threads.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            if (c == 1 || c == 2) {
                return true;
            }
            return c == 3 && !this._threads.get(r).getThreadInUse();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnSystemName");
                }
                case 1: {
                    return Bundle.getMessage("ColumnUserName");
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return "";
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 3: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row > this._threads.size()) {
                return null;
            }
            switch (col) {
                case 2: {
                    return Bundle.getMessage("EditThreadsDialog_ButtonSelectThread");
                }
                case 3: {
                    return Bundle.getMessage("ButtonDelete");
                }
                case 0: {
                    return this._threads.get(row).getThreadId();
                }
                case 1: {
                    return this._threads.get(row).getThreadName();
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        private void deleteThread(int row) {
            LogixNG_Thread thread = this._threads.get(row);
            LogixNG_Thread.deleteThread(thread);
            this.fireTableRowsDeleted(row, row);
        }

        private void changeThreadName(Object value, int row) {
            String name = (String)value;
            LogixNG_Thread thread = this._threads.get(row);
            if (!thread.getThreadName().equals(name)) {
                if (!LogixNG_Thread.validateNewThreadName(name)) {
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("EditThreadsDialog_ErrorThreadNameAlreadyExists", name), Bundle.getMessage("EditThreadsDialog_ErrorTitle"), 0);
                    return;
                }
                thread.setThreadName(name);
                this.fireTableRowsUpdated(row, row);
            }
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row > this._threads.size()) {
                return;
            }
            switch (col) {
                case 2: {
                    EditThreadsDialog.this._newStartupThread = this._threads.get(row);
                    EditThreadsDialog.this._startupThreadNameLabel.setText(Bundle.getMessage("EditThreadsDialog_StartupThreadName", EditThreadsDialog.this._newStartupThread.getThreadName()));
                    break;
                }
                case 3: {
                    this.deleteThread(row);
                    break;
                }
                case 0: {
                    throw new IllegalArgumentException("Thread ID cannot be changed");
                }
                case 1: {
                    this.changeThreadName(value, row);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column");
                }
            }
        }
    }
}

