/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Logix;
import jmri.LogixManager;
import jmri.jmrit.logixng.tools.ImportLogix;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.swing.JTitledSeparator;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImportLogixFrame
extends JmriJFrame {
    private JRadioButton _whichLogix_All;
    private JRadioButton _whichLogix_AllActive;
    private JRadioButton _whichLogix_Selected;
    private JRadioButton _whatToDo_Nothing;
    private JRadioButton _whatToDo_Disable;
    private JRadioButton _whatToDo_Delete;
    private JCheckBox _includeSystemLogixs;
    private JButton _importLogix;
    private JButton _cancelDone;
    private static final String SYSLOGIX = InstanceManager.getDefault(LogixManager.class).getSystemNamePrefix() + ":SYS";
    private static final String RTXLOGIX = "RTX";
    private static final String USSLOGIX = "USS CTC:OsIndicator";
    private static final Logger log = LoggerFactory.getLogger(ImportLogixFrame.class);

    public ImportLogixFrame() {
        this.setTitle(Bundle.getMessage("TitleImportLogix"));
    }

    @Override
    public void initComponents() {
        super.initComponents();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.logixng.LogixImport", true);
        Container contentPanel = this.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        this.add(new JTitledSeparator(Bundle.getMessage("Import_WhichLogix")));
        this._whichLogix_All = new JRadioButton(Bundle.getMessage("Import_WhichLogix_All"));
        this._whichLogix_AllActive = new JRadioButton(Bundle.getMessage("Import_WhichLogix_AllActive"));
        this._whichLogix_AllActive.setEnabled(false);
        this._whichLogix_Selected = new JRadioButton(Bundle.getMessage("Import_WhichLogix_Selected"));
        this._whichLogix_Selected.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._whichLogix_All);
        buttonGroup.add(this._whichLogix_AllActive);
        buttonGroup.add(this._whichLogix_Selected);
        this._whichLogix_All.setSelected(true);
        contentPanel.add(this._whichLogix_All);
        contentPanel.add(this._whichLogix_AllActive);
        contentPanel.add(this._whichLogix_Selected);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.add(new JTitledSeparator(Bundle.getMessage("Import_WhatToDo")));
        this._whatToDo_Nothing = new JRadioButton(Bundle.getMessage("Import_WhatToDo_Nothing"));
        this._whatToDo_Disable = new JRadioButton(Bundle.getMessage("Import_WhatToDo_Disable"));
        this._whatToDo_Disable.setEnabled(false);
        this._whatToDo_Delete = new JRadioButton(Bundle.getMessage("Import_WhatToDo_Delete"));
        this._whatToDo_Delete.setEnabled(false);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this._whatToDo_Nothing);
        buttonGroup2.add(this._whatToDo_Disable);
        buttonGroup2.add(this._whatToDo_Delete);
        this._whatToDo_Nothing.setSelected(true);
        contentPanel.add(this._whatToDo_Nothing);
        contentPanel.add(this._whatToDo_Disable);
        contentPanel.add(this._whatToDo_Delete);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.add(new JTitledSeparator(Bundle.getMessage("Import_IncludeSystemLogixs")));
        this._includeSystemLogixs = new JCheckBox(Bundle.getMessage("Import_IncludeSystemLogixs"));
        this.add(this._includeSystemLogixs);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.add(new JTitledSeparator(Bundle.getMessage("Import_SelectLogix")));
        contentPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.add(new JTitledSeparator(Bundle.getMessage("Import_WarningMessage")));
        JLabel warning = new JLabel(Bundle.getMessage("Import_WarningMessage_Long"));
        JPanel warningPanel = new JPanel();
        warningPanel.add(warning);
        contentPanel.add(warningPanel);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        this._importLogix = new JButton(Bundle.getMessage("Import_ButtonImport"));
        panel5.add(this._importLogix);
        this._importLogix.addActionListener(e -> {
            this.doImport();
            this._cancelDone.setText(Bundle.getMessage("ButtonDone"));
        });
        this._importLogix.setToolTipText("ImportLogixButtonHint");
        this._cancelDone = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(this._cancelDone);
        this._cancelDone.addActionListener(e -> this.dispose());
        this._cancelDone.setToolTipText(Bundle.getMessage("LogixNG_CancelButtonHint"));
        contentPanel.add(panel5);
        for (Component c : contentPanel.getComponents()) {
            ((JComponent)c).setAlignmentX(0.0f);
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void initMinimumSize(Dimension dimension) {
        this.setMinimumSize(dimension);
        this.pack();
        this.setVisible(true);
    }

    private void doImport() {
        ImportLogix importLogix;
        ArrayList<Logix> logixs = new ArrayList<Logix>();
        if (this._whichLogix_All.isSelected()) {
            for (Logix logix : InstanceManager.getDefault(LogixManager.class).getNamedBeanSet()) {
                boolean isSystemLogix;
                boolean bl = isSystemLogix = logix.getSystemName().equals(SYSLOGIX) || logix.getSystemName().contains(RTXLOGIX) || logix.getSystemName().contains(USSLOGIX);
                if (isSystemLogix && !this._includeSystemLogixs.isSelected()) continue;
                logixs.add(logix);
            }
        } else {
            if (this._whichLogix_All.isSelected()) {
                throw new RuntimeException("Currently not supported");
            }
            if (this._whichLogix_All.isSelected()) {
                throw new RuntimeException("Currently not supported");
            }
            throw new RuntimeException("No choice selected");
        }
        boolean error = false;
        StringBuilder errorMessage = new StringBuilder("<html><table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">");
        errorMessage.append("<tr><th>");
        errorMessage.append(Bundle.getMessage("ColumnSystemName"));
        errorMessage.append("</th><th>");
        errorMessage.append(Bundle.getMessage("ColumnUserName"));
        errorMessage.append("</th><th>");
        errorMessage.append(Bundle.getMessage("ImportLogixColumnError"));
        errorMessage.append("</th></tr>");
        for (Logix logix : logixs) {
            try {
                importLogix = new ImportLogix(logix, this._includeSystemLogixs.isSelected(), true);
                importLogix.doImport();
            }
            catch (JmriException e) {
                errorMessage.append("<tr><td>");
                errorMessage.append(logix.getSystemName());
                errorMessage.append("</td><td>");
                errorMessage.append(logix.getUserName() != null ? logix.getUserName() : "");
                errorMessage.append("</td><td>");
                errorMessage.append(e.getMessage());
                errorMessage.append("</td></tr>");
                log.error("Error thrown: {}", (Object)e, (Object)e);
                error = true;
            }
        }
        if (!error) {
            for (Logix logix : logixs) {
                try {
                    importLogix = new ImportLogix(logix, this._includeSystemLogixs.isSelected(), false);
                    importLogix.doImport();
                }
                catch (JmriException e) {
                    throw new RuntimeException("Unexpected error: " + e.getMessage(), e);
                }
            }
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LogixsAreImported"), Bundle.getMessage("TitleLogixsImportSuccess"), 1);
        } else {
            errorMessage.append("</table></html>");
            JmriJOptionPane.showMessageDialog(this, errorMessage.toString(), Bundle.getMessage("TitleLogixImportError"), 0);
        }
    }
}

