/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.tools.swing.InlineLogixNGsTableModel;
import jmri.util.JmriJFrame;

public class InlineLogixNGsFrame
extends JmriJFrame {
    private final JComboBox<String> _filterOnPanel = new JComboBox();
    private final JComboBox<String> _filterOnIcon = new JComboBox();
    private final InlineLogixNGsTableModel _inlineLogixNGsTableModel = new InlineLogixNGsTableModel();

    public InlineLogixNGsFrame() {
        this.setTitle(Bundle.getMessage("TitleInlineLogixNGs"));
        this.addHelpMenu("package.jmri.jmrit.logixng.InlineLogixNG", true);
    }

    @Override
    public void initComponents() {
        super.initComponents();
        Container contentPanel = this.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel panel = new JPanel();
        JPanel filterPanel = new JPanel();
        filterPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("InlineLogixNGsFrame_Filter")));
        filterPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        JLabel filterOnPanelLabel = new JLabel(Bundle.getMessage("InlineLogixNGsFrame_Filter_Panel"));
        filterPanel.add((Component)filterOnPanelLabel, c);
        filterOnPanelLabel.setLabelFor(this._filterOnPanel);
        c.gridy = 2;
        JLabel filterOnIconLabel = new JLabel(Bundle.getMessage("InlineLogixNGsFrame_Filter_IconType"));
        filterPanel.add((Component)filterOnIconLabel, c);
        filterOnIconLabel.setLabelFor(this._filterOnIcon);
        c.gridx = 1;
        filterPanel.add(Box.createHorizontalStrut(3), c);
        c.gridx = 2;
        c.gridy = 1;
        filterPanel.add(Box.createVerticalStrut(3), c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        filterPanel.add(this._filterOnPanel, c);
        c.gridy = 2;
        filterPanel.add(this._filterOnIcon, c);
        panel.add(filterPanel);
        contentPanel.add(panel);
        JTable table = new JTable();
        this._inlineLogixNGsTableModel.init();
        table.setModel(this._inlineLogixNGsTableModel);
        TableColumnModel columnModel = table.getColumnModel();
        JLabel positionColumn = new JLabel("8888888");
        int positionColumnWidth = positionColumn.getPreferredSize().width;
        columnModel.getColumn(5).setMaxWidth(positionColumnWidth);
        columnModel.getColumn(6).setMaxWidth(positionColumnWidth);
        table.setDefaultRenderer(InlineLogixNGsTableModel.Menu.class, new InlineLogixNGsTableModel.MenuCellRenderer());
        table.setDefaultEditor(InlineLogixNGsTableModel.Menu.class, new InlineLogixNGsTableModel.MenuCellEditor(table, this._inlineLogixNGsTableModel));
        this._inlineLogixNGsTableModel.setColumnForMenu(table);
        table.setAutoCreateRowSorter(true);
        JScrollPane scrollpane = new JScrollPane(table);
        scrollpane.setPreferredSize(new Dimension(600, 400));
        contentPanel.add(scrollpane);
        HashSet<String> panels = new HashSet<String>();
        HashSet<String> icons = new HashSet<String>();
        for (LogixNG logixNG : this._inlineLogixNGsTableModel.getLogixNGList()) {
            String editorName = InlineLogixNGsTableModel.getEditorName(logixNG.getInlineLogixNG());
            String typeName = InlineLogixNGsTableModel.getTypeName(logixNG.getInlineLogixNG());
            if (editorName != null && !editorName.isBlank()) {
                panels.add(editorName);
            }
            if (typeName == null || typeName.isBlank()) continue;
            icons.add(typeName);
        }
        this._filterOnPanel.addItem("");
        for (String s : panels) {
            this._filterOnPanel.addItem(s);
        }
        this._filterOnPanel.addActionListener(evt -> this.updateFilters());
        this._filterOnIcon.addItem("");
        for (String s : icons) {
            this._filterOnIcon.addItem(s);
        }
        this._filterOnIcon.addActionListener(evt -> this.updateFilters());
        this.pack();
    }

    private void updateFilters() {
        String filterOnPanelValue = this._filterOnPanel.getItemAt(this._filterOnPanel.getSelectedIndex());
        String filterOnIconValue = this._filterOnIcon.getItemAt(this._filterOnIcon.getSelectedIndex());
        Predicate<LogixNG> filter = logixNG -> {
            String typeName;
            String editorName = logixNG.getInlineLogixNG() != null ? logixNG.getInlineLogixNG().getEditorName() : "";
            String string = typeName = logixNG.getInlineLogixNG() != null ? logixNG.getInlineLogixNG().getTypeName() : "";
            if (!(filterOnPanelValue.equals("") || editorName != null && filterOnPanelValue.equals(editorName))) {
                return false;
            }
            return filterOnIconValue.equals("") || typeName != null && filterOnIconValue.equals(typeName);
        };
        this._inlineLogixNGsTableModel.setFilter(filter);
    }
}

