/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.InlineLogixNG;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.tools.swing.DeleteBean;
import jmri.jmrit.logixng.tools.swing.LogixNGEditor;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineLogixNGsTableModel
extends AbstractTableModel {
    public static final int COLUMN_SYSTEM_NAME = 0;
    public static final int COLUMN_USER_NAME = 1;
    public static final int COLUMN_PANEL_NAME = 2;
    public static final int COLUMN_POSITIONABLE_NAME = 3;
    public static final int COLUMN_NAMED_BEAN = 4;
    public static final int COLUMN_POS_X = 5;
    public static final int COLUMN_POS_Y = 6;
    public static final int COLUMN_MENU = 7;
    public static final int NUM_COLUMNS = 8;
    private final List<LogixNG> _logixNGs = new ArrayList<LogixNG>();
    private boolean _inEditLogixNGMode = false;
    private LogixNGEditor _logixNGEditor;
    private Predicate<LogixNG> _filter;
    private static final Logger log = LoggerFactory.getLogger(InlineLogixNGsTableModel.class);

    public void init() {
        this.updateList();
        InstanceManager.getDefault(LogixNG_Manager.class).addPropertyChangeListener("length", evt -> this.updateList());
    }

    public List<LogixNG> getLogixNGList() {
        return InstanceManager.getDefault(LogixNG_Manager.class).getNamedBeanSet().stream().filter(t -> t.isInline()).collect(Collectors.toList());
    }

    private void updateList() {
        Stream<LogixNG> stream = InstanceManager.getDefault(LogixNG_Manager.class).getNamedBeanSet().stream().filter(t -> t.isInline());
        this._logixNGs.clear();
        if (this._filter != null) {
            stream = stream.filter(this._filter);
        }
        this._logixNGs.addAll(stream.collect(Collectors.toList()));
        this.fireTableDataChanged();
    }

    public void setFilter(Predicate<LogixNG> filter) {
        this._filter = filter;
        this.updateList();
    }

    public Predicate<LogixNG> getFilter() {
        return this._filter;
    }

    @Override
    public int getRowCount() {
        return this._logixNGs.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnSystemName");
            }
            case 1: {
                return Bundle.getMessage("ColumnUserName");
            }
            case 2: {
                return Bundle.getMessage("InlineLogixNGsTableModel_ColumnPanelName");
            }
            case 3: {
                return Bundle.getMessage("InlineLogixNGsTableModel_ColumnPositionableName");
            }
            case 4: {
                return Bundle.getMessage("InlineLogixNGsTableModel_ColumnNamedBean");
            }
            case 5: {
                return Bundle.getMessage("InlineLogixNGsTableModel_ColumnPosX");
            }
            case 6: {
                return Bundle.getMessage("InlineLogixNGsTableModel_ColumnPosY");
            }
            case 7: {
                return Bundle.getMessage("InlineLogixNGsTableModel_ColumnMenu");
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return String.class;
            }
            case 5: 
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Menu.class;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 || col == 7;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            String msg;
            int optionPane;
            LogixNG otherLogixNG;
            if (value.equals("")) {
                value = null;
            }
            LogixNG logixNG = this._logixNGs.get(rowIndex);
            if (value == null && logixNG.getUserName() == null) {
                return;
            }
            if (value != null && value.equals(logixNG.getUserName())) {
                return;
            }
            LogixNG_Manager logixNG_Manager = InstanceManager.getDefault(LogixNG_Manager.class);
            LogixNG logixNG2 = otherLogixNG = value != null ? logixNG_Manager.getByUserName((String)value) : null;
            if (otherLogixNG != null) {
                log.error("User name is not unique {}", value);
                String msg2 = Bundle.getMessage("WarningUserName", "" + value);
                JmriJOptionPane.showMessageDialog(null, msg2, Bundle.getMessage("WarningTitle"), 0);
                return;
            }
            NamedBeanHandleManager nbMan = InstanceManager.getDefault(NamedBeanHandleManager.class);
            logixNG.setUserName((String)value);
            if (nbMan.inUse(logixNG.getSystemName(), logixNG) && (optionPane = JmriJOptionPane.showConfirmDialog(null, msg = Bundle.getMessage("UpdateToUserName", logixNG.getBeanType(), value, logixNG.getSystemName()), Bundle.getMessage("UpdateToUserNameTitle"), 0)) == 0) {
                try {
                    nbMan.updateBeanFromSystemToUser(logixNG);
                }
                catch (JmriException ex) {
                    log.error("Impossible exception setting user name", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this._logixNGs.size()) {
            throw new IllegalArgumentException(String.format("Invalid row index: %s. Num rows: %s", rowIndex, this._logixNGs.size()));
        }
        LogixNG logixNG = this._logixNGs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return logixNG.getSystemName();
            }
            case 1: {
                return logixNG.getUserName();
            }
            case 2: {
                return InlineLogixNGsTableModel.getEditorName(logixNG.getInlineLogixNG());
            }
            case 3: {
                return InlineLogixNGsTableModel.getPositionableName(logixNG.getInlineLogixNG());
            }
            case 4: {
                String typeName = InlineLogixNGsTableModel.getTypeName(logixNG.getInlineLogixNG());
                return typeName != null ? typeName : "";
            }
            case 5: {
                return InlineLogixNGsTableModel.getX(logixNG.getInlineLogixNG());
            }
            case 6: {
                return InlineLogixNGsTableModel.getY(logixNG.getInlineLogixNG());
            }
            case 7: {
                return Menu.Edit;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    public static String getEditorName(InlineLogixNG inlineLogixNG) {
        return inlineLogixNG != null ? inlineLogixNG.getEditorName() : Bundle.getMessage("InlineLogixNGsTableModel_Error");
    }

    public static String getTypeName(InlineLogixNG inlineLogixNG) {
        return inlineLogixNG != null ? inlineLogixNG.getTypeName() : Bundle.getMessage("InlineLogixNGsTableModel_Error");
    }

    public static String getPositionableName(InlineLogixNG inlineLogixNG) {
        return inlineLogixNG != null ? inlineLogixNG.getNameString() : Bundle.getMessage("InlineLogixNGsTableModel_Error");
    }

    public static int getX(InlineLogixNG inlineLogixNG) {
        return inlineLogixNG != null ? inlineLogixNG.getX() : 0;
    }

    public static int getY(InlineLogixNG inlineLogixNG) {
        return inlineLogixNG != null ? inlineLogixNG.getY() : 0;
    }

    public void setColumnForMenu(JTable table) {
        JComboBox comboBox = new JComboBox();
        table.setRowHeight(comboBox.getPreferredSize().height);
        table.getColumnModel().getColumn(7).setPreferredWidth(comboBox.getPreferredSize().width + 4);
    }

    public static class MenuCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JTable _table;
        InlineLogixNGsTableModel _tableModel;

        public MenuCellEditor(JTable table, InlineLogixNGsTableModel tableModel) {
            this._table = table;
            this._tableModel = tableModel;
        }

        @Override
        public Object getCellEditorValue() {
            return Menu.Edit;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = Menu.Edit;
            }
            if (!(value instanceof Menu)) {
                throw new IllegalArgumentException("value is not an Menu: " + value.getClass().getName());
            }
            JComboBox<Menu> menuComboBox = new JComboBox<Menu>();
            for (Menu menu : Menu.values()) {
                menuComboBox.addItem(menu);
            }
            JComboBoxUtil.setupComboBoxMaxRows(menuComboBox);
            menuComboBox.setSelectedItem(value);
            menuComboBox.addActionListener(this);
            return menuComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JComboBox)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + event.getSource().getClass().getName());
            }
            JComboBox menuComboBox = (JComboBox)event.getSource();
            int row = this._table.getRowSorter().convertRowIndexToModel(this._table.getSelectedRow());
            Menu menu = (Menu)((Object)menuComboBox.getItemAt(menuComboBox.getSelectedIndex()));
            this._table.editingCanceled(null);
            switch (menu) {
                case Edit: {
                    this.edit(row);
                    break;
                }
                case Delete: {
                    this.delete(row);
                    break;
                }
            }
        }

        private boolean checkEditConditionalNG() {
            if (this._tableModel._inEditLogixNGMode) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("Error_InlineLogixNGInEditMode"), Bundle.getMessage("ErrorTitle"), 0);
                this._tableModel._logixNGEditor.bringToFront();
                return true;
            }
            return false;
        }

        private void edit(int row) {
            if (this.checkEditConditionalNG()) {
                return;
            }
            LogixNG logixNG = this._tableModel._logixNGs.get(row);
            LogixNGEditor logixNGEditor = new LogixNGEditor(null, logixNG.getSystemName());
            logixNGEditor.addEditorEventListener(data -> {
                data.forEach((key, value) -> {
                    if (key.equals("Finish")) {
                        this._tableModel._inEditLogixNGMode = false;
                    } else if (key.equals("Delete")) {
                        this._tableModel._inEditLogixNGMode = false;
                        this.delete(row);
                    } else if (key.equals("chgUname")) {
                        logixNG.setUserName((String)value);
                        this._tableModel.fireTableDataChanged();
                    }
                });
                if (logixNG.getNumConditionalNGs() == 0) {
                    this.deleteBean(logixNG);
                }
            });
            logixNGEditor.bringToFront();
            this._tableModel._inEditLogixNGMode = true;
            this._tableModel._logixNGEditor = logixNGEditor;
        }

        private void delete(int row) {
            LogixNG logixNG = this._tableModel._logixNGs.get(row);
            if (this._tableModel._inEditLogixNGMode) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("Error_InlineLogixNGInEditMode", logixNG.getSystemName()), Bundle.getMessage("ErrorTitle"), 0);
                if (this._tableModel._logixNGEditor != null) {
                    this._tableModel._logixNGEditor.bringToFront();
                }
                return;
            }
            DeleteBean<LogixNG> deleteBean = new DeleteBean<LogixNG>(InstanceManager.getDefault(LogixNG_Manager.class));
            boolean hasChildren = logixNG.getNumConditionalNGs() > 0;
            deleteBean.delete(logixNG, hasChildren, t -> this.deleteBean((LogixNG)t), (t, list) -> logixNG.getListenerRefsIncludingChildren(list), LogixNG_UserPreferences.class.getName());
        }

        private void deleteBean(LogixNG logixNG) {
            logixNG.setEnabled(false);
            try {
                InstanceManager.getDefault(LogixNG_Manager.class).deleteBean(logixNG, "DoDelete");
                if (logixNG.getInlineLogixNG() != null) {
                    logixNG.getInlineLogixNG().setLogixNG(null);
                }
            }
            catch (PropertyVetoException e) {
                log.error("{} : Could not Delete.", (Object)e.getMessage());
            }
        }
    }

    public static class MenuCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = Menu.Edit;
            }
            if (!(value instanceof Menu)) {
                throw new IllegalArgumentException("value is not an Menu: " + value.getClass().getName());
            }
            this.setText(((Menu)((Object)value)).toString());
            return this;
        }
    }

    public static enum Menu {
        Edit(Bundle.getMessage("InlineLogixNGsTableModel_TableMenuEdit")),
        Delete(Bundle.getMessage("InlineLogixNGsTableModel_TableMenuDelete"));

        private final String _descr;

        private Menu(String descr) {
            this._descr = descr;
        }

        public String toString() {
            return this._descr;
        }
    }
}

