/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.util.swing.JComboBoxUtil;

public class LocalVariableTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_DATA = 2;
    public static final int COLUMN_MENU = 3;
    private final List<SymbolTable.VariableData> _variables = new ArrayList<SymbolTable.VariableData>();

    public LocalVariableTableModel(MaleSocket maleSocket) {
        if (maleSocket != null) {
            for (SymbolTable.VariableData v : maleSocket.getLocalVariables()) {
                this._variables.add(new SymbolTable.VariableData(v));
            }
        }
    }

    @Override
    public int getRowCount() {
        return this._variables.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnVariableName");
            }
            case 1: {
                return Bundle.getMessage("ColumnVariableType");
            }
            case 2: {
                return Bundle.getMessage("ColumnVariableData");
            }
            case 3: {
                return Bundle.getMessage("ColumnVariableMenu");
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 1: {
                return SymbolTable.InitialValueType.class;
            }
            case 3: {
                return Menu.class;
            }
            case 0: 
            case 2: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 3) {
            return;
        }
        SymbolTable.VariableData variable = this._variables.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                variable._name = (String)value;
                break;
            }
            case 1: {
                if (value != null) {
                    variable._initialValueType = (SymbolTable.InitialValueType)((Object)value);
                    break;
                }
                variable._initialValueType = SymbolTable.InitialValueType.None;
                break;
            }
            case 2: {
                variable._initialValueData = (String)value;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column");
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this._variables.size()) {
            throw new IllegalArgumentException("Invalid row");
        }
        switch (columnIndex) {
            case 0: {
                return this._variables.get(rowIndex).getName();
            }
            case 1: {
                return this._variables.get(rowIndex).getInitialValueType();
            }
            case 2: {
                return this._variables.get(rowIndex).getInitialValueData();
            }
            case 3: {
                return Menu.Select;
            }
        }
        throw new IllegalArgumentException("Invalid column");
    }

    public void setColumnForMenu(JTable table) {
        JComboBox comboBox = new JComboBox();
        table.setRowHeight(comboBox.getPreferredSize().height);
        table.getColumnModel().getColumn(3).setPreferredWidth(comboBox.getPreferredSize().width + 4);
    }

    public void add() {
        int row = this._variables.size();
        this._variables.add(new SymbolTable.VariableData("", SymbolTable.InitialValueType.None, ""));
        this.fireTableRowsInserted(row, row);
    }

    public List<SymbolTable.VariableData> getVariables() {
        return this._variables;
    }

    public static class MenuCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JTable _table;
        LocalVariableTableModel _tableModel;

        public MenuCellEditor(JTable table, LocalVariableTableModel tableModel) {
            this._table = table;
            this._tableModel = tableModel;
        }

        @Override
        public Object getCellEditorValue() {
            return Menu.Select;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = Menu.Select;
            }
            if (!(value instanceof Menu)) {
                throw new IllegalArgumentException("value is not an Menu: " + value.getClass().getName());
            }
            JComboBox<Menu> menuComboBox = new JComboBox<Menu>();
            for (Menu menu : Menu.values()) {
                if (menu == Menu.MoveUp && row == 0 || menu == Menu.MoveDown && row + 1 == this._tableModel._variables.size()) continue;
                menuComboBox.addItem(menu);
            }
            JComboBoxUtil.setupComboBoxMaxRows(menuComboBox);
            menuComboBox.setSelectedItem(value);
            menuComboBox.addActionListener(this);
            return menuComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JComboBox)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + event.getSource().getClass().getName());
            }
            JComboBox menuComboBox = (JComboBox)event.getSource();
            int row = this._table.getSelectedRow();
            Menu menu = (Menu)((Object)menuComboBox.getItemAt(menuComboBox.getSelectedIndex()));
            switch (menu) {
                case Delete: {
                    this.delete(row);
                    break;
                }
                case MoveUp: {
                    if (row <= 0) break;
                    this.moveUp(row);
                    break;
                }
                case MoveDown: {
                    if (row + 1 >= this._tableModel._variables.size()) break;
                    this.moveUp(row + 1);
                    break;
                }
            }
            if (this._tableModel._variables.size() > 0) {
                this._table.editCellAt(row, 0);
            }
        }

        private void delete(int row) {
            this._tableModel._variables.remove(row);
            this._tableModel.fireTableRowsDeleted(row, row);
        }

        private void moveUp(int row) {
            SymbolTable.VariableData temp = this._tableModel._variables.get(row - 1);
            this._tableModel._variables.set(row - 1, this._tableModel._variables.get(row));
            this._tableModel._variables.set(row, temp);
            this._tableModel.fireTableRowsUpdated(row - 1, row);
        }
    }

    public static class TypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private SymbolTable.InitialValueType _type;

        @Override
        public Object getCellEditorValue() {
            return this._type;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                value = SymbolTable.InitialValueType.None;
            }
            if (!(value instanceof SymbolTable.InitialValueType)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + value.getClass().getName());
            }
            JComboBox<SymbolTable.InitialValueType> typeComboBox = new JComboBox<SymbolTable.InitialValueType>();
            for (SymbolTable.InitialValueType type : SymbolTable.InitialValueType.values()) {
                typeComboBox.addItem(type);
            }
            JComboBoxUtil.setupComboBoxMaxRows(typeComboBox);
            typeComboBox.setSelectedItem(value);
            typeComboBox.addActionListener(this);
            return typeComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!(event.getSource() instanceof JComboBox)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + event.getSource().getClass().getName());
            }
            JComboBox typeComboBox = (JComboBox)event.getSource();
            this._type = (SymbolTable.InitialValueType)((Object)typeComboBox.getItemAt(typeComboBox.getSelectedIndex()));
        }
    }

    public static class MenuCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = Menu.Select;
            }
            if (!(value instanceof Menu)) {
                throw new IllegalArgumentException("value is not an Menu: " + value.getClass().getName());
            }
            this.setText(((Menu)((Object)value)).toString());
            return this;
        }
    }

    public static class TypeCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = SymbolTable.InitialValueType.None;
            }
            if (!(value instanceof SymbolTable.InitialValueType)) {
                throw new IllegalArgumentException("value is not an InitialValueType: " + value.getClass().getName());
            }
            this.setText(((SymbolTable.InitialValueType)((Object)value)).toString());
            return this;
        }
    }

    public static enum Menu {
        Select(Bundle.getMessage("TableMenuSelect")),
        Delete(Bundle.getMessage("TableMenuDelete")),
        MoveUp(Bundle.getMessage("TableMenuMoveUp")),
        MoveDown(Bundle.getMessage("TableMenuMoveDown"));

        private final String _descr;

        private Menu(String descr) {
            this._descr = descr;
        }

        public String toString() {
            return this._descr;
        }
    }
}

