/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNGBrowseWindow
extends JmriJFrame {
    private static final String PRINT_LINE_NUMBERS_OPTION = "jmri.jmrit.logixng.PrintLineNumbers";
    private static final String PRINT_ERROR_HANDLING_OPTION = "jmri.jmrit.logixng.ErrorHandling";
    private static final String PRINT_NOT_CONNECTED_OPTION = "jmri.jmrit.logixng.NotConnectedSockets";
    private static final String PRINT_LOCAL_VARIABLES_OPTION = "jmri.jmrit.logixng.LocalVariables";
    private static final String PRINT_SYSTEM_NAMES_OPTION = "jmri.jmrit.logixng.SystemNames";
    private static final String PRINT_DISABLED_OPTION = "jmri.jmrit.logixng.Disabled";
    private Base.PrintTreeSettings _printTreeSettings = new Base.PrintTreeSettings();
    private JTextArea _textContent;
    private JFileChooser userFileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
    private static final Logger log = LoggerFactory.getLogger(LogixNGBrowseWindow.class);

    public LogixNGBrowseWindow(String title) {
        super(title, false, true);
    }

    public void getPrintTreeSettings() {
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> {
            this._printTreeSettings._printLineNumbers = prefMgr.getSimplePreferenceState(PRINT_LINE_NUMBERS_OPTION);
            this._printTreeSettings._printErrorHandling = prefMgr.getSimplePreferenceState(PRINT_ERROR_HANDLING_OPTION);
            this._printTreeSettings._printNotConnectedSockets = prefMgr.getSimplePreferenceState(PRINT_NOT_CONNECTED_OPTION);
            this._printTreeSettings._printLocalVariables = prefMgr.getSimplePreferenceState(PRINT_LOCAL_VARIABLES_OPTION);
            this._printTreeSettings._printSystemNames = prefMgr.getSimplePreferenceState(PRINT_SYSTEM_NAMES_OPTION);
            this._printTreeSettings._printDisabled = prefMgr.getSimplePreferenceState(PRINT_DISABLED_OPTION);
            this._printTreeSettings._printStartup = true;
        });
    }

    public void updateBrowserText(GetText getText) {
        if (this._textContent != null) {
            this._textContent.setText(getText.getText(this._printTreeSettings));
        }
    }

    public void makeBrowserWindow(boolean browseMonoSpace, boolean showSettingsPanel, String header, String systemName, GetText getText) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LogixNGBrowseWindow.this._textContent = null;
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.add(new JLabel(header));
        contentPane.add((Component)topPanel, "North");
        this._textContent = new JTextArea(getText.getText(this._printTreeSettings));
        if (browseMonoSpace) {
            this._textContent.setFont(new Font("Monospaced", 0, 12));
        }
        JScrollPane scrollPane = new JScrollPane(this._textContent);
        contentPane.add(scrollPane);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JButton helpBrowse = new JButton(Bundle.getMessage("MenuHelp"));
        bottomPanel.add((Component)helpBrowse, "West");
        helpBrowse.addActionListener(e -> JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LogixNG_Browse_HelpText"), Bundle.getMessage("LogixNG_Browse_HelpTitle"), 1));
        if (showSettingsPanel) {
            JPanel settingsPanel = this.getSettingsPanel(getText);
            bottomPanel.add((Component)settingsPanel, "Center");
        }
        JButton saveBrowse = new JButton(Bundle.getMessage("BrowserSaveButton"));
        saveBrowse.setToolTipText(Bundle.getMessage("BrowserSaveButtonHint"));
        bottomPanel.add((Component)saveBrowse, "East");
        saveBrowse.addActionListener(e -> this.saveBrowserPressed(header, systemName));
        contentPane.add((Component)bottomPanel, "South");
        this.pack();
        this.setVisible(true);
    }

    void saveBrowserPressed(String header, String systemName) {
        this.userFileChooser.setApproveButtonText(Bundle.getMessage("BrowserSaveDialogApprove"));
        this.userFileChooser.setDialogTitle(Bundle.getMessage("BrowserSaveDialogTitle"));
        this.userFileChooser.rescanCurrentDirectory();
        String suggestedFileName = systemName.replace(':', '_') + ".txt";
        this.userFileChooser.setSelectedFile(new File(suggestedFileName));
        int retVal = this.userFileChooser.showSaveDialog(null);
        if (retVal != 0) {
            log.debug("Save browser content stopped, no file selected");
            return;
        }
        File file = this.userFileChooser.getSelectedFile();
        log.debug("Save browser content to '{}'", (Object)file);
        if (file.exists()) {
            Object[] options = new Object[]{Bundle.getMessage("BrowserSaveDuplicateReplace"), Bundle.getMessage("BrowserSaveDuplicateAppend"), Bundle.getMessage("ButtonCancel")};
            int selectedOption = JmriJOptionPane.showOptionDialog(null, Bundle.getMessage("BrowserSaveDuplicatePrompt", file.getName()), Bundle.getMessage("BrowserSaveDuplicateTitle"), -1, 2, null, options, options[0]);
            if (selectedOption == 2 || selectedOption == -1) {
                log.debug("Save browser content stopped, file replace/append cancelled");
                return;
            }
            if (selectedOption == 0) {
                FileUtil.delete(file);
            }
        }
        try {
            FileUtil.appendTextToFile(file, header);
            FileUtil.appendTextToFile(file, "-".repeat(header.length()));
            FileUtil.appendTextToFile(file, "");
            FileUtil.appendTextToFile(file, this._textContent.getText());
        }
        catch (IOException e) {
            log.error("Unable to write browser content to '{}'", (Object)file, (Object)e);
        }
    }

    protected JPanel getSettingsPanel(GetText getText) {
        JPanel checkBoxPanel = new JPanel();
        JCheckBox printLineNumbers = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintLineNumbers"));
        printLineNumbers.setSelected(this._printTreeSettings._printLineNumbers);
        printLineNumbers.addChangeListener(event -> {
            if (this._printTreeSettings._printLineNumbers != printLineNumbers.isSelected()) {
                this._printTreeSettings._printLineNumbers = printLineNumbers.isSelected();
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_LINE_NUMBERS_OPTION, printLineNumbers.isSelected()));
                this.updateBrowserText(getText);
            }
        });
        JCheckBox printErrorHandling = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintErrorHandling"));
        printErrorHandling.setSelected(this._printTreeSettings._printErrorHandling);
        printErrorHandling.addChangeListener(event -> {
            if (this._printTreeSettings._printErrorHandling != printErrorHandling.isSelected()) {
                this._printTreeSettings._printErrorHandling = printErrorHandling.isSelected();
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_ERROR_HANDLING_OPTION, printErrorHandling.isSelected()));
                this.updateBrowserText(getText);
            }
        });
        JCheckBox printNotConnectedSockets = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintNotConnectedSocket"));
        printNotConnectedSockets.setSelected(this._printTreeSettings._printNotConnectedSockets);
        printNotConnectedSockets.addChangeListener(event -> {
            if (this._printTreeSettings._printNotConnectedSockets != printNotConnectedSockets.isSelected()) {
                this._printTreeSettings._printNotConnectedSockets = printNotConnectedSockets.isSelected();
                this.updateBrowserText(getText);
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_NOT_CONNECTED_OPTION, printNotConnectedSockets.isSelected()));
            }
        });
        JCheckBox printLocalVariables = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintLocalVariables"));
        printLocalVariables.setSelected(this._printTreeSettings._printLocalVariables);
        printLocalVariables.addChangeListener(event -> {
            if (this._printTreeSettings._printLocalVariables != printLocalVariables.isSelected()) {
                this._printTreeSettings._printLocalVariables = printLocalVariables.isSelected();
                this.updateBrowserText(getText);
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_LOCAL_VARIABLES_OPTION, printLocalVariables.isSelected()));
            }
        });
        JCheckBox printSystemNames = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintSystemNames"));
        printSystemNames.setSelected(this._printTreeSettings._printSystemNames);
        printSystemNames.addChangeListener(event -> {
            if (this._printTreeSettings._printSystemNames != printSystemNames.isSelected()) {
                this._printTreeSettings._printSystemNames = printSystemNames.isSelected();
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_SYSTEM_NAMES_OPTION, printSystemNames.isSelected()));
                this.updateBrowserText(getText);
            }
        });
        JCheckBox printDisabled = new JCheckBox(Bundle.getMessage("LogixNG_Browse_PrintDisabled"));
        printDisabled.setSelected(this._printTreeSettings._printDisabled);
        printDisabled.addChangeListener(event -> {
            if (this._printTreeSettings._printDisabled != printDisabled.isSelected()) {
                this._printTreeSettings._printDisabled = printDisabled.isSelected();
                InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setSimplePreferenceState(PRINT_DISABLED_OPTION, printDisabled.isSelected()));
                this.updateBrowserText(getText);
            }
        });
        checkBoxPanel.add(printLineNumbers);
        checkBoxPanel.add(printErrorHandling);
        checkBoxPanel.add(printNotConnectedSockets);
        checkBoxPanel.add(printLocalVariables);
        checkBoxPanel.add(printSystemNames);
        checkBoxPanel.add(printDisabled);
        return checkBoxPanel;
    }

    public static interface GetText {
        public String getText(Base.PrintTreeSettings var1);
    }
}

