/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.UserPreferencesManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ConditionalNG_Manager;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.tools.swing.ConditionalNGDebugger;
import jmri.jmrit.logixng.tools.swing.ConditionalNGEditor;
import jmri.jmrit.logixng.tools.swing.EditThreadsDialog;
import jmri.jmrit.logixng.tools.swing.TreeEditor;
import jmri.jmrit.logixng.util.LogixNG_Thread;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogixNGEditor
implements AbstractLogixNGEditor<LogixNG> {
    BeanTableDataModel<LogixNG> beanTableDataModel;
    LogixNG_Manager _logixNG_Manager = null;
    LogixNG _curLogixNG = null;
    ConditionalNG_Manager _conditionalNG_Manager = null;
    ConditionalNGEditor _treeEdit = null;
    ConditionalNGDebugger _debugger = null;
    int _numConditionalNGs = 0;
    boolean _inEditMode = false;
    boolean _showReminder = false;
    boolean _suppressReminder = false;
    boolean _suppressIndirectRef = false;
    private boolean _checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    private final JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    private final JLabel _sysNameLabel = new JLabel(Bundle.getMessage("SystemName") + ":");
    private final JLabel _userNameLabel = new JLabel(Bundle.getMessage("UserName") + ":");
    private final String systemNameAuto = this.getClass().getName() + ".AutoSystemName";
    private final JTextField _systemName = new JTextField(20);
    private final JTextField _addUserName = new JTextField(20);
    private JmriJFrame _editLogixNGFrame = null;
    JTextField editUserName = new JTextField(20);
    JLabel status = new JLabel(" ");
    private ConditionalNGTableModel _conditionalNGTableModel = null;
    private JCheckBox _showStartupThreadsCheckBox = null;
    private ConditionalNG _curConditionalNG = null;
    int _conditionalRowNumber = 0;
    boolean _inReorderMode = false;
    boolean _inActReorder = false;
    boolean _inVarReorder = false;
    int _nextInOrder = 0;
    JPanel _selectLogixNGPanel = null;
    JPanel _selectConditionalNGPanel = null;
    TreeMap<String, String> _selectLogixNGMap = new TreeMap();
    ArrayList<String> _selectConditionalNGList = new ArrayList();
    private boolean _inEditConditionalNGMode = false;
    private JmriJFrame _editConditionalNGFrame = null;
    JRadioButton _triggerOnChangeButton;
    List<AbstractLogixNGEditor.EditorEventListener> listenerList = new ArrayList<AbstractLogixNGEditor.EditorEventListener>();
    private HashMap<String, String> logixNG_Data = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(LogixNGEditor.class);

    public LogixNGEditor(BeanTableDataModel<LogixNG> m, String sName) {
        this.beanTableDataModel = m;
        this._logixNG_Manager = InstanceManager.getDefault(LogixNG_Manager.class);
        this._curLogixNG = this._logixNG_Manager.getBySystemName(sName);
        this._conditionalNG_Manager = InstanceManager.getDefault(ConditionalNG_Manager.class);
        this.makeEditLogixNGWindow();
    }

    void makeEditLogixNGWindow() {
        this.editUserName.setText(this._curLogixNG.getUserName());
        if (this._conditionalNGTableModel != null) {
            this._conditionalNGTableModel.fireTableStructureChanged();
        }
        this._inEditMode = true;
        if (this._editLogixNGFrame == null) {
            this._editLogixNGFrame = this._curLogixNG.getUserName() != null ? new JmriJFrame(Bundle.getMessage("TitleEditLogixNG2", this._curLogixNG.getSystemName(), this._curLogixNG.getUserName()), false, false) : new JmriJFrame(Bundle.getMessage("TitleEditLogixNG", this._curLogixNG.getSystemName()), false, false);
            this._editLogixNGFrame.addHelpMenu("package.jmri.jmrit.logixng.LogixNGTableEditor", true);
            this._editLogixNGFrame.setLocation(100, 30);
            Container contentPane = this._editLogixNGFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            JLabel systemNameLabel = new JLabel(Bundle.getMessage("ColumnSystemName") + ":");
            panel1.add(systemNameLabel);
            JLabel fixedSystemName = new JLabel(this._curLogixNG.getSystemName());
            panel1.add(fixedSystemName);
            contentPane.add(panel1);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            JLabel userNameLabel = new JLabel(Bundle.getMessage("ColumnUserName") + ":");
            panel2.add(userNameLabel);
            panel2.add(this.editUserName);
            this.editUserName.setToolTipText(Bundle.getMessage("LogixNGUserNameHint2"));
            contentPane.add(panel2);
            JPanel pctSpace = new JPanel();
            pctSpace.setLayout(new FlowLayout());
            pctSpace.add(new JLabel("   "));
            contentPane.add(pctSpace);
            JPanel pTitle = new JPanel();
            pTitle.setLayout(new FlowLayout());
            pTitle.add(new JLabel(Bundle.getMessage("ConditionalNGTableTitle")));
            contentPane.add(pTitle);
            this._conditionalNGTableModel = new ConditionalNGTableModel();
            JTable conditionalTable = new JTable(this._conditionalNGTableModel);
            conditionalTable.setRowSelectionAllowed(false);
            TableColumnModel conditionalColumnModel = conditionalTable.getColumnModel();
            TableColumn sNameColumn = conditionalColumnModel.getColumn(0);
            sNameColumn.setResizable(true);
            sNameColumn.setMinWidth(100);
            sNameColumn.setPreferredWidth(130);
            TableColumn uNameColumn = conditionalColumnModel.getColumn(1);
            uNameColumn.setResizable(true);
            uNameColumn.setMinWidth(210);
            uNameColumn.setPreferredWidth(260);
            TableColumn threadColumn = conditionalColumnModel.getColumn(2);
            threadColumn.setResizable(true);
            threadColumn.setMinWidth(210);
            threadColumn.setPreferredWidth(260);
            TableColumn buttonColumn = conditionalColumnModel.getColumn(5);
            TableColumn buttonDeleteColumn = conditionalColumnModel.getColumn(7);
            TableColumn buttonEditThreadsColumn = conditionalColumnModel.getColumn(8);
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            conditionalTable.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            conditionalTable.setDefaultEditor(JButton.class, buttonEditor);
            JButton testButton = new JButton("XXXXXX");
            JButton testButton2 = new JButton("XXXXXXXXXX");
            conditionalTable.setRowHeight(testButton.getPreferredSize().height);
            buttonColumn.setMinWidth(testButton.getPreferredSize().width);
            buttonColumn.setMaxWidth(testButton.getPreferredSize().width);
            buttonColumn.setResizable(false);
            buttonDeleteColumn.setMinWidth(testButton.getPreferredSize().width);
            buttonDeleteColumn.setMaxWidth(testButton.getPreferredSize().width);
            buttonDeleteColumn.setResizable(false);
            buttonEditThreadsColumn.setMinWidth(testButton2.getPreferredSize().width);
            buttonEditThreadsColumn.setMaxWidth(testButton2.getPreferredSize().width);
            buttonEditThreadsColumn.setResizable(false);
            JScrollPane conditionalTableScrollPane = new JScrollPane(conditionalTable);
            Dimension dim = conditionalTable.getPreferredSize();
            dim.height = 450;
            conditionalTableScrollPane.getViewport().setPreferredSize(dim);
            contentPane.add(conditionalTableScrollPane);
            this._showStartupThreadsCheckBox = new JCheckBox(Bundle.getMessage("ShowStartupThreadCheckBox"));
            contentPane.add(this._showStartupThreadsCheckBox);
            this._showStartupThreadsCheckBox.addActionListener(evt -> this._conditionalNGTableModel.setShowStartupThreads(this._showStartupThreadsCheckBox.isSelected()));
            JPanel panel4 = new JPanel();
            panel4.setLayout(new BoxLayout(panel4, 1));
            JPanel panel41 = new JPanel();
            panel41.setLayout(new FlowLayout());
            panel41.add(this.status);
            panel4.add(panel41);
            JPanel panel42 = new JPanel();
            panel42.setLayout(new FlowLayout());
            JButton newConditionalNGButton = new JButton(Bundle.getMessage("NewConditionalNGButton"));
            panel42.add(newConditionalNGButton);
            newConditionalNGButton.addActionListener(e -> this.newConditionalNGPressed(e));
            newConditionalNGButton.setToolTipText(Bundle.getMessage("NewConditionalNGButtonHint"));
            JButton reorderButton = new JButton(Bundle.getMessage("ReorderButton"));
            panel42.add(reorderButton);
            reorderButton.addActionListener(e -> this.reorderPressed(e));
            reorderButton.setToolTipText(Bundle.getMessage("ReorderButtonHint"));
            JButton executeButton = new JButton(Bundle.getMessage("ExecuteButton"));
            panel42.add(executeButton);
            executeButton.addActionListener(e -> this.executePressed(e));
            executeButton.setToolTipText(Bundle.getMessage("ExecuteButtonHint"));
            panel4.add(panel42);
            Border panel4Border = BorderFactory.createEtchedBorder();
            panel4.setBorder(panel4Border);
            contentPane.add(panel4);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            JButton done = new JButton(Bundle.getMessage("ButtonDone"));
            panel5.add(done);
            done.addActionListener(e -> this.donePressed(e));
            done.setToolTipText(Bundle.getMessage("DoneButtonHint"));
            JButton delete = new JButton(Bundle.getMessage("ButtonDelete"));
            panel5.add(delete);
            delete.addActionListener(e -> this.deletePressed());
            delete.setToolTipText(Bundle.getMessage("DeleteLogixNGButtonHint"));
            contentPane.add(panel5);
        }
        this._editLogixNGFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (LogixNGEditor.this._inEditMode) {
                    LogixNGEditor.this.donePressed(null);
                } else {
                    LogixNGEditor.this.finishDone();
                }
            }
        });
        this._editLogixNGFrame.pack();
        this._editLogixNGFrame.setVisible(true);
    }

    @Override
    public void bringToFront() {
        if (this._editLogixNGFrame != null) {
            this._editLogixNGFrame.setVisible(true);
        }
    }

    void showSaveReminder() {
        if (this._showReminder && !this._checkEnabled && InstanceManager.getNullableDefault(UserPreferencesManager.class) != null) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("MenuItemLogixNGTable")), this.getClassName(), "remindSaveLogixNG");
        }
    }

    void reorderPressed(ActionEvent e) {
        if (this.checkEditConditionalNG()) {
            return;
        }
        this._showReminder = true;
        this._nextInOrder = 0;
        this._inReorderMode = true;
        this.status.setText(Bundle.getMessage("ReorderMessage"));
        this._conditionalNGTableModel.fireTableDataChanged();
    }

    void swapConditionalNG(int row) {
        this._curLogixNG.swapConditionalNG(this._nextInOrder, row);
        ++this._nextInOrder;
        if (this._nextInOrder >= this._numConditionalNGs) {
            this._inReorderMode = false;
        }
        this._conditionalNGTableModel.fireTableDataChanged();
    }

    void executePressed(ActionEvent e) {
        if (this.checkEditConditionalNG()) {
            return;
        }
        if (this._numConditionalNGs > 0) {
            for (int i = 0; i < this._numConditionalNGs; ++i) {
                ConditionalNG c = this._curLogixNG.getConditionalNG(i);
                if (c == null) {
                    log.error("Invalid conditional system name when executing");
                    continue;
                }
                c.execute();
            }
        }
    }

    void donePressed(ActionEvent e) {
        if (this.checkEditConditionalNG()) {
            return;
        }
        String uName = this.editUserName.getText().trim();
        if (!uName.equals(this._curLogixNG.getUserName())) {
            LogixNG p;
            if (uName.length() > 0 && (p = this._logixNG_Manager.getByUserName(uName)) != null) {
                log.error("Failure to update LogixNG with Duplicate User Name: {}", (Object)uName);
                JmriJOptionPane.showMessageDialog(this._editLogixNGFrame, Bundle.getMessage("Error_UserNameInUse"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            this.logixNG_Data.clear();
            this.logixNG_Data.put("chgUname", uName);
            this.fireEditorEvent();
        }
        this.finishDone();
    }

    void finishDone() {
        this.showSaveReminder();
        this._inEditMode = false;
        if (this._editLogixNGFrame != null) {
            this._editLogixNGFrame.setVisible(false);
            this._editLogixNGFrame.dispose();
            this._editLogixNGFrame = null;
        }
        this.logixNG_Data.clear();
        this.logixNG_Data.put("Finish", this._curLogixNG.getSystemName());
        this.fireEditorEvent();
    }

    void deletePressed() {
        if (this.checkEditConditionalNG()) {
            return;
        }
        this._showReminder = true;
        this.logixNG_Data.clear();
        this.logixNG_Data.put("Delete", this._curLogixNG.getSystemName());
        this.fireEditorEvent();
        this.finishDone();
    }

    void newConditionalNGPressed(ActionEvent e) {
        if (this.checkEditConditionalNG()) {
            return;
        }
        if (this.showAddLogixNGFrame()) {
            if (!this.checkConditionalNGSysName()) {
                return;
            }
            if (this._systemName.getText().isEmpty() && this._autoSystemName.isSelected()) {
                this._systemName.setText(InstanceManager.getDefault(ConditionalNG_Manager.class).getAutoSystemName());
            }
            this._curConditionalNG = this._conditionalNG_Manager.createConditionalNG(this._curLogixNG, this._systemName.getText(), this._addUserName.getText());
            if (this._curConditionalNG == null) {
                log.error("Failure to create ConditionalNG");
                return;
            }
            this._conditionalNGTableModel.fireTableRowsInserted(this._numConditionalNGs, this._numConditionalNGs);
            this._conditionalRowNumber = this._numConditionalNGs++;
            this._showReminder = true;
            this.makeEditConditionalNGWindow();
        }
    }

    boolean checkConditionalNGSysName() {
        if (this._autoSystemName.isSelected()) {
            return true;
        }
        String sName = this._systemName.getText().trim();
        String prefix = this._conditionalNG_Manager.getSubSystemNamePrefix();
        if (!sName.isEmpty() && !sName.startsWith(prefix)) {
            boolean isNumber = sName.matches("^\\d+$");
            boolean hasDollar = sName.startsWith("$");
            StringBuilder newName = new StringBuilder(prefix);
            if (!isNumber && !hasDollar) {
                newName.append("$");
            }
            newName.append(sName);
            sName = newName.toString();
        }
        if (this._conditionalNG_Manager.validSystemNameFormat(sName) != Manager.NameValidity.VALID) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("Error_SystemName_Format", sName), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        this._systemName.setText(sName);
        return true;
    }

    private boolean showAddLogixNGFrame() {
        AtomicBoolean result = new AtomicBoolean(false);
        final JDialog dialog = new JDialog(this._editLogixNGFrame, Bundle.getMessage("AddConditionalNGDialogTitle"), true);
        Container contentPanel = dialog.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._sysNameLabel, c);
        c.gridy = 1;
        p.add((Component)this._userNameLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this._systemName, c);
        c.gridy = 1;
        p.add((Component)this._addUserName, c);
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 0;
        p.add((Component)this._autoSystemName, c);
        this._systemName.setText("");
        this._systemName.setEnabled(true);
        this._addUserName.setText("");
        this._addUserName.setToolTipText(Bundle.getMessage("UserNameHint"));
        this._systemName.setToolTipText(Bundle.getMessage("LogixNGSystemNameHint"));
        contentPanel.add(p);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        JPanel panel32 = new JPanel();
        JLabel message1 = new JLabel(Bundle.getMessage("AddMessage1"));
        panel31.add(message1);
        JLabel message2 = new JLabel(Bundle.getMessage("AddMessage2"));
        panel32.add(message2);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        panel3.add(panel31);
        panel3.add(panel32);
        contentPanel.add(panel3);
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(e -> dialog.dispose());
        cancel.setToolTipText(Bundle.getMessage("CancelEditLogixNGButtonHint"));
        JButton create = new JButton(Bundle.getMessage("ButtonCreate"));
        create.addActionListener(e2 -> {
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setCheckboxPreferenceState(this.systemNameAuto, this._autoSystemName.isSelected()));
            result.set(true);
            dialog.dispose();
        });
        create.setToolTipText(Bundle.getMessage("CreateButtonHint"));
        panel5.add(create);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                dialog.dispose();
            }
        });
        contentPanel.add(panel5);
        this._autoSystemName.addItemListener(e -> this.autoSystemName());
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        this._autoSystemName.setSelected(true);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> this._autoSystemName.setSelected(prefMgr.getCheckboxPreferenceState(this.systemNameAuto, true)));
        dialog.setVisible(true);
        return result.get();
    }

    void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this._systemName.setEnabled(false);
            this._sysNameLabel.setEnabled(false);
        } else {
            this._systemName.setEnabled(true);
            this._sysNameLabel.setEnabled(true);
        }
    }

    void makeEditConditionalNGWindow() {
        this._treeEdit = new ConditionalNGEditor(this._curConditionalNG);
        this._treeEdit.initComponents();
        this._treeEdit.setVisible(true);
        this._inEditConditionalNGMode = true;
        this._editConditionalNGFrame = this._treeEdit;
        this._editConditionalNGFrame.addHelpMenu("package.jmri.jmrit.logixng.ConditionalNGEditor", true);
        LogixNGEditor logixNGEditor = this;
        this._treeEdit.addLogixNGEventListener(new LogixNGEventListenerImpl(logixNGEditor));
    }

    void makeDebugConditionalNGWindow() {
        this._debugger = new ConditionalNGDebugger(this._curConditionalNG);
        this._debugger.initComponents();
        this._debugger.setVisible(true);
        this._inEditConditionalNGMode = true;
        this._editConditionalNGFrame = this._debugger;
        LogixNGEditor logixNGEditor = this;
        this._debugger.addLogixNGEventListener(new LogixNG_DebuggerEventListenerImpl(logixNGEditor));
    }

    void editConditionalNGPressed(int rx) {
        if (this.checkEditConditionalNG()) {
            return;
        }
        this._curConditionalNG = this._curLogixNG.getConditionalNG(rx);
        if (this._curConditionalNG == null) {
            log.error("Attempted edit of non-existant conditional.");
            return;
        }
        this._conditionalRowNumber = rx;
        this.makeEditConditionalNGWindow();
    }

    void debugConditionalNGPressed(int rx) {
        if (this.checkEditConditionalNG()) {
            return;
        }
        this._curConditionalNG = this._curLogixNG.getConditionalNG(rx);
        if (this._curConditionalNG == null) {
            log.error("Attempted edit of non-existant conditional.");
            return;
        }
        this._conditionalRowNumber = rx;
        this.makeDebugConditionalNGWindow();
    }

    private boolean checkEditConditionalNG() {
        if (this._inEditConditionalNGMode) {
            this._editConditionalNGFrame.setVisible(true);
            JmriJOptionPane.showMessageDialog(this._editConditionalNGFrame, Bundle.getMessage("Error_ConditionalNGInEditMode", this._curConditionalNG.getSystemName()), Bundle.getMessage("ErrorTitle"), 0);
            return true;
        }
        return false;
    }

    boolean checkConditionalNGUserName(String uName, LogixNG logixNG) {
        if (uName != null && !uName.equals("")) {
            for (int i = 0; i < logixNG.getNumConditionalNGs(); ++i) {
                ConditionalNG p = logixNG.getConditionalNG(i);
                if (!uName.equals(p.getUserName())) continue;
                log.error("Failure to update ConditionalNG with Duplicate User Name: {}", (Object)uName);
                JmriJOptionPane.showMessageDialog(this._editConditionalNGFrame, Bundle.getMessage("Error10"), Bundle.getMessage("ErrorTitle"), 0);
                return false;
            }
        }
        return true;
    }

    boolean checkConditionalNGSystemName(String sName) {
        if (sName != null && !sName.equals("")) {
            ConditionalNG p = this._curLogixNG.getConditionalNG(sName);
            return p == null;
        }
        return false;
    }

    void messageDuplicateConditionalNGUserName(String svName) {
        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("Error30", svName), Bundle.getMessage("ErrorTitle"), 0);
    }

    private String getClassName() {
        return LogixNG_UserPreferences.class.getName();
    }

    @Override
    public void addEditorEventListener(AbstractLogixNGEditor.EditorEventListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeEditorEventListener(AbstractLogixNGEditor.EditorEventListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireEditorEvent() {
        for (AbstractLogixNGEditor.EditorEventListener l : this.listenerList) {
            l.editorEventOccurred(this.logixNG_Data);
        }
    }

    private class DeleteBeanWorker
    extends SwingWorker<Void, Void> {
        private final ConditionalNG _conditionalNG;
        private final int _row;
        boolean _hasDeleted = false;

        public DeleteBeanWorker(ConditionalNG conditionalNG, int row) {
            this._conditionalNG = conditionalNG;
            this._row = row;
        }

        public int getDisplayDeleteMsg() {
            return InstanceManager.getDefault(UserPreferencesManager.class).getMultipleChoiceOption(TreeEditor.class.getName(), "deleteInUse");
        }

        public void setDisplayDeleteMsg(int boo) {
            InstanceManager.getDefault(UserPreferencesManager.class).setMultipleChoiceOption(TreeEditor.class.getName(), "deleteInUse", boo);
        }

        public void doDelete() {
            try {
                InstanceManager.getDefault(ConditionalNG_Manager.class).deleteBean(this._conditionalNG, "DoDelete");
                LogixNGEditor.this._conditionalNGTableModel.fireTableRowsDeleted(this._row, this._row);
                --LogixNGEditor.this._numConditionalNGs;
                LogixNGEditor.this._showReminder = true;
                this._hasDeleted = true;
            }
            catch (PropertyVetoException e) {
                log.error("Unexpected doDelete failure for {}, {}", (Object)this._conditionalNG, (Object)e.getMessage());
            }
        }

        @Override
        public Void doInBackground() {
            this._conditionalNG.getFemaleSocket().unregisterListeners();
            StringBuilder message = new StringBuilder();
            try {
                InstanceManager.getDefault(ConditionalNG_Manager.class).deleteBean(this._conditionalNG, "CanDelete");
            }
            catch (PropertyVetoException e2) {
                if (e2.getPropertyChangeEvent().getPropertyName().equals("DoNotDelete")) {
                    log.warn("Do not Delete {}, {}", (Object)this._conditionalNG, (Object)e2.getMessage());
                    message.append(Bundle.getMessage("VetoDeleteBean", this._conditionalNG.getBeanType(), this._conditionalNG.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), e2.getMessage()));
                    JmriJOptionPane.showMessageDialog(null, message.toString(), Bundle.getMessage("WarningTitle"), 0);
                    return null;
                }
                message.append(e2.getMessage());
            }
            ArrayList<String> listenerRefs = new ArrayList<String>();
            this._conditionalNG.getListenerRefsIncludingChildren(listenerRefs);
            int listenerRefsCount = listenerRefs.size();
            log.debug("Delete with {}", (Object)listenerRefsCount);
            if (this.getDisplayDeleteMsg() == 2 && message.toString().isEmpty()) {
                this.doDelete();
            } else {
                String prompt;
                JDialog dialog = new JDialog();
                dialog.setTitle(Bundle.getMessage("WarningTitle"));
                dialog.setDefaultCloseOperation(2);
                JPanel container = new JPanel();
                container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                container.setLayout(new BoxLayout(container, 1));
                if (listenerRefsCount > 0) {
                    prompt = this._conditionalNG.getFemaleSocket().isConnected() ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                    JLabel question = new JLabel(Bundle.getMessage(prompt, this._conditionalNG.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    ArrayList<String> listeners = new ArrayList<String>();
                    for (String listenerRef : listenerRefs) {
                        if (listeners.contains(listenerRef)) continue;
                        listeners.add(listenerRef);
                    }
                    message.append("<br>");
                    message.append(Bundle.getMessage("ReminderInUse", listenerRefsCount));
                    message.append("<ul>");
                    for (String listener : listeners) {
                        message.append("<li>");
                        message.append(listener);
                        message.append("</li>");
                    }
                    message.append("</ul>");
                    JEditorPane pane = new JEditorPane();
                    pane.setContentType("text/html");
                    pane.setText("<html>" + message.toString() + "</html>");
                    pane.setEditable(false);
                    JScrollPane jScrollPane = new JScrollPane(pane);
                    container.add(jScrollPane);
                } else {
                    prompt = this._conditionalNG.getFemaleSocket().isConnected() ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                    String msg = MessageFormat.format(Bundle.getMessage(prompt), this._conditionalNG.getSystemName());
                    JLabel question = new JLabel(msg);
                    question.setAlignmentX(0.5f);
                    container.add(question);
                }
                JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                remember.setAlignmentX(0.5f);
                JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                JPanel button = new JPanel();
                button.setAlignmentX(0.5f);
                button.add(yesButton);
                button.add(noButton);
                container.add(button);
                noButton.addActionListener(e -> dialog.dispose());
                yesButton.addActionListener(e -> {
                    if (remember.isSelected()) {
                        this.setDisplayDeleteMsg(2);
                    }
                    this.doDelete();
                    dialog.dispose();
                });
                container.add(remember);
                container.setAlignmentX(0.5f);
                container.setAlignmentY(0.5f);
                dialog.getContentPane().add(container);
                dialog.pack();
                dialog.getRootPane().setDefaultButton(noButton);
                noButton.requestFocusInWindow();
                dialog.getRootPane().registerKeyboardAction(e -> {
                    dialog.setVisible(false);
                    dialog.dispose();
                }, KeyStroke.getKeyStroke(27, 0), 2);
                dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
            if (!this._hasDeleted && this._conditionalNG.getFemaleSocket().isActive()) {
                this._conditionalNG.getFemaleSocket().registerListeners();
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Exception while deleting bean", (Throwable)e);
            }
        }
    }

    private class LogixNG_DebuggerEventListenerImpl
    implements ConditionalNGDebugger.ConditionalNGEventListener {
        private final LogixNGEditor _logixNGEditor;

        public LogixNG_DebuggerEventListenerImpl(LogixNGEditor logixNGEditor2) {
            this._logixNGEditor = logixNGEditor2;
        }

        @Override
        public void conditionalNGEventOccurred() {
            String lgxName = LogixNGEditor.this._curLogixNG.getSystemName();
            LogixNGEditor.this._debugger.logixNGData.forEach((key, value) -> {
                if (key.equals("Finish")) {
                    LogixNGEditor.this._debugger = null;
                    LogixNGEditor.this._inEditConditionalNGMode = false;
                    this._logixNGEditor.bringToFront();
                } else if (key.equals("Delete")) {
                    LogixNGEditor.this.deletePressed();
                } else if (key.equals("chgUname")) {
                    LogixNG x = LogixNGEditor.this._logixNG_Manager.getBySystemName(lgxName);
                    if (x == null) {
                        log.error("Found no logixNG for name {} when changing user name (2)", (Object)lgxName);
                        return;
                    }
                    x.setUserName((String)value);
                    if (LogixNGEditor.this.beanTableDataModel != null) {
                        LogixNGEditor.this.beanTableDataModel.fireTableDataChanged();
                    }
                }
            });
        }
    }

    private class LogixNGEventListenerImpl
    implements ConditionalNGEditor.ConditionalNGEventListener {
        private final LogixNGEditor _logixNGEditor;

        public LogixNGEventListenerImpl(LogixNGEditor logixNGEditor2) {
            this._logixNGEditor = logixNGEditor2;
        }

        @Override
        public void conditionalNGEventOccurred() {
            String lgxName = LogixNGEditor.this._curLogixNG.getSystemName();
            LogixNGEditor.this._treeEdit.logixNGData.forEach((key, value) -> {
                if (key.equals("Finish")) {
                    LogixNGEditor.this._treeEdit = null;
                    LogixNGEditor.this._inEditConditionalNGMode = false;
                    this._logixNGEditor.bringToFront();
                } else if (key.equals("Delete")) {
                    LogixNGEditor.this.deletePressed();
                } else if (key.equals("chgUname")) {
                    LogixNG x = LogixNGEditor.this._logixNG_Manager.getBySystemName(lgxName);
                    if (x == null) {
                        log.error("Found no logixNG for name {} when changing user name (2)", (Object)lgxName);
                        return;
                    }
                    x.setUserName((String)value);
                    if (LogixNGEditor.this.beanTableDataModel != null) {
                        LogixNGEditor.this.beanTableDataModel.fireTableDataChanged();
                    }
                }
            });
        }
    }

    public static interface LogixNGEventListener
    extends EventListener {
        public void logixNGEventOccurred();
    }

    public final class ConditionalNGTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SNAME_COLUMN = 0;
        public static final int UNAME_COLUMN = 1;
        public static final int THREAD_COLUMN = 2;
        public static final int ENABLED_COLUMN = 3;
        public static final int STARTUP_COLUMN = 4;
        public static final int BUTTON_COLUMN = 5;
        public static final int BUTTON_DEBUG_COLUMN = 6;
        public static final int BUTTON_DELETE_COLUMN = 7;
        public static final int BUTTON_EDIT_THREADS_COLUMN = 8;
        public static final int NUM_COLUMNS = 9;
        private boolean _showStartupThreads;

        public ConditionalNGTableModel() {
            this.updateConditionalNGListeners();
        }

        synchronized void updateConditionalNGListeners() {
            ConditionalNG c;
            int i;
            LogixNGEditor.this._numConditionalNGs = LogixNGEditor.this._curLogixNG.getNumConditionalNGs();
            for (i = 0; i < LogixNGEditor.this._numConditionalNGs; ++i) {
                c = LogixNGEditor.this._curLogixNG.getConditionalNG(i);
                if (c == null) continue;
                c.removePropertyChangeListener(this);
            }
            for (i = 0; i < LogixNGEditor.this._numConditionalNGs; ++i) {
                c = LogixNGEditor.this._curLogixNG.getConditionalNG(i);
                if (c == null) continue;
                c.addPropertyChangeListener(this);
            }
        }

        public void setShowStartupThreads(boolean showStartupThreads) {
            this._showStartupThreads = showStartupThreads;
            this.fireTableRowsUpdated(0, LogixNGEditor.this._curLogixNG.getNumConditionalNGs() - 1);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.updateConditionalNGListeners();
                this.fireTableDataChanged();
            } else if (this.matchPropertyName(e)) {
                this.fireTableDataChanged();
            }
        }

        boolean matchPropertyName(PropertyChangeEvent e) {
            return e.getPropertyName().contains("UserName") || e.getPropertyName().contains("Thread");
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 5 || c == 6 || c == 7 || c == 8) {
                return JButton.class;
            }
            if (c == 4 || c == 3) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public int getRowCount() {
            return LogixNGEditor.this._numConditionalNGs;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            if (!LogixNGEditor.this._inReorderMode) {
                return c == 1 || c == 3 || c == 4 || c == 5 || c == 6 && InstanceManager.getDefault(LogixNGPreferences.class).getInstallDebugger() || c == 7 || c == 8;
            }
            return c == 5 && r >= LogixNGEditor.this._nextInOrder;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnSystemName");
                }
                case 1: {
                    return Bundle.getMessage("ColumnUserName");
                }
                case 3: {
                    return Bundle.getMessage("ColumnHeadEnabled");
                }
                case 2: {
                    return Bundle.getMessage("ConditionalNG_Table_ColumnThreadName");
                }
                case 4: {
                    return Bundle.getMessage("ConditionalNG_Table_ColumnStartup");
                }
                case 5: {
                    return "";
                }
                case 6: {
                    return "";
                }
                case 7: {
                    return "";
                }
                case 8: {
                    return "";
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 3: {
                    return new JTextField((int)5).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)10).getPreferredSize().width;
                }
                case 4: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 5: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 6: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 7: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 8: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        @Override
        public Object getValueAt(int r, int col) {
            int rx = r;
            if (rx > LogixNGEditor.this._numConditionalNGs || LogixNGEditor.this._curLogixNG == null) {
                return null;
            }
            switch (col) {
                case 5: {
                    if (!LogixNGEditor.this._inReorderMode) {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    if (LogixNGEditor.this._nextInOrder == 0) {
                        return Bundle.getMessage("ButtonFirst");
                    }
                    if (LogixNGEditor.this._nextInOrder <= r) {
                        return Bundle.getMessage("ButtonNext");
                    }
                    return Integer.toString(rx + 1);
                }
                case 6: {
                    return Bundle.getMessage("ConditionalNG_Table_ButtonDebug");
                }
                case 7: {
                    return Bundle.getMessage("ButtonDelete");
                }
                case 8: {
                    return Bundle.getMessage("ConditionalNG_Table_ButtonEditThreads");
                }
                case 0: {
                    return LogixNGEditor.this._curLogixNG.getConditionalNG(rx);
                }
                case 1: {
                    ConditionalNG c = LogixNGEditor.this._curLogixNG.getConditionalNG(rx);
                    if (c != null) {
                        return c.getUserName();
                    }
                    return "";
                }
                case 3: {
                    ConditionalNG c = LogixNGEditor.this._curLogixNG.getConditionalNG(rx);
                    if (c != null) {
                        return c.isEnabled();
                    }
                    return null;
                }
                case 2: {
                    if (this._showStartupThreads) {
                        return LogixNG_Thread.getThread(LogixNGEditor.this._curLogixNG.getConditionalNG(r).getStartupThreadId()).getThreadName();
                    }
                    return LogixNGEditor.this._curLogixNG.getConditionalNG(r).getCurrentThread().getThreadName();
                }
                case 4: {
                    ConditionalNG c = LogixNGEditor.this._curLogixNG.getConditionalNG(rx);
                    if (c != null) {
                        return c.isExecuteAtStartup();
                    }
                    return false;
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        private void buttonStartupClicked(int row, Object value) {
            LogixNGEditor.this._curConditionalNG = LogixNGEditor.this._curLogixNG.getConditionalNG(row);
            if (LogixNGEditor.this._curConditionalNG == null) {
                log.error("Attempted edit of non-existant conditional.");
                return;
            }
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("value is not a Boolean");
            }
            LogixNGEditor.this._curConditionalNG.setExecuteAtStartup((Boolean)value);
        }

        private void buttonColumnClicked(int row, int col) {
            if (LogixNGEditor.this._inReorderMode) {
                LogixNGEditor.this.swapConditionalNG(row);
            } else {
                class WindowMaker
                implements Runnable {
                    int theRow;

                    WindowMaker(int r) {
                        this.theRow = r;
                    }

                    @Override
                    public void run() {
                        LogixNGEditor.this.editConditionalNGPressed(this.theRow);
                    }
                }
                WindowMaker t = new WindowMaker(row);
                SwingUtilities.invokeLater(t);
            }
        }

        private void buttonDebugClicked(int row, int col) {
            if (LogixNGEditor.this._inReorderMode) {
                LogixNGEditor.this.swapConditionalNG(row);
            } else {
                class WindowMaker
                implements Runnable {
                    int theRow;

                    WindowMaker(int r) {
                        this.theRow = r;
                    }

                    @Override
                    public void run() {
                        LogixNGEditor.this.debugConditionalNGPressed(this.theRow);
                    }
                }
                WindowMaker t = new WindowMaker(row);
                SwingUtilities.invokeLater(t);
            }
        }

        private void deleteConditionalNG(int row) {
            DeleteBeanWorker worker = new DeleteBeanWorker(LogixNGEditor.this._curLogixNG.getConditionalNG(row), row);
            worker.execute();
        }

        private void changeUserName(Object value, int row) {
            String uName = (String)value;
            ConditionalNG cn = LogixNGEditor.this._curLogixNG.getConditionalNGByUserName(uName);
            if (cn == null) {
                ConditionalNG cdl = LogixNGEditor.this._curLogixNG.getConditionalNG(row);
                cdl.setUserName(uName.trim());
                this.fireTableRowsUpdated(row, row);
            } else if (cn != LogixNGEditor.this._curLogixNG.getConditionalNG(row)) {
                LogixNGEditor.this.messageDuplicateConditionalNGUserName(cn.getSystemName());
            }
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row > LogixNGEditor.this._numConditionalNGs || LogixNGEditor.this._curLogixNG == null) {
                return;
            }
            switch (col) {
                case 4: {
                    this.buttonStartupClicked(row, value);
                    break;
                }
                case 5: {
                    this.buttonColumnClicked(row, col);
                    break;
                }
                case 6: {
                    this.buttonDebugClicked(row, col);
                    break;
                }
                case 7: {
                    this.deleteConditionalNG(row);
                    break;
                }
                case 8: {
                    EditThreadsDialog dialog = new EditThreadsDialog(LogixNGEditor.this._curLogixNG.getConditionalNG(row));
                    dialog.showDialog();
                    break;
                }
                case 0: {
                    throw new IllegalArgumentException("System name cannot be changed");
                }
                case 1: {
                    this.changeUserName(value, row);
                    break;
                }
                case 3: {
                    ConditionalNG c = LogixNGEditor.this._curLogixNG.getConditionalNG(row);
                    if (c == null) break;
                    boolean v = c.isEnabled();
                    c.setEnabled(!v);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column");
                }
            }
        }
    }
}

