/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_InitializationManager;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class LogixNGInitializationTable
extends JmriJFrame {
    private static final int panelWidth700 = 700;
    private static final int panelHeight500 = 500;
    private final LogixNG_InitializationManager _initManager = InstanceManager.getDefault(LogixNG_InitializationManager.class);
    private InitializationTableModel _initTableModel = null;

    @Override
    public void initComponents() {
        super.initComponents();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.logixng.LogixNGInitializationTable", true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this._initTableModel = new InitializationTableModel();
        JTable conditionalTable = new JTable(this._initTableModel);
        conditionalTable.setRowSelectionAllowed(false);
        TableColumnModel conditionalColumnModel = conditionalTable.getColumnModel();
        TableColumn sNameColumn = conditionalColumnModel.getColumn(0);
        sNameColumn.setResizable(true);
        sNameColumn.setMinWidth(100);
        sNameColumn.setPreferredWidth(130);
        TableColumn uNameColumn = conditionalColumnModel.getColumn(1);
        uNameColumn.setResizable(true);
        uNameColumn.setMinWidth(210);
        uNameColumn.setPreferredWidth(260);
        TableColumn buttonDeleteColumn = conditionalColumnModel.getColumn(2);
        TableColumn buttonMoveUpColumn = conditionalColumnModel.getColumn(3);
        TableColumn buttonMoveDownColumn = conditionalColumnModel.getColumn(4);
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        conditionalTable.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        conditionalTable.setDefaultEditor(JButton.class, buttonEditor);
        JButton testButton = new JButton("XXXXXXXXXX");
        conditionalTable.setRowHeight(testButton.getPreferredSize().height);
        buttonDeleteColumn.setMinWidth(testButton.getPreferredSize().width);
        buttonDeleteColumn.setMaxWidth(testButton.getPreferredSize().width);
        buttonDeleteColumn.setResizable(false);
        buttonMoveUpColumn.setMinWidth(testButton.getPreferredSize().width);
        buttonMoveUpColumn.setMaxWidth(testButton.getPreferredSize().width);
        buttonMoveUpColumn.setResizable(false);
        buttonMoveDownColumn.setMinWidth(testButton.getPreferredSize().width);
        buttonMoveDownColumn.setMaxWidth(testButton.getPreferredSize().width);
        buttonMoveDownColumn.setResizable(false);
        JScrollPane conditionalTableScrollPane = new JScrollPane(conditionalTable);
        Dimension dim = conditionalTable.getPreferredSize();
        dim.height = 450;
        conditionalTableScrollPane.getViewport().setPreferredSize(dim);
        contentPane.add(conditionalTableScrollPane);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        contentPane.add(panel3);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        BeanSelectPanel<Object> logixNG_SelectPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(LogixNG_Manager.class), null);
        panel5.add(logixNG_SelectPanel);
        JButton addLogixNG = new JButton(Bundle.getMessage("LogixNG_Initialization_ButtonAddLogixNG"));
        panel5.add(addLogixNG);
        addLogixNG.addActionListener(e -> {
            LogixNG logixNG = (LogixNG)logixNG_SelectPanel.getNamedBean();
            if (logixNG == null) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LogixNG_Initialization_ErrorNoLogixNG_Selected"), Bundle.getMessage("LogixNG_Initialization_ErrorTitle"), 0);
                return;
            }
            for (LogixNG l : this._initManager.getList()) {
                if (logixNG != l) continue;
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LogixNG_Initialization_ErrorLogixNG_Exists"), Bundle.getMessage("LogixNG_Initialization_ErrorTitle"), 0);
                return;
            }
            this._initManager.add(logixNG);
            this._initTableModel.fireTableStructureChanged();
        });
        contentPane.add(panel5);
        this.pack();
        this.initMinimumSize(new Dimension(700, 500));
    }

    public void initMinimumSize(Dimension dimension) {
        this.pack();
        this.setVisible(true);
    }

    private final class InitializationTableModel
    extends AbstractTableModel {
        public static final int SYSTEM_NAME_COLUMN = 0;
        public static final int USER_NAME_COLUMN = 1;
        public static final int BUTTON_DELETE_COLUMN = 2;
        public static final int BUTTON_MOVE_UP_COLUMN = 3;
        public static final int BUTTON_MOVE_DOWN_COLUMN = 4;
        public static final int NUM_COLUMNS = 5;
        private final List<LogixNG> _logixNGs;

        public InitializationTableModel() {
            this._logixNGs = LogixNGInitializationTable.this._initManager.getList();
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2 || c == 3 || c == 4) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this._logixNGs.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2 || c == 3 || c == 4;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnSystemName");
                }
                case 1: {
                    return Bundle.getMessage("ColumnUserName");
                }
                case 2: 
                case 3: 
                case 4: {
                    return "";
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row > this._logixNGs.size()) {
                return null;
            }
            switch (col) {
                case 0: {
                    return this._logixNGs.get(row).getSystemName();
                }
                case 1: {
                    return this._logixNGs.get(row).getUserName();
                }
                case 2: {
                    return Bundle.getMessage("ButtonDelete");
                }
                case 3: {
                    return Bundle.getMessage("ButtonMoveUp");
                }
                case 4: {
                    return Bundle.getMessage("ButtonMoveDown");
                }
            }
            throw new IllegalArgumentException("Unknown column");
        }

        private void deleteLogixNG(int row) {
            LogixNGInitializationTable.this._initManager.delete(row);
            this.fireTableRowsDeleted(row, row);
        }

        private void moveUp(int row) {
            LogixNGInitializationTable.this._initManager.moveUp(row);
            this.fireTableRowsDeleted(row, row);
        }

        private void moveDown(int row) {
            LogixNGInitializationTable.this._initManager.moveDown(row);
            this.fireTableRowsDeleted(row, row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row > this._logixNGs.size()) {
                return;
            }
            switch (col) {
                case 0: {
                    throw new IllegalArgumentException("System name cannot be changed");
                }
                case 1: {
                    throw new IllegalArgumentException("User name cannot be changed");
                }
                case 2: {
                    this.deleteLogixNG(row);
                    break;
                }
                case 3: {
                    this.moveUp(row);
                    break;
                }
                case 4: {
                    this.moveDown(row);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column");
                }
            }
        }
    }
}

