/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.IfThenElse;
import jmri.jmrit.logixng.implementation.DefaultLogixNGPreferences;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.swing.PreferencesPanel;
import jmri.util.swing.JComboBoxUtil;

public class LogixNGPreferencesPanel
extends JPanel
implements PreferencesPanel {
    private final DefaultLogixNGPreferences preferences;
    JCheckBox _startLogixNGOnLoadCheckBox;
    JCheckBox _installDebuggerCheckBox;
    JCheckBox _logAllBeforeCheckBox;
    JCheckBox _logAllAfterCheckBox;
    JCheckBox _showSystemUserNamesCheckBox;
    JCheckBox _treeEditorHighlightRow;
    JCheckBox _showSystemNameInException;
    JCheckBox _strictTypingGlobalVariables;
    JCheckBox _strictTypingLocalVariables;
    private JComboBox<MaleSocket.ErrorHandlingType> _errorHandlingComboBox;
    private JComboBox<IfThenElse.ExecuteType> _ifThenElseExecuteTypeDefault;

    public LogixNGPreferencesPanel() {
        LogixNGPreferences prefs = InstanceManager.getDefault(LogixNGPreferences.class);
        if (!(prefs instanceof DefaultLogixNGPreferences)) {
            throw new RuntimeException("LogixNGPreferences is not of type DefaultLogixNGPreferences");
        }
        this.preferences = (DefaultLogixNGPreferences)prefs;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.getStartupPanel());
    }

    private boolean setValues() {
        boolean didSet = true;
        this.preferences.setStartLogixNGOnStartup(this._startLogixNGOnLoadCheckBox.isSelected());
        this.preferences.setInstallDebugger(this._installDebuggerCheckBox.isSelected());
        this.preferences.setLogAllBefore(this._logAllBeforeCheckBox.isSelected());
        this.preferences.setLogAllAfter(this._logAllAfterCheckBox.isSelected());
        this.preferences.setShowSystemUserNames(this._showSystemUserNamesCheckBox.isSelected());
        this.preferences.setTreeEditorHighlightRow(this._treeEditorHighlightRow.isSelected());
        this.preferences.setErrorHandlingType(this._errorHandlingComboBox.getItemAt(this._errorHandlingComboBox.getSelectedIndex()));
        this.preferences.setShowSystemNameInException(this._showSystemNameInException.isSelected());
        this.preferences.setStrictTypingGlobalVariables(this._strictTypingGlobalVariables.isSelected());
        this.preferences.setStrictTypingLocalVariables(this._strictTypingLocalVariables.isSelected());
        this.preferences.setIfThenElseExecuteTypeDefault(this._ifThenElseExecuteTypeDefault.getItemAt(this._ifThenElseExecuteTypeDefault.getSelectedIndex()));
        return didSet;
    }

    private JPanel getStartupPanel() {
        JPanel panel = new JPanel();
        this._startLogixNGOnLoadCheckBox = new JCheckBox(Bundle.getMessage("LabelStartLogixNGOnLoad"));
        this._startLogixNGOnLoadCheckBox.setToolTipText(Bundle.getMessage("ToolTipStartLogixNGOnLoad"));
        this._installDebuggerCheckBox = new JCheckBox(Bundle.getMessage("LabelInstallDebugger"));
        this._installDebuggerCheckBox.setToolTipText(Bundle.getMessage("ToolTipLabelInstallDebugger"));
        this._logAllBeforeCheckBox = new JCheckBox(Bundle.getMessage("LabelLogAllBefore"));
        this._logAllBeforeCheckBox.setToolTipText(Bundle.getMessage("ToolTipLabelLogAllBefore"));
        this._logAllAfterCheckBox = new JCheckBox(Bundle.getMessage("LabelLogAllAfter"));
        this._logAllAfterCheckBox.setToolTipText(Bundle.getMessage("ToolTipLabelLogAllAfter"));
        this._showSystemUserNamesCheckBox = new JCheckBox(Bundle.getMessage("LabelShowSystemUserNames"));
        this._showSystemUserNamesCheckBox.setToolTipText(Bundle.getMessage("ToolTipLabeShowSystemUserNames"));
        this._treeEditorHighlightRow = new JCheckBox(Bundle.getMessage("LabelTreeEditorHighlightRow"));
        this._treeEditorHighlightRow.setToolTipText(Bundle.getMessage("ToolTipTreeEditorHighlightRow"));
        this._showSystemNameInException = new JCheckBox(Bundle.getMessage("LabelShowSystemNameInException"));
        this._showSystemNameInException.setToolTipText(Bundle.getMessage("ToolTipShowSystemNameInException"));
        this._strictTypingGlobalVariables = new JCheckBox(Bundle.getMessage("LabelStrictTypingGlobalVariables"));
        this._strictTypingGlobalVariables.setToolTipText(Bundle.getMessage("ToolTipStrictTypingGlobalVariables"));
        this._strictTypingLocalVariables = new JCheckBox(Bundle.getMessage("LabelStrictTypingLocalVariables"));
        this._strictTypingLocalVariables.setToolTipText(Bundle.getMessage("ToolTipStrictTypingLocalVariables"));
        JPanel gridPanel = new JPanel(new GridLayout(0, 1));
        gridPanel.add(this._startLogixNGOnLoadCheckBox);
        gridPanel.add(this._installDebuggerCheckBox);
        gridPanel.add(this._logAllBeforeCheckBox);
        gridPanel.add(this._logAllAfterCheckBox);
        gridPanel.add(this._showSystemUserNamesCheckBox);
        gridPanel.add(this._treeEditorHighlightRow);
        gridPanel.add(Box.createVerticalStrut(2));
        gridPanel.add(this._strictTypingGlobalVariables);
        gridPanel.add(this._strictTypingLocalVariables);
        gridPanel.add(Box.createVerticalStrut(2));
        gridPanel.add(this._showSystemNameInException);
        this._startLogixNGOnLoadCheckBox.setSelected(this.preferences.getStartLogixNGOnStartup());
        this._installDebuggerCheckBox.setSelected(this.preferences.getInstallDebugger());
        this._logAllBeforeCheckBox.setSelected(this.preferences.getLogAllBefore());
        this._logAllAfterCheckBox.setSelected(this.preferences.getLogAllAfter());
        this._showSystemUserNamesCheckBox.setSelected(this.preferences.getShowSystemUserNames());
        this._treeEditorHighlightRow.setSelected(this.preferences.getTreeEditorHighlightRow());
        this._showSystemNameInException.setSelected(this.preferences.getShowSystemNameInException());
        this._strictTypingGlobalVariables.setSelected(this.preferences.getStrictTypingGlobalVariables());
        this._strictTypingLocalVariables.setSelected(this.preferences.getStrictTypingLocalVariables());
        gridPanel.add(Box.createVerticalStrut(2));
        gridPanel.add(new JLabel(Bundle.getMessage("LabelDefaultErrorHandling")));
        this._errorHandlingComboBox = new JComboBox();
        for (MaleSocket.ErrorHandlingType errorHandlingType : MaleSocket.ErrorHandlingType.values()) {
            if (errorHandlingType == MaleSocket.ErrorHandlingType.Default) continue;
            this._errorHandlingComboBox.addItem(errorHandlingType);
            if (this.preferences.getErrorHandlingType() != errorHandlingType) continue;
            this._errorHandlingComboBox.setSelectedItem((Object)errorHandlingType);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._errorHandlingComboBox);
        gridPanel.add(this._errorHandlingComboBox);
        gridPanel.add(Box.createVerticalStrut(2));
        gridPanel.add(new JLabel(Bundle.getMessage("LabelDefaultIfThenElseExecution")));
        this._ifThenElseExecuteTypeDefault = new JComboBox();
        for (Enum enum_ : IfThenElse.ExecuteType.values()) {
            this._ifThenElseExecuteTypeDefault.addItem((IfThenElse.ExecuteType)enum_);
            if (this.preferences.getIfThenElseExecuteTypeDefault() != enum_) continue;
            this._ifThenElseExecuteTypeDefault.setSelectedItem(enum_);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._ifThenElseExecuteTypeDefault);
        gridPanel.add(this._ifThenElseExecuteTypeDefault);
        panel.setLayout(new FlowLayout(1, 40, 0));
        panel.add(gridPanel);
        return panel;
    }

    @Override
    public String getPreferencesItem() {
        return "LOGIXNG";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuLogixNG");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.getPreferencesItemText();
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        if (this.setValues()) {
            this.preferences.save();
        }
    }

    @Override
    public boolean isDirty() {
        return this.preferences.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this.preferences.isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

