/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.Module;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.implementation.AbstractFemaleSocket;
import jmri.jmrit.logixng.implementation.DefaultConditionalNG;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.tools.swing.ModuleEditorMaleSocket;
import jmri.jmrit.logixng.tools.swing.TreeEditor;
import jmri.jmrit.logixng.util.LogixNG_Thread;

public class ModuleEditor
extends TreeEditor
implements AbstractLogixNGEditor<Module> {
    BeanTableDataModel<Module> beanTableDataModel;
    protected final Module _module;
    private final List<AbstractLogixNGEditor.EditorEventListener> listenerList = new ArrayList<AbstractLogixNGEditor.EditorEventListener>();
    final HashMap<String, String> moduleData = new HashMap();

    public ModuleEditor(BeanTableDataModel<Module> m, String sName) {
        super(ModuleEditor.setupRootSocket(null, sName), TreeEditor.EnableClipboard.EnableClipboard, TreeEditor.EnableRootRemoveCutCopy.DisableRootRemoveCutCopy, TreeEditor.EnableRootPopup.EnableRootPopup, TreeEditor.EnableExecuteEvaluate.EnableExecuteEvaluate);
        this.beanTableDataModel = m;
        if (!this._treePane._femaleRootSocket.isConnected()) {
            throw new RuntimeException("Module is not connected");
        }
        if (!(this._treePane._femaleRootSocket.getConnectedSocket().getObject() instanceof Module)) {
            throw new RuntimeException("Connected socket is not a Module");
        }
        this._module = (Module)this._treePane._femaleRootSocket.getConnectedSocket().getObject();
        if (this._module.getUserName() == null) {
            this.setTitle(Bundle.getMessage("TitleEditModule", this._module.getSystemName()));
        } else {
            this.setTitle(Bundle.getMessage("TitleEditModule2", this._module.getSystemName(), this._module.getUserName()));
        }
    }

    @Override
    protected void executeEvaluate(SwingConfiguratorInterface swi, MaleSocket maleSocket) {
        Module module;
        if (maleSocket.getObject() instanceof Module) {
            module = (Module)maleSocket.getObject();
        } else {
            Base b;
            for (b = maleSocket; b != null && !(b instanceof Module); b = b.getParent()) {
            }
            if (b == null) {
                throw new RuntimeException("Module is not found");
            }
            module = (Module)b;
        }
        LogixNG_Thread.getThread(0).runOnLogixNGEventually(() -> {
            module.setCurrentConditionalNG(new DefaultConditionalNG("IQC1", null));
            swi.executeEvaluate(maleSocket);
        });
    }

    private static FemaleSocket setupRootSocket(Base parent, String sName) {
        RootSocket socket = new RootSocket(parent, new FemaleSocketListener(){

            @Override
            public void connected(FemaleSocket socket) {
            }

            @Override
            public void disconnected(FemaleSocket socket) {
            }
        }, "Root");
        Module module = InstanceManager.getDefault(ModuleManager.class).getBySystemName(sName);
        try {
            socket.connect(new ModuleEditorMaleSocket(null, module));
        }
        catch (SocketAlreadyConnectedException e) {
            throw new RuntimeException("Socket already connected", e);
        }
        return socket;
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.moduleData.clear();
        this.moduleData.put("Finish", this._module.getSystemName());
        this.fireModuleEvent();
    }

    void fireModuleEvent() {
        for (AbstractLogixNGEditor.EditorEventListener l : this.listenerList) {
            l.editorEventOccurred(this.moduleData);
        }
    }

    @Override
    public void addEditorEventListener(AbstractLogixNGEditor.EditorEventListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeEditorEventListener(AbstractLogixNGEditor.EditorEventListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void bringToFront() {
        this.setVisible(true);
    }

    private static class RootSocket
    extends AbstractFemaleSocket {
        public RootSocket(Base parent, FemaleSocketListener listener, String name) {
            super(parent, listener, name);
        }

        @Override
        public boolean canDisconnect() {
            return false;
        }

        @Override
        public void disposeMe() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public boolean isCompatible(MaleSocket socket) {
            return socket instanceof ModuleEditorMaleSocket;
        }

        @Override
        public Map<Category, List<Class<? extends Base>>> getConnectableClasses() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public String getShortDescription(Locale locale) {
            return Bundle.getMessage(locale, "ModuleEditor_RootSocket_Short");
        }

        @Override
        public String getLongDescription(Locale locale) {
            return Bundle.getMessage(locale, "ModuleEditor_RootSocket_Long", this.getName());
        }
    }
}

