/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.Table;
import jmri.jmrit.logixng.implementation.AbstractNamedTable;
import jmri.jmrit.logixng.implementation.DefaultCsvNamedTable;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.tools.swing.AbstractLogixNGEditor;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableEditor
implements AbstractLogixNGEditor<NamedTable> {
    private NamedTableManager _tableManager = null;
    private NamedTable _curTable = null;
    private boolean _inEditMode = false;
    private boolean _showReminder = false;
    private boolean _checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    private final SymbolTable symbolTable = new DefaultSymbolTable();
    private JmriJFrame _editLogixNGFrame = null;
    private final JTextField editUserName = new JTextField(20);
    private final JTextField editCsvTableName = new JTextField(40);
    private TableTableModel tableTableModel = null;
    List<AbstractLogixNGEditor.EditorEventListener> listenerList = new ArrayList<AbstractLogixNGEditor.EditorEventListener>();
    private final HashMap<String, String> tableData = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(TableEditor.class);

    public TableEditor(BeanTableDataModel<NamedTable> m, String sName) {
        this._tableManager = InstanceManager.getDefault(NamedTableManager.class);
        this._curTable = this._tableManager.getBySystemName(sName);
        this.makeEditTableWindow();
    }

    private void makeEditTableWindow() {
        this.editUserName.setText(this._curTable.getUserName());
        if (this.tableTableModel != null) {
            this.tableTableModel.fireTableStructureChanged();
        }
        this._inEditMode = true;
        if (this._editLogixNGFrame == null) {
            this._editLogixNGFrame = this._curTable.getUserName() != null ? new JmriJFrame(Bundle.getMessage("TitleEditLogixNG2", this._curTable.getSystemName(), this._curTable.getUserName()), false, false) : new JmriJFrame(Bundle.getMessage("TitleEditLogixNG", this._curTable.getSystemName()), false, false);
            this._editLogixNGFrame.addHelpMenu("package.jmri.jmrit.logixng.LogixNGTableTableEditor", true);
            this._editLogixNGFrame.setLocation(100, 30);
            Container contentPane = this._editLogixNGFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            JLabel systemNameLabel = new JLabel(Bundle.getMessage("ColumnSystemName") + ":");
            panel1.add(systemNameLabel);
            JLabel fixedSystemName = new JLabel(this._curTable.getSystemName());
            panel1.add(fixedSystemName);
            contentPane.add(panel1);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            JLabel userNameLabel = new JLabel(Bundle.getMessage("ColumnUserName") + ":");
            panel2.add(userNameLabel);
            panel2.add(this.editUserName);
            this.editUserName.setToolTipText(Bundle.getMessage("LogixNGUserNameHint2"));
            contentPane.add(panel2);
            boolean isCsvTable = this._curTable instanceof DefaultCsvNamedTable;
            JPanel panel3 = new JPanel();
            panel3.setLayout(new FlowLayout());
            JLabel tableTypeLabel = new JLabel(Bundle.getMessage("TableEditor_TableType") + ": ");
            panel3.add(tableTypeLabel);
            panel3.add(new JLabel(isCsvTable ? Bundle.getMessage("TableEditor_CsvFile") : Bundle.getMessage("TableEditor_UnknownTableType")));
            contentPane.add(panel3);
            if (isCsvTable) {
                JPanel csvTypePanel = new JPanel();
                csvTypePanel.setLayout(new FlowLayout());
                csvTypePanel.add(new JLabel(Bundle.getMessage("TableEditor_Csv_Type") + ":"));
                JLabel csvTypeLabel = new JLabel();
                Table.CsvType csvType = ((DefaultCsvNamedTable)this._curTable).getCsvType();
                if (csvType == null || csvType.equals((Object)Table.CsvType.TABBED)) {
                    csvTypeLabel.setText(Table.CsvType.TABBED.toString());
                } else if (csvType.equals((Object)Table.CsvType.COMMA)) {
                    csvTypeLabel.setText(Table.CsvType.COMMA.toString());
                } else if (csvType.equals((Object)Table.CsvType.SEMICOLON)) {
                    csvTypeLabel.setText(Table.CsvType.SEMICOLON.toString());
                } else {
                    throw new RuntimeException("unrecognized csvType");
                }
                csvTypePanel.add(csvTypeLabel);
                contentPane.add(csvTypePanel);
                JPanel panel4 = new JPanel();
                panel4.setLayout(new FlowLayout());
                JLabel tableFileNameLabel = new JLabel(Bundle.getMessage("TableEditor_FileName") + ": ");
                panel4.add(tableFileNameLabel);
                this.editCsvTableName.setText(((DefaultCsvNamedTable)this._curTable).getFileName());
                this.editCsvTableName.setEditable(false);
                panel4.add(this.editCsvTableName);
                contentPane.add(panel4);
            }
            JPanel pctSpace = new JPanel();
            pctSpace.setLayout(new FlowLayout());
            pctSpace.add(new JLabel("   "));
            contentPane.add(pctSpace);
            JPanel pTitle = new JPanel();
            pTitle.setLayout(new FlowLayout());
            contentPane.add(pTitle);
            this.tableTableModel = new TableTableModel();
            JTable tableTable = new JTable(this.tableTableModel);
            tableTable.setCellSelectionEnabled(true);
            tableTable.setSelectionMode(0);
            tableTable.setAutoResizeMode(0);
            tableTable.getTableHeader().setReorderingAllowed(false);
            JButton cellRefByIndexButton = new JButton(Bundle.getMessage("TableEditor_CopyToClipboard"));
            JLabel cellRefByIndexLabel = new JLabel();
            JTextField cellRefByIndex = new JTextField();
            cellRefByIndex.setEditable(false);
            cellRefByIndexButton.setEnabled(false);
            JButton cellRefByHeaderButton = new JButton(Bundle.getMessage("TableEditor_CopyToClipboard"));
            JLabel cellRefByHeaderLabel = new JLabel();
            JTextField cellRefByHeader = new JTextField();
            cellRefByHeader.setEditable(false);
            cellRefByHeaderButton.setEnabled(false);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            cellRefByIndexButton.addActionListener(evt -> clipboard.setContents(new StringSelection(cellRefByIndexLabel.getText()), null));
            cellRefByHeaderButton.addActionListener(evt -> clipboard.setContents(new StringSelection(cellRefByHeaderLabel.getText()), null));
            ListSelectionListener selectCellListener = evt -> {
                String columnHeader;
                String refByIndex = String.format("{%s[%d,%d]}", this._curTable.getDisplayName(), tableTable.getSelectedRow() + 1, tableTable.getSelectedColumn() + 1);
                cellRefByIndexLabel.setText(refByIndex);
                cellRefByIndex.setText(ReferenceUtil.getReference(this.symbolTable, refByIndex));
                cellRefByIndexButton.setEnabled(true);
                Object rowHeaderObj = this._curTable.getCell(tableTable.getSelectedRow() + 1, 0);
                Object columnHeaderObj = this._curTable.getCell(0, tableTable.getSelectedColumn() + 1);
                String rowHeader = rowHeaderObj != null ? rowHeaderObj.toString() : "";
                String string = columnHeader = columnHeaderObj != null ? columnHeaderObj.toString() : "";
                if (!rowHeader.isEmpty() && !columnHeader.isEmpty()) {
                    cellRefByHeaderButton.setEnabled(true);
                    String refByHeader = String.format("{%s[%s,%s]}", this._curTable.getDisplayName(), this._curTable.getCell(tableTable.getSelectedRow() + 1, 0), this._curTable.getCell(0, tableTable.getSelectedColumn() + 1));
                    cellRefByHeaderLabel.setText(refByHeader);
                    cellRefByHeader.setText(ReferenceUtil.getReference(this.symbolTable, refByIndex));
                } else {
                    cellRefByHeaderButton.setEnabled(false);
                    cellRefByHeaderLabel.setText("");
                    cellRefByHeader.setText("");
                }
            };
            tableTable.getSelectionModel().addListSelectionListener(selectCellListener);
            tableTable.getColumnModel().getSelectionModel().addListSelectionListener(selectCellListener);
            RowHeaderListModel lm = new RowHeaderListModel();
            JList<Object> rowHeader = new JList<Object>(lm);
            rowHeader.setFixedCellHeight(tableTable.getRowHeight());
            rowHeader.setCellRenderer(new RowHeaderRenderer(tableTable));
            JScrollPane tableTableScrollPane = new JScrollPane(tableTable);
            tableTableScrollPane.setRowHeaderView(rowHeader);
            Dimension dim = tableTable.getPreferredSize();
            dim.height = 450;
            tableTableScrollPane.getViewport().setPreferredSize(dim);
            contentPane.add(tableTableScrollPane);
            JPanel panel4 = new JPanel();
            panel4.setLayout(new FlowLayout());
            panel4.add(cellRefByIndexButton);
            panel4.add(cellRefByIndexLabel);
            panel4.add(cellRefByIndex);
            contentPane.add(panel4);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            panel5.add(cellRefByHeaderButton);
            panel5.add(cellRefByHeaderLabel);
            panel5.add(cellRefByHeader);
            contentPane.add(panel5);
            JPanel panel6 = new JPanel();
            panel6.setLayout(new FlowLayout());
            JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            panel6.add(cancelButton);
            cancelButton.addActionListener(e -> this.finishDone());
            JButton okButton = new JButton(Bundle.getMessage("ButtonOK"));
            panel6.add(okButton);
            okButton.addActionListener(e -> this.okPressed(e));
            JButton delete = new JButton(Bundle.getMessage("ButtonDelete"));
            panel6.add(delete);
            delete.addActionListener(e -> this.deletePressed());
            delete.setToolTipText(Bundle.getMessage("DeleteLogixNGButtonHint"));
            contentPane.add(panel6);
        }
        this._editLogixNGFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TableEditor.this._inEditMode) {
                    TableEditor.this.okPressed(null);
                } else {
                    TableEditor.this.finishDone();
                }
            }
        });
        this._editLogixNGFrame.pack();
        this._editLogixNGFrame.setVisible(true);
    }

    @Override
    public void bringToFront() {
        if (this._editLogixNGFrame != null) {
            this._editLogixNGFrame.setVisible(true);
        }
    }

    void showSaveReminder() {
        if (this._showReminder && !this._checkEnabled && InstanceManager.getNullableDefault(UserPreferencesManager.class) != null) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("MenuItemLogixNGTable")), this.getClassName(), "remindSaveLogixNG");
        }
    }

    private void okPressed(ActionEvent e) {
        String uName = this.editUserName.getText().trim();
        if (!uName.equals(this._curTable.getUserName())) {
            NamedTable p;
            if (uName.length() > 0 && (p = this._tableManager.getByUserName(uName)) != null) {
                log.error("Failure to update NamedTable with Duplicate User Name: {}", (Object)uName);
                JmriJOptionPane.showMessageDialog(this._editLogixNGFrame, Bundle.getMessage("Error6"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            this.tableData.clear();
            this.tableData.put("chgUname", uName);
            this.fireEditorEvent();
        }
        if (this._curTable instanceof DefaultCsvNamedTable) {
            String csvFileName = this.editCsvTableName.getText().trim();
            try {
                AbstractNamedTable.loadTableFromCSV_File("IQT1", null, csvFileName, false, ((DefaultCsvNamedTable)this._curTable).getCsvType());
            }
            catch (NoSuchFileException ex) {
                log.error("Cannot load table due since the file is not found", (Throwable)ex);
                JmriJOptionPane.showMessageDialog(this._editLogixNGFrame, Bundle.getMessage("TableEditor_Error_FileNotFound", csvFileName), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            catch (IOException ex) {
                log.error("Cannot load table due to I/O error", (Throwable)ex);
                JmriJOptionPane.showMessageDialog(this._editLogixNGFrame, ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            catch (RuntimeException ex) {
                log.error("Cannot load table due to an error", (Throwable)ex);
                JmriJOptionPane.showMessageDialog(this._editLogixNGFrame, ex.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            ((DefaultCsvNamedTable)this._curTable).setFileName(csvFileName);
        }
        this.finishDone();
    }

    void finishDone() {
        this.showSaveReminder();
        this._inEditMode = false;
        if (this._editLogixNGFrame != null) {
            this._editLogixNGFrame.setVisible(false);
            this._editLogixNGFrame.dispose();
            this._editLogixNGFrame = null;
        }
        this.tableData.clear();
        this.tableData.put("Finish", this._curTable.getSystemName());
        this.fireEditorEvent();
    }

    void deletePressed() {
        this._showReminder = true;
        this.tableData.clear();
        this.tableData.put("Delete", this._curTable.getSystemName());
        this.fireEditorEvent();
        this.finishDone();
    }

    protected String getClassName() {
        return LogixNG_UserPreferences.class.getName();
    }

    @Override
    public void addEditorEventListener(AbstractLogixNGEditor.EditorEventListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeEditorEventListener(AbstractLogixNGEditor.EditorEventListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireEditorEvent() {
        for (AbstractLogixNGEditor.EditorEventListener l : this.listenerList) {
            l.editorEventOccurred(this.tableData);
        }
    }

    public static interface TableEventListener
    extends EventListener {
        public void tableEventOccurred();
    }

    private static final class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private class RowHeaderListModel
    extends AbstractListModel<Object> {
        private RowHeaderListModel() {
        }

        @Override
        public int getSize() {
            return TableEditor.this._curTable.numRows();
        }

        @Override
        public Object getElementAt(int index) {
            Object data = TableEditor.this._curTable.getCell(index + 1, 0);
            String padding = "  ";
            String str = data != null ? data.toString().concat(padding) : padding;
            return str.length() < 5 ? str.concat("     ").substring(0, 7) : str;
        }
    }

    public final class TableTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return TableEditor.this._curTable.numColumns();
        }

        @Override
        public int getRowCount() {
            return TableEditor.this._curTable.numRows();
        }

        @Override
        public String getColumnName(int col) {
            Object data = TableEditor.this._curTable.getCell(0, col + 1);
            return data != null ? data.toString() : "<null>";
        }

        @Override
        public Object getValueAt(int row, int col) {
            return TableEditor.this._curTable.getCell(row + 1, col + 1);
        }
    }
}

