/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanHandleManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.Clipboard;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.swing.SwingTools;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.jmrit.logixng.tools.swing.ClipboardEditor;
import jmri.jmrit.logixng.tools.swing.EditCommentDialog;
import jmri.jmrit.logixng.tools.swing.LocalVariableTableModel;
import jmri.jmrit.logixng.tools.swing.TreeViewer;
import jmri.jmrit.logixng.util.LogixNG_Thread;
import jmri.jmrit.logixng.util.parser.swing.FunctionsHelpDialog;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.WrapLayout;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeEditor
extends TreeViewer {
    private static final String ACTION_COMMAND_RENAME_SOCKET = "rename_socket";
    private static final String ACTION_COMMAND_REMOVE = "remove";
    private static final String ACTION_COMMAND_EDIT = "edit";
    private static final String ACTION_COMMAND_CUT = "cut";
    private static final String ACTION_COMMAND_COPY = "copy";
    private static final String ACTION_COMMAND_PASTE = "paste";
    private static final String ACTION_COMMAND_PASTE_COPY = "pasteCopy";
    private static final String ACTION_COMMAND_ENABLE = "enable";
    private static final String ACTION_COMMAND_DISABLE = "disable";
    private static final String ACTION_COMMAND_LOCK = "lock";
    private static final String ACTION_COMMAND_UNLOCK = "unlock";
    private static final String ACTION_COMMAND_LOCAL_VARIABLES = "local_variables";
    private static final String ACTION_COMMAND_CHANGE_USERNAME = "change_username";
    private static final String ACTION_COMMAND_EXECUTE_EVALUATE = "execute_evaluate";
    private static ClipboardEditor _clipboardEditor = null;
    private final LogixNGPreferences _prefs = InstanceManager.getDefault(LogixNGPreferences.class);
    private JDialog _renameSocketDialog = null;
    private JDialog _addItemDialog = null;
    private JDialog _editActionExpressionDialog = null;
    private JDialog _editLocalVariablesDialog = null;
    private JDialog _changeUsernameDialog = null;
    private final JTextField _socketNameTextField = new JTextField(20);
    private final JTextField _systemName = new JTextField(20);
    private final JTextField _addUserName = new JTextField(20);
    private final JTextField _usernameField = new JTextField(50);
    protected boolean _showReminder = false;
    private boolean _lockPopupMenu = false;
    private final JLabel _renameSocketLabel = new JLabel(Bundle.getMessage("SocketName") + ":");
    private final JCheckBox _autoSystemName = new JCheckBox(Bundle.getMessage("LabelAutoSysName"));
    private final JLabel _sysNameLabel = new JLabel(Bundle.getMessage("SystemName") + ":");
    private final JLabel _userNameLabel = new JLabel(Bundle.getMessage("UserName") + ":");
    private final String _systemNameAuto = TreeEditor.getClassName() + ".AutoSystemName";
    private JButton _create;
    private JButton _edit;
    private SwingConfiguratorInterface _addSwingConfiguratorInterface;
    private SwingConfiguratorInterface _addSwingConfiguratorInterfaceMaleSocket;
    private SwingConfiguratorInterface _editSwingConfiguratorInterface;
    private final List<Map.Entry<SwingConfiguratorInterface, Base>> _swingConfiguratorInterfaceList = new ArrayList<Map.Entry<SwingConfiguratorInterface, Base>>();
    private LocalVariableTableModel _localVariableTableModel;
    private final boolean _enableClipboard;
    private final boolean _disableRootRemoveCutCopy;
    private final boolean _disableRootPopup;
    private final boolean _enableExecuteEvaluate;
    private static final Logger log = LoggerFactory.getLogger(TreeEditor.class);

    public TreeEditor(@Nonnull FemaleSocket femaleRootSocket, EnableClipboard enableClipboard, EnableRootRemoveCutCopy enableRootRemoveCutCopy, EnableRootPopup enableRootPopup, EnableExecuteEvaluate enableExecuteEvaluate) {
        super(femaleRootSocket);
        this._enableClipboard = enableClipboard == EnableClipboard.EnableClipboard;
        this._disableRootRemoveCutCopy = enableRootRemoveCutCopy == EnableRootRemoveCutCopy.DisableRootRemoveCutCopy;
        this._disableRootPopup = enableRootPopup == EnableRootPopup.DisableRootPopup;
        this._enableExecuteEvaluate = enableExecuteEvaluate == EnableExecuteEvaluate.EnableExecuteEvaluate;
    }

    @Override
    public final void initComponents() {
        super.initComponents();
        JMenuBar menuBar = this.getJMenuBar();
        JMenu toolsMenu = new JMenu(Bundle.getMessage("MenuTools"));
        if (this._enableClipboard) {
            JMenuItem openClipboardItem = new JMenuItem(Bundle.getMessage("MenuOpenClipboard"));
            openClipboardItem.addActionListener(e -> TreeEditor.openClipboard());
            toolsMenu.add(openClipboardItem);
        }
        menuBar.add(toolsMenu);
        final JTree tree = this._treePane._tree;
        tree.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                FemaleSocket femaleSocket;
                TreePath path;
                if (e.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()) {
                    if (e.getKeyCode() == 82 && (path = tree.getSelectionPath()) != null && (femaleSocket = (FemaleSocket)path.getLastPathComponent()).isConnected()) {
                        TreeEditor.this.removeItem((FemaleSocket)path.getLastPathComponent(), path);
                    }
                    if (e.getKeyCode() == 69 && (path = tree.getSelectionPath()) != null && (femaleSocket = (FemaleSocket)path.getLastPathComponent()).isConnected()) {
                        TreeEditor.this.editItem(femaleSocket, path);
                    }
                    if (e.getKeyCode() == 78 && (path = tree.getSelectionPath()) != null) {
                        femaleSocket = (FemaleSocket)path.getLastPathComponent();
                        if (femaleSocket.isConnected()) {
                            return;
                        }
                        if (TreeEditor.this.parentIsSystem(femaleSocket) && TreeEditor.this.abortEditAboutSystem(femaleSocket.getParent())) {
                            return;
                        }
                        Rectangle rect = tree.getPathBounds(path);
                        TreeEditor.this.openPopupMenu(tree, path, rect.x, rect.y, true);
                    }
                    if (e.getKeyCode() == 68 && (path = tree.getSelectionPath()) != null && (femaleSocket = (FemaleSocket)path.getLastPathComponent()).isConnected()) {
                        TreeEditor.this.doIt(TreeEditor.ACTION_COMMAND_DISABLE, femaleSocket, path);
                    }
                }
                if (e.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64) {
                    if (e.getKeyCode() == 86 && (path = tree.getSelectionPath()) != null && !(femaleSocket = (FemaleSocket)path.getLastPathComponent()).isConnected()) {
                        TreeEditor.this.pasteCopy((FemaleSocket)path.getLastPathComponent(), path);
                    }
                    if (e.getKeyCode() == 68 && (path = tree.getSelectionPath()) != null && (femaleSocket = (FemaleSocket)path.getLastPathComponent()).isConnected()) {
                        TreeEditor.this.doIt(TreeEditor.ACTION_COMMAND_ENABLE, femaleSocket, path);
                    }
                }
                for (FemaleSocketOperation oper : FemaleSocketOperation.values()) {
                    FemaleSocket femaleSocket2;
                    TreePath path2;
                    if (e.getKeyCode() != oper.getKeyCode() || e.getModifiersEx() != oper.getModifiers() || (path2 = tree.getSelectionPath()) == null || !(femaleSocket2 = (FemaleSocket)path2.getLastPathComponent()).isSocketOperationAllowed(oper) || TreeEditor.this.parentIsLocked(femaleSocket2)) continue;
                    TreeEditor.this.doIt(oper.name(), femaleSocket2, path2);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        tree.getActionMap().put(tree.getInputMap().get(KeyStroke.getKeyStroke(88, mask)), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    TreeEditor.this.cutItem((FemaleSocket)path.getLastPathComponent(), path);
                }
            }
        });
        tree.getActionMap().put(tree.getInputMap().get(KeyStroke.getKeyStroke(67, mask)), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    TreeEditor.this.copyItem((FemaleSocket)path.getLastPathComponent());
                }
            }
        });
        tree.getActionMap().put(tree.getInputMap().get(KeyStroke.getKeyStroke(86, mask)), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = tree.getSelectionPath();
                if (path != null) {
                    TreeEditor.this.pasteItem((FemaleSocket)path.getLastPathComponent(), path);
                }
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreeEditor.this.openPopupMenu(tree, tree.getClosestPathForLocation(e.getX(), e.getY()), e.getX(), e.getY(), false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreeEditor.this.openPopupMenu(tree, tree.getClosestPathForLocation(e.getX(), e.getY()), e.getX(), e.getY(), false);
                }
            }
        });
    }

    private void openPopupMenu(JTree tree, TreePath path, int x, int y, boolean onlyAddItems) {
        if (this.isPopupMenuLocked()) {
            return;
        }
        if (path != null) {
            Rectangle rect = tree.getPathBounds(path);
            if (y >= rect.y && y <= rect.y + rect.height) {
                tree.setSelectionPath(path);
                FemaleSocket femaleSocket = (FemaleSocket)path.getLastPathComponent();
                new PopupMenu(x, y, femaleSocket, path, onlyAddItems);
            }
        }
    }

    public static void openClipboard() {
        if (_clipboardEditor == null) {
            _clipboardEditor = new ClipboardEditor();
            _clipboardEditor.initComponents();
            _clipboardEditor.setVisible(true);
            _clipboardEditor.addClipboardEventListener(() -> TreeEditor._clipboardEditor.clipboardData.forEach((key, value) -> {
                if (key.equals("Finish")) {
                    _clipboardEditor = null;
                }
            }));
        } else {
            _clipboardEditor.setVisible(true);
        }
    }

    private static String getClassName() {
        return LogixNG_UserPreferences.class.getName();
    }

    private void runOnConditionalNGThreadOrGUIThreadEventually(ConditionalNG conditionalNG, ThreadingUtil.ThreadAction ta) {
        if (conditionalNG != null) {
            LogixNG_Thread thread = conditionalNG.getCurrentThread();
            thread.runOnLogixNGEventually(ta);
        } else {
            ta.run();
        }
    }

    protected final boolean isPopupMenuLocked() {
        if (this._lockPopupMenu) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TreeEditor_PopupLockMessage"), Bundle.getMessage("TreeEditor_PopupLockTitle"), 1);
        }
        return this._lockPopupMenu;
    }

    protected final void setPopupMenuLock(boolean lock) {
        this._lockPopupMenu = lock;
    }

    protected final void renameSocketPressed(FemaleSocket femaleSocket, TreePath path) {
        this.setPopupMenuLock(true);
        this._renameSocketDialog = new JDialog(this, Bundle.getMessage("RenameSocketDialogTitle", femaleSocket.getLongDescription()), false);
        this._renameSocketDialog.setLocation(50, 30);
        Container contentPanel = this._renameSocketDialog.getContentPane();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        p.add((Component)this._renameSocketLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this._socketNameTextField, c);
        this._socketNameTextField.setText(femaleSocket.getName());
        contentPanel.add(p);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(e -> this.cancelRenameSocketPressed(null));
        cancel.setToolTipText(Bundle.getMessage("CancelRenameLogixNGButtonHint"));
        this._renameSocketDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TreeEditor.this.cancelRenameSocketPressed(null);
            }
        });
        this._create = new JButton(Bundle.getMessage("ButtonOK"));
        panel5.add(this._create);
        this._create.addActionListener(e -> {
            if (femaleSocket.validateName(this._socketNameTextField.getText())) {
                femaleSocket.setName(this._socketNameTextField.getText());
                this.cancelRenameSocketPressed(null);
                for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                    TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                    l.treeNodesChanged(tme);
                }
                this._treePane._tree.updateUI();
                this.setPopupMenuLock(false);
            } else {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateFemaleSocketMessage", this._socketNameTextField.getText()), Bundle.getMessage("ValidateFemaleSocketTitle"), 0);
            }
        });
        contentPanel.add(panel5);
        this._renameSocketDialog.setLocationRelativeTo(null);
        this._renameSocketDialog.pack();
        this._renameSocketDialog.setVisible(true);
    }

    protected final void createAddFrame(FemaleSocket femaleSocket, TreePath path, SwingConfiguratorInterface swingConfiguratorInterface) {
        this._showReminder = true;
        if (this._addItemDialog == null) {
            MutableObject commentStr = new MutableObject();
            this._addSwingConfiguratorInterface = swingConfiguratorInterface;
            this._create = new JButton(Bundle.getMessage("ButtonCreate"));
            this._create.addActionListener(e -> {
                this._treePane._femaleRootSocket.unregisterListeners();
                this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    boolean isValid = true;
                    if (!this._prefs.getShowSystemUserNames() || this._systemName.getText().isEmpty() && this._autoSystemName.isSelected()) {
                        this._systemName.setText(this._addSwingConfiguratorInterface.getAutoSystemName());
                    }
                    this.checkAndAdjustSystemName();
                    if (this._addSwingConfiguratorInterface.getManager().validSystemNameFormat(this._systemName.getText()) != Manager.NameValidity.VALID) {
                        isValid = false;
                        errorMessages.add(Bundle.getMessage("InvalidSystemName", this._systemName.getText()));
                    }
                    if (isValid &= this._addSwingConfiguratorInterface.validate(errorMessages)) {
                        MaleSocket socket = this._addUserName.getText().isEmpty() ? this._addSwingConfiguratorInterface.createNewObject(this._systemName.getText(), null) : this._addSwingConfiguratorInterface.createNewObject(this._systemName.getText(), this._addUserName.getText());
                        this._addSwingConfiguratorInterfaceMaleSocket.updateObject(socket);
                        socket.setComment((String)commentStr.getValue());
                        try {
                            femaleSocket.connect(socket);
                        }
                        catch (SocketAlreadyConnectedException ex) {
                            throw new RuntimeException(ex);
                        }
                        femaleSocket.forEntireTree(b -> b.addPropertyChangeListener(this._treePane));
                        ThreadingUtil.runOnGUIEventually(() -> {
                            this._addSwingConfiguratorInterface.dispose();
                            this._addItemDialog.dispose();
                            this._addItemDialog = null;
                            for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                                TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                                l.treeNodesChanged(tme);
                            }
                            this._treePane._tree.expandPath(path);
                            this._treePane._tree.updateUI();
                            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> prefMgr.setCheckboxPreferenceState(this._systemNameAuto, this._autoSystemName.isSelected()));
                        });
                        this.setPopupMenuLock(false);
                    } else {
                        StringBuilder errorMsg = new StringBuilder();
                        for (String s : errorMessages) {
                            if (errorMsg.length() > 0) {
                                errorMsg.append("<br>");
                            }
                            errorMsg.append(s);
                        }
                        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateErrorMessage", errorMsg), Bundle.getMessage("ValidateErrorTitle"), 0);
                    }
                    ThreadingUtil.runOnGUIEventually(() -> {
                        if (this._treePane._femaleRootSocket.isActive()) {
                            this._treePane._femaleRootSocket.registerListeners();
                        }
                    });
                });
            });
            this._create.setToolTipText(Bundle.getMessage("CreateButtonHint"));
            if (this._addSwingConfiguratorInterface != null) {
                this.makeAddEditFrame(true, femaleSocket, this._create, (MutableObject<String>)commentStr);
            }
        }
    }

    void checkAndAdjustSystemName() {
        if (this._autoSystemName.isSelected()) {
            return;
        }
        String sName = this._systemName.getText().trim();
        String prefix = this._addSwingConfiguratorInterface.getManager().getSubSystemNamePrefix();
        if (!sName.isEmpty() && !sName.startsWith(prefix)) {
            boolean isNumber = sName.matches("^\\d+$");
            boolean hasDollar = sName.startsWith("$");
            StringBuilder newName = new StringBuilder(prefix);
            if (!isNumber && !hasDollar) {
                newName.append("$");
            }
            newName.append(sName);
            sName = newName.toString();
        }
        this._systemName.setText(sName);
    }

    protected final void editPressed(FemaleSocket femaleSocket, TreePath path) {
        this.setPopupMenuLock(true);
        this._showReminder = true;
        if (this._editActionExpressionDialog == null) {
            Base object = femaleSocket.getConnectedSocket().getObject();
            MutableObject commentStr = new MutableObject((Object)object.getComment());
            this._edit = new JButton(Bundle.getMessage("ButtonOK"));
            this._edit.addActionListener(e -> this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                ArrayList<String> errorMessages = new ArrayList<String>();
                boolean isValid = true;
                if (this._editSwingConfiguratorInterface.getManager() != null) {
                    if (this._editSwingConfiguratorInterface.getManager().validSystemNameFormat(this._systemName.getText()) != Manager.NameValidity.VALID) {
                        isValid = false;
                        errorMessages.add(Bundle.getMessage("InvalidSystemName", this._systemName.getText()));
                    }
                } else {
                    log.debug("_editSwingConfiguratorInterface.getManager() returns null");
                }
                isValid &= this._editSwingConfiguratorInterface.validate(errorMessages);
                boolean canClose = true;
                for (Map.Entry<SwingConfiguratorInterface, Base> entry : this._swingConfiguratorInterfaceList) {
                    if (entry.getKey().canClose()) continue;
                    canClose = false;
                    break;
                }
                if (isValid && canClose) {
                    ThreadingUtil.runOnGUIEventually(() -> {
                        femaleSocket.unregisterListeners();
                        if (this._addUserName.getText().isEmpty()) {
                            ((NamedBean)((Object)object)).setUserName(null);
                        } else {
                            ((NamedBean)((Object)object)).setUserName(this._addUserName.getText());
                        }
                        ((NamedBean)((Object)object)).setComment((String)commentStr.getValue());
                        for (Map.Entry<SwingConfiguratorInterface, Base> entry : this._swingConfiguratorInterfaceList) {
                            entry.getKey().updateObject(entry.getValue());
                            entry.getKey().dispose();
                        }
                        for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                            TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                            l.treeNodesChanged(tme);
                        }
                        this._editActionExpressionDialog.dispose();
                        this._editActionExpressionDialog = null;
                        this._treePane._tree.updateUI();
                        if (this._treePane._femaleRootSocket.isActive()) {
                            this._treePane._femaleRootSocket.registerListeners();
                        }
                    });
                    this.setPopupMenuLock(false);
                } else if (!isValid) {
                    StringBuilder errorMsg = new StringBuilder();
                    for (String s : errorMessages) {
                        if (errorMsg.length() > 0) {
                            errorMsg.append("<br>");
                        }
                        errorMsg.append(s);
                    }
                    ThreadingUtil.runOnGUIEventually(() -> JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateErrorMessage", errorMsg), Bundle.getMessage("ValidateErrorTitle"), 0));
                }
            }));
            this._edit.setToolTipText(Bundle.getMessage("EditButtonHint"));
            this.makeAddEditFrame(false, femaleSocket, this._edit, (MutableObject<String>)commentStr);
        }
    }

    protected final void makeAddEditFrame(final boolean addOrEdit, FemaleSocket femaleSocket, JButton button, MutableObject<String> commentStr) {
        JDialog dialog = new JDialog(this, Bundle.getMessage(addOrEdit ? "AddMaleSocketDialogTitle" : "EditMaleSocketDialogTitle", femaleSocket.getLongDescription()), false);
        JPanel contentPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        dialog.getContentPane().add(scrollPane);
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        if (this._prefs.getShowSystemUserNames()) {
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 13;
            p.add((Component)this._sysNameLabel, c);
            c.gridy = 1;
            p.add((Component)this._userNameLabel, c);
            c.gridy = 2;
            c.gridx = 1;
            c.gridy = 0;
            c.anchor = 17;
            c.weightx = 1.0;
            c.fill = 2;
            p.add((Component)this._systemName, c);
            c.gridy = 1;
            p.add((Component)this._addUserName, c);
            if (!femaleSocket.isConnected()) {
                c.gridx = 2;
                c.gridy = 1;
                c.anchor = 17;
                c.weightx = 1.0;
                c.fill = 2;
                c.gridy = 0;
                p.add((Component)this._autoSystemName, c);
            }
            if (addOrEdit) {
                this._systemName.setToolTipText(Bundle.getMessage("SystemNameHint", this._addSwingConfiguratorInterface.getExampleSystemName()));
                this._addUserName.setToolTipText(Bundle.getMessage("UserNameHint"));
            }
        } else {
            c.gridx = 0;
            c.gridy = 0;
        }
        contentPanel.add(p);
        if (femaleSocket.isConnected()) {
            this._systemName.setText(femaleSocket.getConnectedSocket().getSystemName());
            this._systemName.setEnabled(false);
            this._addUserName.setText(femaleSocket.getConnectedSocket().getUserName());
        } else {
            this._systemName.setText("");
            this._systemName.setEnabled(true);
            this._addUserName.setText("");
        }
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel5 = new JPanel();
        panel5.setLayout(new WrapLayout());
        Base object = null;
        this._swingConfiguratorInterfaceList.clear();
        ArrayList<JPanel> panels = new ArrayList<JPanel>();
        if (femaleSocket.isConnected()) {
            object = femaleSocket.getConnectedSocket();
            while (object instanceof MaleSocket) {
                SwingConfiguratorInterface swi = SwingTools.getSwingConfiguratorForClass(object.getClass());
                panels.add(swi.getConfigPanel(object, panel5));
                this._swingConfiguratorInterfaceList.add(new AbstractMap.SimpleEntry<SwingConfiguratorInterface, MaleSocket>(swi, (MaleSocket)object));
                object = object.getObject();
            }
            if (object != null) {
                this._editSwingConfiguratorInterface = SwingTools.getSwingConfiguratorForClass(object.getClass());
                this._editSwingConfiguratorInterface.setJDialog(dialog);
                panels.add(this._editSwingConfiguratorInterface.getConfigPanel(object, panel5));
                this._swingConfiguratorInterfaceList.add(new AbstractMap.SimpleEntry<SwingConfiguratorInterface, MaleSocket>(this._editSwingConfiguratorInterface, (MaleSocket)object));
                dialog.setTitle(Bundle.getMessage(addOrEdit ? "AddMaleSocketDialogTitleWithType" : "EditMaleSocketDialogTitleWithType", femaleSocket.getLongDescription(), this._editSwingConfiguratorInterface.toString()));
            } else {
                JPanel panel = new JPanel();
                panel.add(new JLabel("Error: femaleSocket.getConnectedSocket().getObject().getObject()....getObject() doesn't return a non MaleSocket"));
                panels.add(panel);
                log.error("femaleSocket.getConnectedSocket().getObject().getObject()....getObject() doesn't return a non MaleSocket");
            }
        } else {
            Class<MaleSocket> maleSocketClass = this._addSwingConfiguratorInterface.getManager().getMaleSocketClass();
            this._addSwingConfiguratorInterfaceMaleSocket = SwingTools.getSwingConfiguratorForClass(maleSocketClass);
            this._addSwingConfiguratorInterfaceMaleSocket.setJDialog(dialog);
            panels.add(this._addSwingConfiguratorInterfaceMaleSocket.getConfigPanel(panel5));
            this._addSwingConfiguratorInterface.setJDialog(dialog);
            panels.add(this._addSwingConfiguratorInterface.getConfigPanel(panel5));
            dialog.setTitle(Bundle.getMessage(addOrEdit ? "AddMaleSocketDialogTitleWithType" : "EditMaleSocketDialogTitleWithType", femaleSocket.getLongDescription(), this._addSwingConfiguratorInterface.toString()));
        }
        JPanel panel34 = new JPanel();
        panel34.setLayout(new BoxLayout(panel34, 1));
        for (int i = panels.size() - 1; i >= 0; --i) {
            JPanel panel = (JPanel)panels.get(i);
            if (panel.getComponentCount() <= 0) continue;
            panel34.add(Box.createVerticalStrut(30));
            panel34.add(panel);
        }
        panel3.add(panel34);
        contentPanel.add(panel3);
        JButton editComment = new JButton(Bundle.getMessage("ButtonEditComment"));
        panel5.add(editComment);
        String comment = object != null ? object.getComment() : "";
        editComment.addActionListener(e -> commentStr.setValue((Object)new EditCommentDialog().showDialog(comment)));
        JButton showFunctionHelp = new JButton(Bundle.getMessage("ButtonFunctionHelp"));
        panel5.add(showFunctionHelp);
        showFunctionHelp.addActionListener(e -> InstanceManager.getDefault(FunctionsHelpDialog.class).showDialog());
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        panel5.add(cancel);
        cancel.addActionListener(e -> {
            if (!femaleSocket.isConnected()) {
                this.cancelCreateItem(null);
            } else {
                this.cancelEditPressed(null);
            }
        });
        cancel.setToolTipText(Bundle.getMessage("LogixNG_CancelButtonHint"));
        panel5.add(button);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (addOrEdit) {
                    TreeEditor.this.cancelCreateItem(null);
                } else {
                    TreeEditor.this.cancelEditPressed(null);
                }
            }
        });
        contentPanel.add(panel5);
        this._autoSystemName.addItemListener(e -> this.autoSystemName());
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.getRootPane().setDefaultButton(button);
        if (addOrEdit) {
            this._addItemDialog = dialog;
        } else {
            this._editActionExpressionDialog = dialog;
        }
        this._autoSystemName.setSelected(true);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefMgr -> this._autoSystemName.setSelected(prefMgr.getCheckboxPreferenceState(this._systemNameAuto, true)));
        this._systemName.setEnabled(addOrEdit);
        dialog.setVisible(true);
    }

    protected final void editLocalVariables(FemaleSocket femaleSocket, TreePath path) {
        this._showReminder = true;
        this.setPopupMenuLock(true);
        if (this._editLocalVariablesDialog == null) {
            MaleSocket maleSocket = femaleSocket.getConnectedSocket();
            this._edit = new JButton(Bundle.getMessage("ButtonOK"));
            this._edit.addActionListener(e -> {
                ArrayList<String> errorMessages = new ArrayList<String>();
                boolean hasErrors = false;
                for (SymbolTable.VariableData v : this._localVariableTableModel.getVariables()) {
                    if (v.getName().isEmpty()) {
                        errorMessages.add(Bundle.getMessage("VariableNameIsEmpty", v.getName()));
                        hasErrors = true;
                    }
                    if (SymbolTable.validateName(v.getName())) continue;
                    errorMessages.add(Bundle.getMessage("VariableNameIsNotValid", v.getName()));
                    hasErrors = true;
                }
                if (hasErrors) {
                    StringBuilder errorMsg = new StringBuilder();
                    for (String s : errorMessages) {
                        if (errorMsg.length() > 0) {
                            errorMsg.append("<br>");
                        }
                        errorMsg.append(s);
                    }
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateErrorMessage", errorMsg), Bundle.getMessage("ValidateErrorTitle"), 0);
                } else {
                    this._treePane._femaleRootSocket.unregisterListeners();
                    this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                        maleSocket.clearLocalVariables();
                        for (SymbolTable.VariableData variableData : this._localVariableTableModel.getVariables()) {
                            maleSocket.addLocalVariable(variableData);
                        }
                        ThreadingUtil.runOnGUIEventually(() -> {
                            this._editLocalVariablesDialog.dispose();
                            this._editLocalVariablesDialog = null;
                            if (this._treePane._femaleRootSocket.isActive()) {
                                this._treePane._femaleRootSocket.registerListeners();
                            }
                            for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                                TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                                l.treeNodesChanged(tme);
                            }
                            this._treePane._tree.updateUI();
                        });
                        this.setPopupMenuLock(false);
                    });
                }
            });
            this._editLocalVariablesDialog = new JDialog(this, Bundle.getMessage("EditLocalVariablesDialogTitle", femaleSocket.getLongDescription()), false);
            Container contentPanel = this._editLocalVariablesDialog.getContentPane();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            JTable table = new JTable();
            this._localVariableTableModel = new LocalVariableTableModel(maleSocket);
            table.setModel(this._localVariableTableModel);
            table.setDefaultRenderer(SymbolTable.InitialValueType.class, new LocalVariableTableModel.TypeCellRenderer());
            table.setDefaultEditor(SymbolTable.InitialValueType.class, new LocalVariableTableModel.TypeCellEditor());
            table.setDefaultRenderer(LocalVariableTableModel.Menu.class, new LocalVariableTableModel.MenuCellRenderer());
            table.setDefaultEditor(LocalVariableTableModel.Menu.class, new LocalVariableTableModel.MenuCellEditor(table, this._localVariableTableModel));
            this._localVariableTableModel.setColumnForMenu(table);
            JScrollPane scrollpane = new JScrollPane(table);
            scrollpane.setPreferredSize(new Dimension(400, 200));
            contentPanel.add(scrollpane);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            JButton showFunctionHelp = new JButton(Bundle.getMessage("ButtonFunctionHelp"));
            buttonPanel.add(showFunctionHelp);
            showFunctionHelp.addActionListener(e -> InstanceManager.getDefault(FunctionsHelpDialog.class).showDialog());
            JButton add = new JButton(Bundle.getMessage("TableAddVariable"));
            buttonPanel.add(add);
            add.addActionListener(e -> this._localVariableTableModel.add());
            JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            buttonPanel.add(cancel);
            cancel.addActionListener(e -> {
                this._editLocalVariablesDialog.setVisible(false);
                this._editLocalVariablesDialog.dispose();
                this._editLocalVariablesDialog = null;
                this.setPopupMenuLock(false);
            });
            cancel.setToolTipText(Bundle.getMessage("LogixNG_CancelButtonHint"));
            buttonPanel.add(this._edit);
            this._editLocalVariablesDialog.getRootPane().setDefaultButton(this._edit);
            this._editLocalVariablesDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TreeEditor.this._editLocalVariablesDialog.setVisible(false);
                    TreeEditor.this._editLocalVariablesDialog.dispose();
                    TreeEditor.this._editLocalVariablesDialog = null;
                    TreeEditor.this.setPopupMenuLock(false);
                }
            });
            contentPanel.add(buttonPanel);
            this._autoSystemName.addItemListener(e -> this.autoSystemName());
            this._editLocalVariablesDialog.pack();
            this._editLocalVariablesDialog.setLocationRelativeTo(null);
            this._editLocalVariablesDialog.setVisible(true);
        }
    }

    protected final void changeUsername(FemaleSocket femaleSocket, TreePath path) {
        this._showReminder = true;
        this.setPopupMenuLock(true);
        if (this._changeUsernameDialog == null) {
            MaleSocket maleSocket = femaleSocket.getConnectedSocket();
            this._edit = new JButton(Bundle.getMessage("ButtonOK"));
            this._edit.addActionListener(e -> {
                boolean hasErrors = false;
                if (hasErrors) {
                    String errorMsg = "";
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ValidateErrorMessage", errorMsg), Bundle.getMessage("ValidateErrorTitle"), 0);
                } else {
                    this._treePane._femaleRootSocket.unregisterListeners();
                    this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                        String username = this._usernameField.getText();
                        if (username.equals("")) {
                            username = null;
                        }
                        if (username == null && maleSocket.getUserName() != null || username != null && !username.equals(maleSocket.getUserName())) {
                            String msg;
                            int optionPane;
                            Object nB;
                            if (username != null && (nB = maleSocket.getManager().getByUserName(username)) != null) {
                                String uname = username;
                                ThreadingUtil.runOnGUIEventually(() -> {
                                    log.error("User name is not unique {}", (Object)uname);
                                    String msg = Bundle.getMessage("WarningUserName", uname);
                                    JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("WarningTitle"), 0);
                                });
                                username = null;
                            }
                            maleSocket.setUserName(username);
                            MaleSocket m = maleSocket;
                            while (!(m instanceof NamedBean)) {
                                m = (MaleSocket)m.getObject();
                            }
                            NamedBeanHandleManager nbMan = InstanceManager.getDefault(NamedBeanHandleManager.class);
                            if (nbMan.inUse(maleSocket.getSystemName(), (NamedBean)((Object)m)) && (optionPane = JmriJOptionPane.showConfirmDialog(null, msg = Bundle.getMessage("UpdateToUserName", maleSocket.getManager().getBeanTypeHandled(), username, maleSocket.getSystemName()), Bundle.getMessage("UpdateToUserNameTitle"), 0)) == 0) {
                                try {
                                    nbMan.updateBeanFromSystemToUser((NamedBean)((Object)m));
                                }
                                catch (JmriException ex) {
                                    log.error("Impossible exception setting user name", (Throwable)ex);
                                }
                            }
                        }
                        ThreadingUtil.runOnGUIEventually(() -> {
                            if (this._treePane._femaleRootSocket.isActive()) {
                                this._treePane._femaleRootSocket.registerListeners();
                            }
                            this._changeUsernameDialog.dispose();
                            this._changeUsernameDialog = null;
                            for (TreeModelListener l : this._treePane.femaleSocketTreeModel.listeners) {
                                TreeModelEvent tme = new TreeModelEvent((Object)femaleSocket, path.getPath());
                                l.treeNodesChanged(tme);
                            }
                            this._treePane._tree.updateUI();
                        });
                        this.setPopupMenuLock(false);
                    });
                }
            });
            this._changeUsernameDialog = new JDialog(this, Bundle.getMessage("EditLocalVariablesDialogTitle", femaleSocket.getLongDescription()), false);
            Container contentPanel = this._changeUsernameDialog.getContentPane();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            JLabel usernameLabel = new JLabel("Username");
            this._usernameField.setText(maleSocket.getUserName());
            contentPanel.add(usernameLabel);
            contentPanel.add(this._usernameField);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
            buttonPanel.add(cancel);
            cancel.addActionListener(e -> {
                this._changeUsernameDialog.setVisible(false);
                this._changeUsernameDialog.dispose();
                this._changeUsernameDialog = null;
                this.setPopupMenuLock(false);
            });
            cancel.setToolTipText(Bundle.getMessage("LogixNG_CancelButtonHint"));
            buttonPanel.add(this._edit);
            this._changeUsernameDialog.getRootPane().setDefaultButton(this._edit);
            this._changeUsernameDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TreeEditor.this._changeUsernameDialog.setVisible(false);
                    TreeEditor.this._changeUsernameDialog.dispose();
                    TreeEditor.this._changeUsernameDialog = null;
                    TreeEditor.this.setPopupMenuLock(false);
                }
            });
            contentPanel.add(buttonPanel);
            this._autoSystemName.addItemListener(e -> this.autoSystemName());
            this._changeUsernameDialog.pack();
            this._changeUsernameDialog.setLocationRelativeTo(null);
            this._changeUsernameDialog.setVisible(true);
        }
    }

    protected final void autoSystemName() {
        if (this._autoSystemName.isSelected()) {
            this._systemName.setEnabled(false);
            this._sysNameLabel.setEnabled(false);
        } else {
            this._systemName.setEnabled(true);
            this._sysNameLabel.setEnabled(true);
        }
    }

    protected final void cancelRenameSocketPressed(ActionEvent e) {
        this._renameSocketDialog.setVisible(false);
        this._renameSocketDialog.dispose();
        this._renameSocketDialog = null;
        this.setPopupMenuLock(false);
        this.setVisible(true);
    }

    protected final void cancelCreateItem(ActionEvent e) {
        this._addItemDialog.setVisible(false);
        this._addSwingConfiguratorInterface.dispose();
        this._addItemDialog.dispose();
        this._addItemDialog = null;
        this.setPopupMenuLock(false);
        this.setVisible(true);
    }

    protected final void cancelEditPressed(ActionEvent e) {
        for (Map.Entry<SwingConfiguratorInterface, Base> entry : this._swingConfiguratorInterfaceList) {
            if (entry.getKey().canClose()) continue;
            return;
        }
        this._editActionExpressionDialog.setVisible(false);
        for (Map.Entry<SwingConfiguratorInterface, Base> entry : this._swingConfiguratorInterfaceList) {
            entry.getKey().dispose();
        }
        this._editActionExpressionDialog.dispose();
        this._editActionExpressionDialog = null;
        this.setPopupMenuLock(false);
        this.setVisible(true);
    }

    protected void executeEvaluate(SwingConfiguratorInterface swi, MaleSocket maleSocket) {
        swi.executeEvaluate(maleSocket);
    }

    private boolean itemIsSystem(FemaleSocket femaleSocket) {
        return femaleSocket.isConnected() && femaleSocket.getConnectedSocket().isSystem();
    }

    private boolean parentIsSystem(FemaleSocket femaleSocket) {
        Base parent;
        for (parent = femaleSocket.getParent(); parent != null && !(femaleSocket.getParent() instanceof MaleSocket); parent = parent.getParent()) {
        }
        return parent != null && ((MaleSocket)parent).isSystem();
    }

    private boolean abortEditAboutSystem(Base b) {
        int result = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("TreeEditor_ChangeSystemNode"), b.getLongDescription(), 0);
        return result != 0;
    }

    private void editItem(FemaleSocket femaleSocket, TreePath path) {
        if (this.itemIsSystem(femaleSocket) && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) {
            return;
        }
        this.editPressed(femaleSocket, path);
    }

    private void removeItem(FemaleSocket femaleSocket, TreePath path) {
        if ((this.parentIsSystem(femaleSocket) || this.itemIsSystem(femaleSocket)) && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) {
            return;
        }
        DeleteBeanWorker worker = new DeleteBeanWorker(femaleSocket, path);
        worker.execute();
    }

    private void cutItem(FemaleSocket femaleSocket, TreePath path) {
        if ((this.parentIsSystem(femaleSocket) || this.itemIsSystem(femaleSocket)) && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) {
            return;
        }
        if (femaleSocket.isConnected()) {
            this._treePane._femaleRootSocket.unregisterListeners();
            this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                Clipboard clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
                ArrayList<String> errors = new ArrayList<String>();
                MaleSocket maleSocket = femaleSocket.getConnectedSocket();
                femaleSocket.disconnect();
                if (!clipboard.add(maleSocket, errors)) {
                    JmriJOptionPane.showMessageDialog(this, String.join((CharSequence)"<br>", errors), Bundle.getMessage("TitleError"), 0);
                }
                ThreadingUtil.runOnGUIEventually(() -> {
                    maleSocket.forEntireTree(b -> {
                        b.removePropertyChangeListener(this._treePane);
                        if (_clipboardEditor != null) {
                            b.addPropertyChangeListener(TreeEditor._clipboardEditor._treePane);
                        }
                    });
                    this._treePane._femaleRootSocket.registerListeners();
                    this._treePane.updateTree(femaleSocket, path.getPath());
                });
            });
        } else {
            log.error("_currentFemaleSocket is not connected");
        }
    }

    private void copyItem(FemaleSocket femaleSocket) {
        if ((this.parentIsSystem(femaleSocket) || this.itemIsSystem(femaleSocket)) && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) {
            return;
        }
        if (femaleSocket.isConnected()) {
            this._treePane._femaleRootSocket.unregisterListeners();
            this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                Clipboard clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
                HashMap<String, String> systemNames = new HashMap<String, String>();
                HashMap<String, String> userNames = new HashMap<String, String>();
                MaleSocket maleSocket = null;
                try {
                    maleSocket = (MaleSocket)femaleSocket.getConnectedSocket().getDeepCopy(systemNames, userNames);
                    ArrayList<String> errors = new ArrayList<String>();
                    if (!clipboard.add(maleSocket, errors)) {
                        JmriJOptionPane.showMessageDialog(this, String.join((CharSequence)"<br>", errors), Bundle.getMessage("TitleError"), 0);
                    }
                }
                catch (JmriException ex) {
                    log.error("getDeepCopy thrown exception: {}", (Object)ex, (Object)ex);
                    ThreadingUtil.runOnGUIEventually(() -> JmriJOptionPane.showMessageDialog(null, "An exception has occured: " + ex.getMessage(), "An error has occured", 0));
                }
                if (maleSocket != null) {
                    MaleSocket socket = maleSocket;
                    ThreadingUtil.runOnGUIEventually(() -> socket.forEntireTree(b -> {
                        if (_clipboardEditor != null) {
                            b.addPropertyChangeListener(TreeEditor._clipboardEditor._treePane);
                        }
                    }));
                }
            });
            this._treePane._femaleRootSocket.registerListeners();
        } else {
            log.error("_currentFemaleSocket is not connected");
        }
    }

    private void pasteItem(FemaleSocket femaleSocket, TreePath path) {
        if (this.parentIsSystem(femaleSocket) && this.abortEditAboutSystem(femaleSocket.getParent())) {
            return;
        }
        if (!femaleSocket.isConnected()) {
            this._treePane._femaleRootSocket.unregisterListeners();
            this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                Clipboard clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
                try {
                    if (clipboard.getTopItem() == null) {
                        return;
                    }
                    if (!femaleSocket.isCompatible(clipboard.getTopItem())) {
                        log.error("Top item on clipboard is not compatible with the female socket");
                        return;
                    }
                    femaleSocket.connect(clipboard.fetchTopItem());
                    ArrayList<String> errors = new ArrayList<String>();
                    if (!femaleSocket.setParentForAllChildren(errors)) {
                        JmriJOptionPane.showMessageDialog(this, String.join((CharSequence)"<br>", errors), Bundle.getMessage("TitleError"), 0);
                    }
                }
                catch (SocketAlreadyConnectedException ex) {
                    log.error("item cannot be connected", (Throwable)ex);
                }
                ThreadingUtil.runOnGUIEventually(() -> {
                    this._treePane._femaleRootSocket.forEntireTree(b -> {
                        b.removePropertyChangeListener(this._treePane);
                        b.addPropertyChangeListener(this._treePane);
                    });
                    this._treePane._femaleRootSocket.registerListeners();
                    this._treePane.updateTree(femaleSocket, path.getPath());
                });
            });
        } else {
            log.error("_currentFemaleSocket is connected");
        }
    }

    private void pasteCopy(FemaleSocket femaleSocket, TreePath path) {
        if (this.parentIsSystem(femaleSocket) && this.abortEditAboutSystem(femaleSocket.getParent())) {
            return;
        }
        if (!femaleSocket.isConnected()) {
            this._treePane._femaleRootSocket.unregisterListeners();
            this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> {
                Clipboard clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
                if (clipboard.getTopItem() == null) {
                    return;
                }
                if (!femaleSocket.isCompatible(clipboard.getTopItem())) {
                    log.error("Top item on clipboard is not compatible with the female socket");
                    return;
                }
                HashMap<String, String> systemNames = new HashMap<String, String>();
                HashMap<String, String> userNames = new HashMap<String, String>();
                MaleSocket maleSocket = null;
                try {
                    maleSocket = (MaleSocket)clipboard.getTopItem().getDeepCopy(systemNames, userNames);
                }
                catch (JmriException ex) {
                    log.error("getDeepCopy thrown exception: {}", (Object)ex, (Object)ex);
                    ThreadingUtil.runOnGUIEventually(() -> JmriJOptionPane.showMessageDialog(null, "An exception has occured: " + ex.getMessage(), "An error has occured", 0));
                }
                if (maleSocket != null) {
                    try {
                        femaleSocket.connect(maleSocket);
                        ArrayList<String> errors = new ArrayList<String>();
                        if (!femaleSocket.setParentForAllChildren(errors)) {
                            JmriJOptionPane.showMessageDialog(this, String.join((CharSequence)"<br>", errors), Bundle.getMessage("TitleError"), 0);
                        }
                    }
                    catch (SocketAlreadyConnectedException ex) {
                        log.error("item cannot be connected", (Throwable)ex);
                    }
                    ThreadingUtil.runOnGUIEventually(() -> {
                        this._treePane._femaleRootSocket.forEntireTree(b -> {
                            b.removePropertyChangeListener(this._treePane);
                            b.addPropertyChangeListener(this._treePane);
                        });
                        this._treePane._femaleRootSocket.registerListeners();
                        this._treePane.updateTree(femaleSocket, path.getPath());
                    });
                }
            });
        } else {
            log.error("_currentFemaleSocket is connected");
        }
    }

    private void doIt(String command, FemaleSocket femaleSocket, TreePath path) {
        Base parent;
        for (parent = femaleSocket.getParent(); parent != null && !(femaleSocket.getParent() instanceof MaleSocket); parent = parent.getParent()) {
        }
        boolean parentIsSystem = parent != null && ((MaleSocket)parent).isSystem();
        boolean itemIsSystem = this.itemIsSystem(femaleSocket);
        switch (command) {
            case "rename_socket": {
                if (parentIsSystem && this.abortEditAboutSystem(femaleSocket.getParent())) break;
                this.renameSocketPressed(femaleSocket, path);
                break;
            }
            case "edit": {
                this.editItem(femaleSocket, path);
                break;
            }
            case "remove": {
                this.removeItem(femaleSocket, path);
                break;
            }
            case "cut": {
                this.cutItem(femaleSocket, path);
                break;
            }
            case "copy": {
                this.copyItem(femaleSocket);
                break;
            }
            case "paste": {
                this.pasteItem(femaleSocket, path);
                break;
            }
            case "pasteCopy": {
                this.pasteCopy(femaleSocket, path);
                break;
            }
            case "enable": {
                if (itemIsSystem && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) break;
                femaleSocket.getConnectedSocket().setEnabled(true);
                this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> ThreadingUtil.runOnGUIEventually(() -> {
                    this._treePane._femaleRootSocket.unregisterListeners();
                    this._treePane.updateTree(femaleSocket, path.getPath());
                    this._treePane._femaleRootSocket.registerListeners();
                }));
                break;
            }
            case "disable": {
                if (itemIsSystem && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) break;
                femaleSocket.getConnectedSocket().setEnabled(false);
                this.runOnConditionalNGThreadOrGUIThreadEventually(this._treePane._femaleRootSocket.getConditionalNG(), () -> ThreadingUtil.runOnGUIEventually(() -> {
                    this._treePane._femaleRootSocket.unregisterListeners();
                    this._treePane.updateTree(femaleSocket, path.getPath());
                    this._treePane._femaleRootSocket.registerListeners();
                }));
                break;
            }
            case "lock": {
                if (itemIsSystem && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) break;
                femaleSocket.forEntireTree(item -> {
                    if (item instanceof MaleSocket) {
                        ((MaleSocket)item).setLocked(true);
                    }
                });
                this._treePane.updateTree(femaleSocket, path.getPath());
                break;
            }
            case "unlock": {
                if (itemIsSystem && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) break;
                femaleSocket.forEntireTree(item -> {
                    if (item instanceof MaleSocket) {
                        ((MaleSocket)item).setLocked(false);
                    }
                });
                this._treePane.updateTree(femaleSocket, path.getPath());
                break;
            }
            case "local_variables": {
                if (itemIsSystem && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) break;
                this.editLocalVariables(femaleSocket, path);
                break;
            }
            case "change_username": {
                if (itemIsSystem && this.abortEditAboutSystem(femaleSocket.getConnectedSocket())) break;
                this.changeUsername(femaleSocket, path);
                break;
            }
            case "execute_evaluate": {
                Base object = femaleSocket.getConnectedSocket();
                if (object == null) {
                    throw new NullPointerException("object is null");
                }
                while (object instanceof MaleSocket) {
                    object = object.getObject();
                }
                SwingConfiguratorInterface swi = SwingTools.getSwingConfiguratorForClass(object.getClass());
                this.executeEvaluate(swi, femaleSocket.getConnectedSocket());
                break;
            }
            default: {
                if (this.checkFemaleSocketOperation(femaleSocket, parentIsSystem, itemIsSystem, command)) break;
                log.error("e.getActionCommand() returns unknown value {}", (Object)command);
            }
        }
    }

    private boolean checkFemaleSocketOperation(FemaleSocket femaleSocket, boolean parentIsSystem, boolean itemIsSystem, String command) {
        for (FemaleSocketOperation oper : FemaleSocketOperation.values()) {
            if (!oper.name().equals(command)) continue;
            if ((parentIsSystem || itemIsSystem) && this.abortEditAboutSystem(femaleSocket.getParent())) {
                return true;
            }
            femaleSocket.doSocketOperation(oper);
            return true;
        }
        return false;
    }

    private boolean parentIsLocked(FemaleSocket femaleSocket) {
        Base parent;
        for (parent = femaleSocket.getParent(); parent != null && !(parent instanceof MaleSocket); parent = parent.getParent()) {
        }
        return parent != null && ((MaleSocket)parent).isLocked();
    }

    private class DeleteBeanWorker
    extends SwingWorker<Void, Void> {
        private final FemaleSocket _currentFemaleSocket;
        private final TreePath _currentPath;
        MaleSocket _maleSocket;

        public DeleteBeanWorker(FemaleSocket currentFemaleSocket, TreePath currentPath) {
            this._currentFemaleSocket = currentFemaleSocket;
            this._currentPath = currentPath;
            this._maleSocket = this._currentFemaleSocket.getConnectedSocket();
        }

        public int getDisplayDeleteMsg() {
            return InstanceManager.getDefault(UserPreferencesManager.class).getMultipleChoiceOption(TreeEditor.getClassName(), "deleteInUse");
        }

        public void setDisplayDeleteMsg(int boo) {
            InstanceManager.getDefault(UserPreferencesManager.class).setMultipleChoiceOption(TreeEditor.getClassName(), "deleteInUse", boo);
        }

        public void doDelete() {
            TreeEditor.this._treePane._femaleRootSocket.unregisterListeners();
            try {
                this._currentFemaleSocket.disconnect();
                this._maleSocket.getManager().deleteBean(this._maleSocket, "DoDelete");
            }
            catch (PropertyVetoException e) {
                log.error("Unexpected doDelete failure for {}, {}", (Object)this._maleSocket, (Object)e.getMessage());
            }
            finally {
                if (TreeEditor.this._treePane._femaleRootSocket.isActive()) {
                    TreeEditor.this._treePane._femaleRootSocket.registerListeners();
                }
            }
        }

        @Override
        public Void doInBackground() {
            StringBuilder message = new StringBuilder();
            try {
                this._maleSocket.getManager().deleteBean(this._maleSocket, "CanDelete");
            }
            catch (PropertyVetoException e2) {
                if (e2.getPropertyChangeEvent().getPropertyName().equals("DoNotDelete")) {
                    log.warn("Do not Delete {}, {}", (Object)this._maleSocket, (Object)e2.getMessage());
                    message.append(Bundle.getMessage("VetoDeleteBean", ((NamedBean)((Object)this._maleSocket.getObject())).getBeanType(), ((NamedBean)((Object)this._maleSocket.getObject())).getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), e2.getMessage()));
                    JmriJOptionPane.showMessageDialog(null, message.toString(), Bundle.getMessage("WarningTitle"), 0);
                    return null;
                }
                message.append(e2.getMessage());
            }
            ArrayList<String> listenerRefs = new ArrayList<String>();
            this._maleSocket.getListenerRefsIncludingChildren(listenerRefs);
            int count = listenerRefs.size();
            log.debug("Delete with {}", (Object)count);
            if (this.getDisplayDeleteMsg() == 2 && message.toString().isEmpty()) {
                this.doDelete();
            } else {
                String prompt;
                JDialog dialog = new JDialog();
                dialog.setTitle(Bundle.getMessage("WarningTitle"));
                dialog.setDefaultCloseOperation(2);
                JPanel container = new JPanel();
                container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                container.setLayout(new BoxLayout(container, 1));
                if (count > 0) {
                    prompt = this._maleSocket.getChildCount() > 0 ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                    JLabel question = new JLabel(Bundle.getMessage(prompt, ((NamedBean)((Object)this._maleSocket.getObject())).getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
                    question.setAlignmentX(0.5f);
                    container.add(question);
                    ArrayList<String> tempListenerRefs = new ArrayList<String>();
                    tempListenerRefs.addAll(listenerRefs);
                    if (tempListenerRefs.size() > 0) {
                        int i;
                        ArrayList<String> listeners = new ArrayList<String>();
                        for (i = 0; i < tempListenerRefs.size(); ++i) {
                            if (listeners.contains(tempListenerRefs.get(i))) continue;
                            listeners.add((String)tempListenerRefs.get(i));
                        }
                        message.append("<br>");
                        message.append(Bundle.getMessage("ReminderInUse", count));
                        message.append("<ul>");
                        for (i = 0; i < listeners.size(); ++i) {
                            message.append("<li>");
                            message.append((String)listeners.get(i));
                            message.append("</li>");
                        }
                        message.append("</ul>");
                        JEditorPane pane = new JEditorPane();
                        pane.setContentType("text/html");
                        pane.setText("<html>" + message.toString() + "</html>");
                        pane.setEditable(false);
                        JScrollPane jScrollPane = new JScrollPane(pane);
                        container.add(jScrollPane);
                    }
                } else {
                    prompt = this._maleSocket.getChildCount() > 0 ? "DeleteWithChildrenPrompt" : "DeletePrompt";
                    String msg = MessageFormat.format(Bundle.getMessage(prompt), this._maleSocket.getSystemName());
                    JLabel question = new JLabel(msg);
                    question.setAlignmentX(0.5f);
                    container.add(question);
                }
                JCheckBox remember = new JCheckBox(Bundle.getMessage("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                remember.setAlignmentX(0.5f);
                JButton yesButton = new JButton(Bundle.getMessage("ButtonYes"));
                JButton noButton = new JButton(Bundle.getMessage("ButtonNo"));
                JPanel button = new JPanel();
                button.setAlignmentX(0.5f);
                button.add(yesButton);
                button.add(noButton);
                container.add(button);
                noButton.addActionListener(e -> dialog.dispose());
                yesButton.addActionListener(e -> {
                    if (remember.isSelected()) {
                        this.setDisplayDeleteMsg(2);
                    }
                    this.doDelete();
                    dialog.dispose();
                });
                container.add(remember);
                container.setAlignmentX(0.5f);
                container.setAlignmentY(0.5f);
                dialog.getContentPane().add(container);
                dialog.pack();
                dialog.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getHeight() / 2);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Exception while deleting bean", (Throwable)e);
            }
            TreeEditor.this._treePane.updateTree(this._currentFemaleSocket, this._currentPath.getPath());
        }
    }

    protected final class PopupMenu
    extends JPopupMenu
    implements ActionListener {
        private final JTree _tree;
        private final FemaleSocket _currentFemaleSocket;
        private final TreePath _currentPath;
        private JMenuItem menuItemRenameSocket;
        private JMenuItem menuItemRemove;
        private JMenuItem menuItemCut;
        private JMenuItem menuItemCopy;
        private JMenuItem menuItemPaste;
        private JMenuItem menuItemPasteCopy;
        private final Map<FemaleSocketOperation, JMenuItem> menuItemFemaleSocketOperation = new HashMap<FemaleSocketOperation, JMenuItem>();
        private JMenuItem menuItemEnable;
        private JMenuItem menuItemDisable;
        private JMenuItem menuItemLock;
        private JMenuItem menuItemUnlock;
        private JMenuItem menuItemLocalVariables;
        private JMenuItem menuItemChangeUsername;
        private JMenuItem menuItemExecuteEvaluate;
        private final boolean _isConnected;
        private final boolean _canConnectFromClipboard;
        private final boolean _disableForRoot;
        private final boolean _isLocked;
        private final boolean _parentIsLocked;

        PopupMenu(int x, int y, FemaleSocket femaleSocket, TreePath path, boolean onlyAddItems) {
            if (TreeEditor.this._treePane._tree == null) {
                throw new IllegalArgumentException("_tree is null");
            }
            this._tree = TreeEditor.this._treePane._tree;
            this._currentFemaleSocket = femaleSocket;
            this._currentPath = path;
            this._isConnected = femaleSocket.isConnected();
            Clipboard clipboard = InstanceManager.getDefault(LogixNG_Manager.class).getClipboard();
            MaleSocket topItem = clipboard.getTopItem();
            this._canConnectFromClipboard = topItem != null && femaleSocket.isCompatible(topItem) && !femaleSocket.isAncestor(topItem);
            this._disableForRoot = TreeEditor.this._disableRootRemoveCutCopy && this._currentFemaleSocket == TreeEditor.this._treePane._femaleRootSocket;
            this._isLocked = this._isConnected && femaleSocket.getConnectedSocket().isLocked();
            this._parentIsLocked = TreeEditor.this.parentIsLocked(femaleSocket);
            if (onlyAddItems) {
                this.addNewItemTypes(this);
            } else {
                JMenuItem menuItem;
                if (TreeEditor.this._disableRootPopup && this._currentFemaleSocket == TreeEditor.this._treePane._femaleRootSocket) {
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("TreeEditor_RootHasNoPopupMenu"), Bundle.getMessage("TreeEditor_Info"), 0);
                    return;
                }
                this.menuItemRenameSocket = new JMenuItem(Bundle.getMessage("PopupMenuRenameSocket"));
                this.menuItemRenameSocket.addActionListener(this);
                this.menuItemRenameSocket.setActionCommand(TreeEditor.ACTION_COMMAND_RENAME_SOCKET);
                this.add(this.menuItemRenameSocket);
                this.addSeparator();
                if (!this._isConnected && !this._parentIsLocked) {
                    JMenu addMenu = new JMenu(Bundle.getMessage("PopupMenuAdd"));
                    this.addNewItemTypes(addMenu);
                    this.add(addMenu);
                }
                if (this._isConnected && !this._isLocked) {
                    FemaleSocketOperation[] menuItemEdit = new JMenuItem(Bundle.getMessage("PopupMenuEdit"));
                    menuItemEdit.addActionListener(this);
                    menuItemEdit.setActionCommand(TreeEditor.ACTION_COMMAND_EDIT);
                    menuItemEdit.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                    this.add((JMenuItem)menuItemEdit);
                }
                this.addSeparator();
                this.menuItemRemove = new JMenuItem(Bundle.getMessage("PopupMenuRemove"));
                this.menuItemRemove.addActionListener(this);
                this.menuItemRemove.setActionCommand(TreeEditor.ACTION_COMMAND_REMOVE);
                this.menuItemRemove.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                this.add(this.menuItemRemove);
                this.addSeparator();
                this.menuItemCut = new JMenuItem(Bundle.getMessage("PopupMenuCut"));
                this.menuItemCut.addActionListener(this);
                this.menuItemCut.setActionCommand(TreeEditor.ACTION_COMMAND_CUT);
                this.menuItemCut.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                this.add(this.menuItemCut);
                this.menuItemCopy = new JMenuItem(Bundle.getMessage("PopupMenuCopy"));
                this.menuItemCopy.addActionListener(this);
                this.menuItemCopy.setActionCommand(TreeEditor.ACTION_COMMAND_COPY);
                this.menuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                this.add(this.menuItemCopy);
                this.menuItemPaste = new JMenuItem(Bundle.getMessage("PopupMenuPaste"));
                this.menuItemPaste.addActionListener(this);
                this.menuItemPaste.setActionCommand(TreeEditor.ACTION_COMMAND_PASTE);
                this.menuItemPaste.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                this.add(this.menuItemPaste);
                this.menuItemPasteCopy = new JMenuItem(Bundle.getMessage("PopupMenuPasteCopy"));
                this.menuItemPasteCopy.addActionListener(this);
                this.menuItemPasteCopy.setActionCommand(TreeEditor.ACTION_COMMAND_PASTE_COPY);
                this.menuItemPasteCopy.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64));
                this.add(this.menuItemPasteCopy);
                this.addSeparator();
                for (FemaleSocketOperation oper : FemaleSocketOperation.values()) {
                    menuItem = new JMenuItem(oper.toString());
                    menuItem.addActionListener(this);
                    menuItem.setActionCommand(oper.name());
                    this.add(menuItem);
                    this.menuItemFemaleSocketOperation.put(oper, menuItem);
                    if (!oper.hasKey()) continue;
                    menuItem.setAccelerator(KeyStroke.getKeyStroke(oper.getKeyCode(), oper.getModifiers()));
                }
                this.addSeparator();
                this.menuItemEnable = new JMenuItem(Bundle.getMessage("PopupMenuEnable"));
                this.menuItemEnable.addActionListener(this);
                this.menuItemEnable.setActionCommand(TreeEditor.ACTION_COMMAND_ENABLE);
                this.menuItemEnable.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64));
                this.add(this.menuItemEnable);
                this.menuItemDisable = new JMenuItem(Bundle.getMessage("PopupMenuDisable"));
                this.menuItemDisable.addActionListener(this);
                this.menuItemDisable.setActionCommand(TreeEditor.ACTION_COMMAND_DISABLE);
                this.menuItemDisable.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                this.add(this.menuItemDisable);
                this.menuItemLock = new JMenuItem(Bundle.getMessage("PopupMenuLock"));
                this.menuItemLock.addActionListener(this);
                this.menuItemLock.setActionCommand(TreeEditor.ACTION_COMMAND_LOCK);
                this.add(this.menuItemLock);
                this.menuItemUnlock = new JMenuItem(Bundle.getMessage("PopupMenuUnlock"));
                this.menuItemUnlock.addActionListener(this);
                this.menuItemUnlock.setActionCommand(TreeEditor.ACTION_COMMAND_UNLOCK);
                this.add(this.menuItemUnlock);
                this.addSeparator();
                this.menuItemLocalVariables = new JMenuItem(Bundle.getMessage("PopupMenuLocalVariables"));
                this.menuItemLocalVariables.addActionListener(this);
                this.menuItemLocalVariables.setActionCommand(TreeEditor.ACTION_COMMAND_LOCAL_VARIABLES);
                this.add(this.menuItemLocalVariables);
                this.addSeparator();
                this.menuItemChangeUsername = new JMenuItem(Bundle.getMessage("PopupMenuChangeUsername"));
                this.menuItemChangeUsername.addActionListener(this);
                this.menuItemChangeUsername.setActionCommand(TreeEditor.ACTION_COMMAND_CHANGE_USERNAME);
                this.add(this.menuItemChangeUsername);
                if (TreeEditor.this._enableExecuteEvaluate) {
                    this.addSeparator();
                    this.menuItemExecuteEvaluate = new JMenuItem();
                    this.menuItemExecuteEvaluate.addActionListener(this);
                    this.menuItemExecuteEvaluate.setActionCommand(TreeEditor.ACTION_COMMAND_EXECUTE_EVALUATE);
                    this.add(this.menuItemExecuteEvaluate);
                }
                this.setOpaque(true);
                this.setLightWeightPopupEnabled(true);
                this.menuItemRemove.setEnabled(this._isConnected && !this._isLocked && !this._parentIsLocked && !this._disableForRoot);
                this.menuItemCut.setEnabled(this._isConnected && !this._isLocked && !this._parentIsLocked && !this._disableForRoot);
                this.menuItemCopy.setEnabled(this._isConnected && !this._disableForRoot);
                this.menuItemPaste.setEnabled(!this._isConnected && !this._parentIsLocked && this._canConnectFromClipboard);
                this.menuItemPasteCopy.setEnabled(!this._isConnected && !this._parentIsLocked && this._canConnectFromClipboard);
                if (this._isConnected && !this._disableForRoot) {
                    this.menuItemEnable.setEnabled(!femaleSocket.getConnectedSocket().isEnabled() && !this._isLocked);
                    this.menuItemDisable.setEnabled(femaleSocket.getConnectedSocket().isEnabled() && !this._isLocked);
                } else {
                    this.menuItemEnable.setEnabled(false);
                    this.menuItemDisable.setEnabled(false);
                }
                for (FemaleSocketOperation oper : FemaleSocketOperation.values()) {
                    menuItem = this.menuItemFemaleSocketOperation.get((Object)oper);
                    menuItem.setEnabled(femaleSocket.isSocketOperationAllowed(oper) && !this._parentIsLocked);
                }
                AtomicBoolean isAnyLocked = new AtomicBoolean(false);
                AtomicBoolean isAnyUnlocked = new AtomicBoolean(false);
                this._currentFemaleSocket.forEntireTree(item -> {
                    if (item instanceof MaleSocket) {
                        isAnyLocked.set(isAnyLocked.get() || ((MaleSocket)item).isLocked());
                        isAnyUnlocked.set(isAnyUnlocked.get() || !((MaleSocket)item).isLocked());
                    }
                });
                this.menuItemLock.setEnabled(isAnyUnlocked.get());
                this.menuItemUnlock.setEnabled(isAnyLocked.get());
                this.menuItemLocalVariables.setEnabled(femaleSocket.isConnected() && femaleSocket.getConnectedSocket().isSupportingLocalVariables() && !this._isLocked);
                this.menuItemChangeUsername.setEnabled(femaleSocket.isConnected() && !this._isLocked);
                if (TreeEditor.this._enableExecuteEvaluate) {
                    this.menuItemExecuteEvaluate.setEnabled(femaleSocket.isConnected());
                    if (femaleSocket.isConnected()) {
                        Base object = this._currentFemaleSocket.getConnectedSocket();
                        if (object == null) {
                            throw new NullPointerException("object is null");
                        }
                        while (object instanceof MaleSocket) {
                            object = object.getObject();
                        }
                        this.menuItemExecuteEvaluate.setText(SwingTools.getSwingConfiguratorForClass(object.getClass()).getExecuteEvaluateMenuText());
                    }
                }
            }
            this.show(this._tree, x, y);
        }

        private void addNewItemTypes(Container container) {
            Map<Category, List<Class<? extends Base>>> connectableClasses = this._currentFemaleSocket.getConnectableClasses();
            ArrayList<Category> list = new ArrayList<Category>(connectableClasses.keySet());
            Collections.sort(list);
            for (Category category : list) {
                ArrayList<SwingConfiguratorInterface> sciList = new ArrayList<SwingConfiguratorInterface>();
                List<Class<? extends Base>> classes = connectableClasses.get(category);
                if (classes != null && !classes.isEmpty()) {
                    for (Class<? extends Base> clazz : classes) {
                        SwingConfiguratorInterface sci = SwingTools.getSwingConfiguratorForClass(clazz);
                        if (sci != null) {
                            sciList.add(sci);
                            continue;
                        }
                        log.error("Class {} has no swing configurator interface", (Object)clazz.getName());
                    }
                }
                Collections.sort(sciList);
                JMenu categoryMenu = new JMenu(category.toString());
                for (SwingConfiguratorInterface sci : sciList) {
                    JMenuItem item = new JMenuItem(sci.toString());
                    item.addActionListener(e -> TreeEditor.this.createAddFrame(this._currentFemaleSocket, this._currentPath, sci));
                    categoryMenu.add(item);
                }
                container.add(categoryMenu);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeEditor.this.doIt(e.getActionCommand(), this._currentFemaleSocket, this._currentPath);
        }
    }

    public static enum EnableExecuteEvaluate {
        EnableExecuteEvaluate,
        DisableExecuteEvaluate;

    }

    public static enum EnableRootPopup {
        EnableRootPopup,
        DisableRootPopup;

    }

    public static enum EnableRootRemoveCutCopy {
        EnableRootRemoveCutCopy,
        DisableRootRemoveCutCopy;

    }

    public static enum EnableClipboard {
        EnableClipboard,
        DisableClipboard;

    }
}

