/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.tools.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.tools.swing.Bundle;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;

public class TreePane
extends JPanel
implements PropertyChangeListener {
    private boolean _rootVisible = true;
    private static final Map<String, Color> FEMALE_SOCKET_COLORS = new HashMap<String, Color>();
    JTree _tree;
    protected final FemaleSocket _femaleRootSocket;
    protected FemaleSocketTreeModel femaleSocketTreeModel;

    public TreePane(FemaleSocket femaleRootSocket) {
        this._femaleRootSocket = femaleRootSocket;
        FEMALE_SOCKET_COLORS.put("jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket", Color.RED);
        FEMALE_SOCKET_COLORS.put("jmri.jmrit.logixng.implementation.DefaultFemaleDigitalExpressionSocket", Color.BLUE);
        this._femaleRootSocket.forEntireTree(b -> b.addPropertyChangeListener(this));
    }

    public void initComponents() {
        this.initComponents((femaleSocket, panel) -> panel);
    }

    public void initComponents(FemaleSocketDecorator decorator) {
        this.femaleSocketTreeModel = new FemaleSocketTreeModel(this._femaleRootSocket);
        this._tree = new JTree();
        this._tree.setRowHeight(0);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.setModel(this.femaleSocketTreeModel);
        this._tree.setCellRenderer(new FemaleSocketTreeRenderer(decorator));
        this._tree.setRootVisible(this._rootVisible);
        this._tree.setShowsRootHandles(true);
        for (int i = 0; i < this._tree.getRowCount(); ++i) {
            FemaleSocket femaleSocket = (FemaleSocket)this._tree.getPathForRow(i).getLastPathComponent();
            if (!femaleSocket.isConnected() || !femaleSocket.getConnectedSocket().isEnabled()) continue;
            this._tree.expandRow(i);
        }
        JScrollPane scrollpane = new JScrollPane(this._tree);
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)scrollpane, "Center");
    }

    public boolean getRootVisible() {
        return this._rootVisible;
    }

    public void setRootVisible(boolean rootVisible) {
        this._rootVisible = rootVisible;
    }

    protected void getPath(Base base, List<FemaleSocket> list) {
        for (Base b = base; b != null; b = b.getParent()) {
            if (!(b instanceof FemaleSocket)) continue;
            list.add(0, (FemaleSocket)b);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ArrayList<FemaleSocket> list;
        if ("ChildCount".equals(evt.getPropertyName())) {
            if (evt.getOldValue() != null) {
                if (!(evt.getOldValue() instanceof List)) {
                    throw new RuntimeException("Old value is not a list");
                }
                for (FemaleSocket socket : (List)evt.getOldValue()) {
                    socket.removePropertyChangeListener(this);
                }
            }
            if (evt.getNewValue() != null) {
                if (!(evt.getNewValue() instanceof List)) {
                    throw new RuntimeException("New value is not a list");
                }
                for (FemaleSocket socket : (List)evt.getNewValue()) {
                    socket.addPropertyChangeListener(this);
                }
            }
            Base b = (Base)evt.getSource();
            list = new ArrayList<FemaleSocket>();
            this.getPath(b, list);
            ThreadingUtil.runOnGUIEventually(() -> {
                FemaleSocket femaleSocket = (FemaleSocket)list.get(list.size() - 1);
                this.updateTree(femaleSocket, list.toArray());
            });
        }
        if ("ChildReorder".equals(evt.getPropertyName())) {
            if (!(evt.getNewValue() instanceof List)) {
                throw new RuntimeException("New value is not a list");
            }
            for (FemaleSocket socket : (List)evt.getNewValue()) {
                ArrayList<FemaleSocket> list2 = new ArrayList<FemaleSocket>();
                this.getPath(socket, list2);
                ThreadingUtil.runOnGUIEventually(() -> this.updateTree(socket, list2.toArray()));
            }
        }
        if ("SocketConnected".equals(evt.getPropertyName()) || "SocketDisconnected".equals(evt.getPropertyName())) {
            FemaleSocket femaleSocket = (FemaleSocket)evt.getSource();
            list = new ArrayList();
            this.getPath(femaleSocket, list);
            ThreadingUtil.runOnGUIEventually(() -> this.updateTree(femaleSocket, list.toArray()));
        }
    }

    protected void updateTree(FemaleSocket currentFemaleSocket, Object[] currentPath) {
        TreeModelEvent tme = new TreeModelEvent((Object)currentFemaleSocket, currentPath);
        for (TreeModelListener l : this.femaleSocketTreeModel.listeners) {
            l.treeNodesChanged(tme);
        }
        this._tree.updateUI();
        FemaleSocket femaleSocket = (FemaleSocket)this._tree.getLastSelectedPathComponent();
        if (femaleSocket != null && !femaleSocket.existsInTree()) {
            this._tree.getSelectionModel().clearSelection();
        }
    }

    public void updateTree(Base item) {
        ArrayList<FemaleSocket> list = new ArrayList<FemaleSocket>();
        this.getPath(item, list);
        FemaleSocket femaleSocket = (FemaleSocket)list.get(list.size() - 1);
        this.updateTree(femaleSocket, list.toArray());
    }

    public void dispose() {
        this._femaleRootSocket.forEntireTree(b -> b.removePropertyChangeListener(this));
    }

    public static interface FemaleSocketDecorator {
        public JPanel decorate(FemaleSocket var1, JPanel var2);
    }

    private static final class FemaleSocketTreeRenderer
    implements TreeCellRenderer {
        private final FemaleSocketDecorator _decorator;
        private static ImageIcon _lockIcon;

        public FemaleSocketTreeRenderer(FemaleSocketDecorator decorator) {
            this._decorator = decorator;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            UIDefaults uiDefaults = UIManager.getDefaults();
            FemaleSocket socket = (FemaleSocket)value;
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, 1));
            mainPanel.setOpaque(false);
            if (selected && InstanceManager.getDefault(LogixNGPreferences.class).getTreeEditorHighlightRow()) {
                mainPanel.setOpaque(true);
                mainPanel.setBackground(uiDefaults.getColor("Tree.selectionBackground"));
            }
            JPanel commentPanel = new JPanel(new FlowLayout(0, 0, 0));
            mainPanel.add(commentPanel);
            JPanel panel = new JPanel();
            panel.setAlignmentX(0.0f);
            mainPanel.add(panel);
            panel.setLayout(new BoxLayout(panel, 0));
            panel.setOpaque(false);
            JLabel socketLabel = new JLabel(socket.getShortDescription());
            Font font = socketLabel.getFont();
            socketLabel.setFont(font.deriveFont((float)((double)font.getSize2D() * 1.7)));
            socketLabel.setForeground(FEMALE_SOCKET_COLORS.get(socket.getClass().getName()));
            panel.add(socketLabel);
            panel.add(Box.createRigidArea(new Dimension(5, 0)));
            JLabel socketNameLabel = new JLabel(socket.getName());
            socketNameLabel.setForeground(FEMALE_SOCKET_COLORS.get(socket.getClass().getName()));
            panel.add(socketNameLabel);
            panel.add(Box.createRigidArea(new Dimension(5, 0)));
            JLabel connectedItemLabel = new JLabel();
            if (socket.isConnected()) {
                String comment;
                MaleSocket connectedSocket;
                if (InstanceManager.getDefault(LogixNGPreferences.class).getTreeEditorHighlightRow()) {
                    connectedItemLabel.setFont(uiDefaults.getFont("Tree.font"));
                    if (selected) {
                        connectedItemLabel.setForeground(uiDefaults.getColor("Tree.selectionForeground"));
                    }
                }
                if ((connectedSocket = socket.getConnectedSocket()).isSystem()) {
                    JLabel systemLabel = new JLabel(" " + Bundle.getMessage("TreePane_System") + " ", 0);
                    systemLabel.setForeground(Color.YELLOW);
                    systemLabel.setBackground(Color.RED);
                    systemLabel.setOpaque(true);
                    panel.add(systemLabel);
                    panel.add(Box.createRigidArea(new Dimension(5, 0)));
                }
                if (connectedSocket.isLocked()) {
                    if (_lockIcon == null) {
                        _lockIcon = new ImageIcon(FileUtil.findURL("program:resources/icons/logixng/lock.png", FileUtil.Location.INSTALLED));
                    }
                    JLabel icLabel = new JLabel(_lockIcon, 0);
                    panel.add(icLabel);
                }
                if ((comment = connectedSocket.getComment()) != null) {
                    JLabel commentLabel = new JLabel();
                    commentLabel.setText("<html><pre>" + comment + "</pre></html>");
                    commentLabel.setForeground(Color.GRAY);
                    Font font2 = commentLabel.getFont();
                    commentLabel.setFont(font2.deriveFont(2));
                    commentPanel.setOpaque(false);
                    commentPanel.add(commentLabel);
                    commentPanel.setAlignmentX(0.0f);
                    commentPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
                }
                Object label = connectedSocket.getLongDescription();
                if (connectedSocket.getUserName() != null) {
                    label = (String)label + " ::: " + connectedSocket.getUserName();
                }
                if (!connectedSocket.isEnabled()) {
                    label = "<html><strike>" + (String)label + "</strike></html>";
                }
                connectedItemLabel.setText((String)label);
                mainPanel.setToolTipText(connectedSocket.getShortDescription());
                for (SymbolTable.VariableData variableData : connectedSocket.getLocalVariables()) {
                    JLabel variableLabel = new JLabel(Bundle.getMessage("PrintLocalVariable", new Object[]{variableData._name, variableData._initialValueType, variableData._initialValueData}));
                    variableLabel.setAlignmentX(0.0f);
                    if (InstanceManager.getDefault(LogixNGPreferences.class).getTreeEditorHighlightRow()) {
                        variableLabel.setFont(uiDefaults.getFont("Tree.font"));
                        if (selected) {
                            variableLabel.setForeground(uiDefaults.getColor("Tree.selectionForeground"));
                        }
                    }
                    mainPanel.add(variableLabel);
                }
            }
            panel.add(connectedItemLabel);
            return this._decorator.decorate(socket, mainPanel);
        }
    }

    public static class FemaleSocketTreeModel
    implements TreeModel {
        private final FemaleSocket _root;
        protected final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

        public FemaleSocketTreeModel(FemaleSocket root) {
            this._root = root;
        }

        @Override
        public Object getRoot() {
            return this._root;
        }

        @Override
        public boolean isLeaf(Object node) {
            FemaleSocket socket = (FemaleSocket)node;
            if (!socket.isConnected()) {
                return true;
            }
            return socket.getConnectedSocket().getChildCount() == 0;
        }

        @Override
        public int getChildCount(Object parent) {
            FemaleSocket socket = (FemaleSocket)parent;
            if (!socket.isConnected()) {
                return 0;
            }
            return socket.getConnectedSocket().getChildCount();
        }

        @Override
        public Object getChild(Object parent, int index) {
            FemaleSocket socket = (FemaleSocket)parent;
            if (!socket.isConnected()) {
                return null;
            }
            return socket.getConnectedSocket().getChild(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            FemaleSocket socket = (FemaleSocket)parent;
            if (!socket.isConnected()) {
                return -1;
            }
            MaleSocket connectedSocket = socket.getConnectedSocket();
            for (int i = 0; i < connectedSocket.getChildCount(); ++i) {
                if (child != connectedSocket.getChild(i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newvalue) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }
    }
}

