/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import java.beans.PropertyChangeListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.Bundle;
import jmri.jmrit.logixng.util.InUse;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNG_SelectCharset {
    public static final List<Charset> STANDARD_CHARSETS = LogixNG_SelectCharset.getStandardCharsets();
    private final AbstractBase _base;
    private final InUse _inUse;
    private Addressing _addressing = Addressing.Standard;
    private Charset _standardValue = StandardCharsets.UTF_8;
    private Charset _allValue = StandardCharsets.UTF_8;
    private final LogixNG_SelectString _selectUserSpecifiedCharset;
    private static final Logger log = LoggerFactory.getLogger(LogixNG_SelectCharset.class);

    public LogixNG_SelectCharset(AbstractBase base, PropertyChangeListener listener) {
        this._base = base;
        this._inUse = () -> this._addressing == Addressing.UserSpecified;
        this._selectUserSpecifiedCharset = new LogixNG_SelectString(base, this._inUse, listener);
    }

    private static List<Charset> getStandardCharsets() {
        ArrayList<Charset> standardCharsets = new ArrayList<Charset>();
        standardCharsets.add(StandardCharsets.US_ASCII);
        standardCharsets.add(StandardCharsets.ISO_8859_1);
        standardCharsets.add(StandardCharsets.UTF_8);
        standardCharsets.add(StandardCharsets.UTF_16);
        standardCharsets.add(StandardCharsets.UTF_16BE);
        standardCharsets.add(StandardCharsets.UTF_16LE);
        return Collections.unmodifiableList(standardCharsets);
    }

    public void copy(LogixNG_SelectCharset copy) throws ParserException {
        copy.setAddressing(this._addressing);
        copy.setStandardValue(this._standardValue);
        copy.setAllValue(this._standardValue);
        this._selectUserSpecifiedCharset.copy(copy._selectUserSpecifiedCharset);
    }

    public void setAddressing(@Nonnull Addressing addressing) {
        this._addressing = addressing;
    }

    public Addressing getAddressing() {
        return this._addressing;
    }

    public void setStandardValue(@Nonnull Charset charset) {
        this._base.assertListenersAreNotRegistered(log, "setStandardValue");
        this._standardValue = charset;
    }

    public Charset getStandardValue() {
        return this._standardValue;
    }

    public void setAllValue(@Nonnull Charset charset) {
        this._base.assertListenersAreNotRegistered(log, "setListValue");
        this._allValue = charset;
    }

    public Charset getAllValue() {
        return this._allValue;
    }

    public LogixNG_SelectString getSelectUserSpecified() {
        return this._selectUserSpecifiedCharset;
    }

    public Charset evaluateCharset(ConditionalNG conditionalNG) throws JmriException {
        switch (this._addressing) {
            case Standard: {
                return this._standardValue;
            }
            case All: {
                return this._standardValue;
            }
            case UserSpecified: {
                String charsetName = this._selectUserSpecifiedCharset.evaluateValue(conditionalNG);
                return Charset.forName(charsetName);
            }
        }
        throw new IllegalArgumentException("_addressing has unknown value: " + this._addressing.name());
    }

    public String getDescription(Locale locale) {
        return "ERROR !!!!";
    }

    public void registerListeners() {
    }

    public void unregisterListeners() {
    }

    public static enum Addressing {
        Standard(Bundle.getMessage("LogixNG_SelectCharset_Addressing_Standard")),
        All(Bundle.getMessage("LogixNG_SelectCharset_Addressing_All")),
        UserSpecified(Bundle.getMessage("LogixNG_SelectCharset_Addressing_UserSpecified"));

        private final String _text;

        private Addressing(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

