/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.Bundle;
import jmri.jmrit.logixng.util.InUse;
import jmri.jmrit.logixng.util.LogixNG_SelectTable;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNG_SelectComboBox
implements VetoableChangeListener {
    private final AbstractBase _base;
    private final InUse _inUse;
    private String[] _valuesArray;
    private final LogixNG_SelectTable _selectTable;
    private final PropertyChangeListener _listener;
    private boolean _listenToMemory;
    private boolean _listenersAreRegistered;
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private String _value;
    private String _reference = "";
    private NamedBeanHandle<Memory> _memoryHandle;
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private static final Logger log = LoggerFactory.getLogger(LogixNG_SelectComboBox.class);

    public LogixNG_SelectComboBox(AbstractBase base, String[] valuesArray, String initialValue, PropertyChangeListener listener) {
        this._base = base;
        this._inUse = () -> true;
        this._valuesArray = valuesArray;
        this._value = initialValue;
        this._selectTable = new LogixNG_SelectTable(this._base, this._inUse);
        this._listener = listener;
    }

    public void copy(LogixNG_SelectComboBox copy) throws ParserException {
        copy.setAddressing(this._addressing);
        copy.setValue(this._value);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setMemory(this._memoryHandle);
        copy.setListenToMemory(this._listenToMemory);
        copy.setFormula(this._formula);
        this._selectTable.copy(copy._selectTable);
    }

    public void setValues(String[] valuesArray) {
        this._valuesArray = valuesArray;
        boolean found = false;
        for (String value : this._valuesArray) {
            if (!value.equals(this._value)) continue;
            found = true;
        }
        if (!found) {
            this._value = this._valuesArray[0];
        }
    }

    public String[] getValues() {
        return this._valuesArray;
    }

    public void setAddressing(@Nonnull NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public boolean isDirectAddressing() {
        return this._addressing == NamedBeanAddressing.Direct;
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setValue(@Nonnull String value) {
        this._base.assertListenersAreNotRegistered(log, "setString");
        this._value = value;
    }

    public String getValue() {
        return this._value;
    }

    public String getValue(String name) {
        for (String value : this._valuesArray) {
            if (!value.equals(name)) continue;
            return value;
        }
        return null;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setMemory(@Nonnull String memoryName) {
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this._memoryHandle = handle;
        InstanceManager.memoryManagerInstance().addVetoableChangeListener(this);
        this.addRemoveVetoListener();
    }

    public void setMemory(@Nonnull Memory memory) {
        this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeMemory() {
        if (this._memoryHandle != null) {
            this._memoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public LogixNG_SelectTable getSelectTable() {
        return this._selectTable;
    }

    private void addRemoveVetoListener() {
        if (this._memoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    public String evaluateValue(ConditionalNG conditionalNG) throws JmriException {
        String name;
        if (this._addressing == NamedBeanAddressing.Direct) {
            return this._value;
        }
        switch (this._addressing) {
            case Reference: {
                name = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._reference);
                break;
            }
            case Memory: {
                name = TypeConversionUtil.convertToString(this._memoryHandle.getBean().getValue(), false);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolNamedBean = conditionalNG.getSymbolTable();
                name = TypeConversionUtil.convertToString(symbolNamedBean.getValue(this._localVariable), false);
                break;
            }
            case Formula: {
                name = this._expressionNode != null ? TypeConversionUtil.convertToString(this._expressionNode.calculate(conditionalNG.getSymbolTable()), false) : null;
                break;
            }
            case Table: {
                name = TypeConversionUtil.convertToString(this._selectTable.evaluateTableData(conditionalNG), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        return this.getValue(name);
    }

    public String getDescription(Locale locale) {
        String description;
        String memoryName = this._memoryHandle != null ? this._memoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._addressing) {
            case Direct: {
                description = Bundle.getMessage(locale, "AddressByDirect", this._value);
                break;
            }
            case Reference: {
                description = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case Memory: {
                description = Bundle.getMessage(locale, "AddressByMemory_Listen", memoryName, Base.getListenString(this._listenToMemory));
                break;
            }
            case LocalVariable: {
                description = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                description = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            case Table: {
                description = Bundle.getMessage(locale, "AddressByTable", this._selectTable.getTableNameDescription(locale), this._selectTable.getTableRowDescription(locale), this._selectTable.getTableColumnDescription(locale));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing: " + this._addressing.name());
            }
        }
        return description;
    }

    public void registerListeners() {
        if (!this._listenersAreRegistered && this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && this._listenToMemory) {
            this._memoryHandle.getBean().addPropertyChangeListener("value", this._listener);
            this._listenersAreRegistered = true;
        }
    }

    public void unregisterListeners() {
        if (this._listenersAreRegistered && this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && this._listenToMemory) {
            this._memoryHandle.getBean().removePropertyChangeListener("value", this._listener);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && this._inUse.isInUse()) {
            if (evt.getOldValue() instanceof Memory) {
                boolean doVeto = false;
                if (this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && evt.getOldValue().equals(this._memoryHandle.getBean())) {
                    doVeto = true;
                }
                if (doVeto) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("MemoryInUseMemoryExpressionVeto", this._base.getDisplayName()), e);
                }
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this._memoryHandle.getBean())) {
            this.removeMemory();
        }
    }
}

