/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.Bundle;
import jmri.jmrit.logixng.util.InUse;
import jmri.jmrit.logixng.util.LogixNG_SelectTable;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNG_SelectEnum<E extends Enum<?>>
implements VetoableChangeListener {
    private final AbstractBase _base;
    private final InUse _inUse;
    private final E[] _enumArray;
    private final LogixNG_SelectTable _selectTable;
    private final PropertyChangeListener _listener;
    private boolean _listenToMemory;
    private boolean _listenersAreRegistered;
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private E _enum;
    private String _reference = "";
    private NamedBeanHandle<Memory> _memoryHandle;
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private static final Logger log = LoggerFactory.getLogger(LogixNG_SelectEnum.class);

    public LogixNG_SelectEnum(AbstractBase base, E[] enumArray, E initialEnum, PropertyChangeListener listener) {
        this._base = base;
        this._inUse = () -> true;
        this._enumArray = enumArray;
        this._enum = initialEnum;
        this._selectTable = new LogixNG_SelectTable(this._base, this._inUse);
        this._listener = listener;
    }

    public void copy(LogixNG_SelectEnum<E> copy) throws ParserException {
        copy.setAddressing(this._addressing);
        copy.setEnum(this._enum);
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setMemory(this._memoryHandle);
        copy.setListenToMemory(this._listenToMemory);
        copy.setFormula(this._formula);
        this._selectTable.copy(copy._selectTable);
    }

    public void setAddressing(@Nonnull NamedBeanAddressing addressing) throws ParserException {
        this._addressing = addressing;
        this.parseFormula();
    }

    public boolean isDirectAddressing() {
        return this._addressing == NamedBeanAddressing.Direct;
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setEnum(@Nonnull E e) {
        this._base.assertListenersAreNotRegistered(log, "setEnum");
        this._enum = e;
    }

    public boolean isEnum(E e) {
        return this._addressing == NamedBeanAddressing.Direct && this._enum == e;
    }

    public E getEnum() {
        return this._enum;
    }

    public E getEnum(String name) {
        for (E e : this._enumArray) {
            if (!((Enum)e).name().equals(name)) continue;
            return e;
        }
        return null;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setMemory(@Nonnull String memoryName) {
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this._memoryHandle = handle;
        InstanceManager.memoryManagerInstance().addVetoableChangeListener(this);
        this.addRemoveVetoListener();
    }

    public void setMemory(@Nonnull Memory memory) {
        this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeMemory() {
        if (this._memoryHandle != null) {
            this._memoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public LogixNG_SelectTable getSelectTable() {
        return this._selectTable;
    }

    private void addRemoveVetoListener() {
        if (this._memoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    public E evaluateEnum(ConditionalNG conditionalNG) throws JmriException {
        String name;
        if (this._addressing == NamedBeanAddressing.Direct) {
            return this._enum;
        }
        switch (this._addressing) {
            case Reference: {
                name = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._reference);
                break;
            }
            case Memory: {
                name = TypeConversionUtil.convertToString(this._memoryHandle.getBean().getValue(), false);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolNamedBean = conditionalNG.getSymbolTable();
                name = TypeConversionUtil.convertToString(symbolNamedBean.getValue(this._localVariable), false);
                break;
            }
            case Formula: {
                name = this._expressionNode != null ? TypeConversionUtil.convertToString(this._expressionNode.calculate(conditionalNG.getSymbolTable()), false) : null;
                break;
            }
            case Table: {
                name = TypeConversionUtil.convertToString(this._selectTable.evaluateTableData(conditionalNG), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        return this.getEnum(name);
    }

    public String getDescription(Locale locale) {
        String enumName;
        String memoryName = this._memoryHandle != null ? this._memoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._addressing) {
            case Direct: {
                enumName = Bundle.getMessage(locale, "AddressByDirect", ((Enum)this._enum).toString());
                break;
            }
            case Reference: {
                enumName = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case Memory: {
                enumName = Bundle.getMessage(locale, "AddressByMemory_Listen", memoryName, Base.getListenString(this._listenToMemory));
                break;
            }
            case LocalVariable: {
                enumName = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                enumName = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            case Table: {
                enumName = Bundle.getMessage(locale, "AddressByTable", this._selectTable.getTableNameDescription(locale), this._selectTable.getTableRowDescription(locale), this._selectTable.getTableColumnDescription(locale));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing: " + this._addressing.name());
            }
        }
        return enumName;
    }

    public void registerListeners() {
        if (!this._listenersAreRegistered && this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && this._listenToMemory) {
            this._memoryHandle.getBean().addPropertyChangeListener("value", this._listener);
            this._listenersAreRegistered = true;
        }
    }

    public void unregisterListeners() {
        if (this._listenersAreRegistered && this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && this._listenToMemory) {
            this._memoryHandle.getBean().removePropertyChangeListener("value", this._listener);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && this._inUse.isInUse()) {
            if (evt.getOldValue() instanceof Memory) {
                boolean doVeto = false;
                if (this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && evt.getOldValue().equals(this._memoryHandle.getBean())) {
                    doVeto = true;
                }
                if (doVeto) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("MemoryInUseMemoryExpressionVeto", this._base.getDisplayName()), e);
                }
            }
        } else if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this._memoryHandle.getBean())) {
            this.removeMemory();
        }
    }
}

