/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.Bundle;
import jmri.jmrit.logixng.util.InUse;
import jmri.jmrit.logixng.util.LogixNG_SelectTable;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNG_SelectNamedBean<E extends NamedBean>
implements VetoableChangeListener {
    private final AbstractBase _base;
    private final InUse _inUse;
    private final Class<E> _class;
    private final Manager<E> _manager;
    private final LogixNG_SelectTable _selectTable;
    private final PropertyChangeListener _listener;
    private boolean _listenToMemory;
    private boolean _listenersAreRegistered;
    private boolean _onlyDirectAddressingAllowed;
    private NamedBeanAddressing _addressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<E> _handle;
    private String _reference = "";
    private NamedBeanHandle<Memory> _memoryHandle;
    private String _localVariable = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private String _delayedNamedBean;
    private static final Logger log = LoggerFactory.getLogger(LogixNG_SelectNamedBean.class);

    public LogixNG_SelectNamedBean(AbstractBase base, Class<E> clazz, Manager<E> manager, PropertyChangeListener listener) {
        this._base = base;
        this._inUse = () -> true;
        this._class = clazz;
        this._manager = manager;
        this._selectTable = new LogixNG_SelectTable(this._base, this._inUse);
        this._listener = listener;
    }

    public LogixNG_SelectNamedBean(AbstractBase base, Class<E> clazz, Manager<E> manager, InUse inUse, PropertyChangeListener listener) {
        this._base = base;
        this._inUse = inUse;
        this._class = clazz;
        this._manager = manager;
        this._selectTable = new LogixNG_SelectTable(this._base, this._inUse);
        this._listener = listener;
    }

    public void setOnlyDirectAddressingAllowed() {
        this._onlyDirectAddressingAllowed = true;
    }

    public boolean getOnlyDirectAddressingAllowed() {
        return this._onlyDirectAddressingAllowed;
    }

    public void copy(LogixNG_SelectNamedBean<E> copy) throws ParserException {
        copy.setAddressing(this._addressing);
        if (this._handle != null) {
            copy.setNamedBean(this._handle);
        }
        copy.setLocalVariable(this._localVariable);
        copy.setReference(this._reference);
        copy.setMemory(this._memoryHandle);
        copy.setListenToMemory(this._listenToMemory);
        copy.setFormula(this._formula);
        this._selectTable.copy(copy._selectTable);
    }

    public Manager<E> getManager() {
        return this._manager;
    }

    public void setAddressing(@Nonnull NamedBeanAddressing addressing) throws ParserException {
        if (this._onlyDirectAddressingAllowed && addressing != NamedBeanAddressing.Direct) {
            throw new IllegalArgumentException("Addressing must be Direct");
        }
        this._addressing = addressing;
        this.parseFormula();
    }

    public boolean isDirectAddressing() {
        return this._addressing == NamedBeanAddressing.Direct;
    }

    public NamedBeanAddressing getAddressing() {
        return this._addressing;
    }

    public void setDelayedNamedBean(@Nonnull String name) {
        this._delayedNamedBean = name;
    }

    public void setup() {
        if (this._delayedNamedBean != null) {
            this.setNamedBean(this._delayedNamedBean);
        }
    }

    public void setNamedBean(@Nonnull String name) {
        this._base.assertListenersAreNotRegistered(log, "setNamedBean");
        E namedBean = this._manager.getNamedBean(name);
        if (namedBean != null) {
            this.setNamedBean(name, namedBean);
        } else {
            this.removeNamedBean();
            log.error("{} \"{}\" is not found", (Object)this._manager.getBeanTypeHandled(), (Object)name);
        }
    }

    public void setNamedBean(@Nonnull NamedBeanHandle<E> handle) {
        this._base.assertListenersAreNotRegistered(log, "setNamedBean");
        this._handle = handle;
        this._manager.addVetoableChangeListener(this);
    }

    public void setNamedBean(@Nonnull E namedBean) {
        this.setNamedBean(namedBean.getDisplayName(), namedBean);
    }

    public void setNamedBean(@Nonnull String name, @Nonnull E namedBean) {
        this._base.assertListenersAreNotRegistered(log, "setNamedBean");
        this.setNamedBean((E)InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, namedBean));
    }

    public void removeNamedBean() {
        this._base.assertListenersAreNotRegistered(log, "setNamedBean");
        if (this._handle != null) {
            this._manager.removeVetoableChangeListener(this);
            this._handle = null;
        }
    }

    public E getBean() {
        if (this._handle != null) {
            return this._handle.getBean();
        }
        return null;
    }

    public NamedBeanHandle<E> getNamedBean() {
        return this._handle;
    }

    public E getNamedBeanIfDirectAddressing() {
        if (this._handle != null && this._addressing == NamedBeanAddressing.Direct) {
            return this._handle.getBean();
        }
        return null;
    }

    public void setReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setMemory(@Nonnull String memoryName) {
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setMemory(memory);
        } else {
            this.removeMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this._memoryHandle = handle;
        InstanceManager.memoryManagerInstance().addVetoableChangeListener(this);
        this.addRemoveVetoListener();
    }

    public void setMemory(@Nonnull Memory memory) {
        this.setMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeMemory() {
        if (this._memoryHandle != null) {
            this._memoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getMemory() {
        return this._memoryHandle;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setLocalVariable(@Nonnull String localVariable) {
        this._localVariable = localVariable;
    }

    public String getLocalVariable() {
        return this._localVariable;
    }

    public void setFormula(@Nonnull String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._addressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public LogixNG_SelectTable getSelectTable() {
        return this._selectTable;
    }

    private void addRemoveVetoListener() {
        if (this._memoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    public E evaluateNamedBean(ConditionalNG conditionalNG) throws JmriException {
        String name;
        if (this._addressing == NamedBeanAddressing.Direct) {
            return this._handle != null ? (E)this._handle.getBean() : null;
        }
        switch (this._addressing) {
            case Reference: {
                name = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._reference);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolNamedBean = conditionalNG.getSymbolTable();
                name = TypeConversionUtil.convertToString(symbolNamedBean.getValue(this._localVariable), false);
                break;
            }
            case Memory: {
                name = TypeConversionUtil.convertToString(this._memoryHandle.getBean().getValue(), false);
                break;
            }
            case Formula: {
                name = this._expressionNode != null ? TypeConversionUtil.convertToString(this._expressionNode.calculate(conditionalNG.getSymbolTable()), false) : null;
                break;
            }
            case Table: {
                name = TypeConversionUtil.convertToString(this._selectTable.evaluateTableData(conditionalNG), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._addressing.name());
            }
        }
        E namedBean = null;
        if (name != null) {
            namedBean = this._manager.getNamedBean(name);
        }
        return namedBean;
    }

    public String getDescription(Locale locale) {
        String namedBean;
        String memoryName = this._memoryHandle != null ? this._memoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._addressing) {
            case Direct: {
                String namedBeanName = this._handle != null ? this._handle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", namedBeanName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._reference);
                break;
            }
            case Memory: {
                namedBean = Bundle.getMessage(locale, "AddressByMemory_Listen", memoryName, Base.getListenString(this._listenToMemory));
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._localVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._formula);
                break;
            }
            case Table: {
                namedBean = Bundle.getMessage(locale, "AddressByTable", this._selectTable.getTableNameDescription(locale), this._selectTable.getTableRowDescription(locale), this._selectTable.getTableColumnDescription(locale));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing: " + this._addressing.name());
            }
        }
        return namedBean;
    }

    public void registerListeners() {
        if (!this._listenersAreRegistered && this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && this._listenToMemory) {
            this._memoryHandle.getBean().addPropertyChangeListener("value", this._listener);
            this._listenersAreRegistered = true;
        }
    }

    public void unregisterListeners() {
        if (this._listenersAreRegistered && this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && this._listenToMemory) {
            this._memoryHandle.getBean().removePropertyChangeListener("value", this._listener);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && this._inUse.isInUse()) {
            if (this._inUse.isInUse() && this._class.isAssignableFrom(evt.getOldValue().getClass()) && evt.getOldValue().equals(this.getNamedBean().getBean())) {
                PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                throw new PropertyVetoException(Bundle.getMessage("InUseVeto", this._base.getDisplayName(), this._base.getShortDescription()), e);
            }
            if (evt.getOldValue() instanceof Memory) {
                boolean doVeto = false;
                if (this._addressing == NamedBeanAddressing.Memory && this._memoryHandle != null && evt.getOldValue().equals(this._memoryHandle.getBean())) {
                    doVeto = true;
                }
                if (doVeto) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("MemoryInUseMemoryExpressionVeto", this._base.getDisplayName()), e);
                }
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            if (this._class.isAssignableFrom(evt.getOldValue().getClass()) && evt.getOldValue().equals(this.getNamedBean().getBean())) {
                this.removeNamedBean();
            }
            if (evt.getOldValue() instanceof Memory && this._memoryHandle != null && evt.getOldValue().equals(this._memoryHandle.getBean())) {
                this.removeMemory();
            }
        }
    }

    public void addPropertyChangeListener(@CheckForNull PropertyChangeListener listener) {
        if (this._addressing == NamedBeanAddressing.Direct && this._handle != null) {
            this._handle.getBean().addPropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(@CheckForNull String propertyName, @CheckForNull PropertyChangeListener listener) {
        if (this._addressing == NamedBeanAddressing.Direct && this._handle != null) {
            this._handle.getBean().addPropertyChangeListener(propertyName, listener);
        }
    }

    public void removePropertyChangeListener(@CheckForNull PropertyChangeListener listener) {
        if (this._handle != null) {
            this._handle.getBean().removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(@CheckForNull String propertyName, @CheckForNull PropertyChangeListener listener) {
        if (this._handle != null) {
            this._handle.getBean().removePropertyChangeListener(propertyName, listener);
        }
    }

    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl, Base base, Type type) {
        log.debug("getUsageReport :: {}: bean = {}, report = {}", new Object[]{base.getShortDescription(), cdl, report});
        if (this._handle != null && bean.equals(this._handle.getBean())) {
            report.add(new NamedBeanUsageReport(type.toString(), cdl, base.getLongDescription()));
        }
    }

    public static enum Type {
        Action("LogixNGAction"),
        Expression("LogixNGExpression");

        private final String _descr;

        private Type(String descr) {
            this._descr = descr;
        }

        public String toString() {
            return this._descr;
        }
    }
}

