/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.Bundle;
import jmri.jmrit.logixng.util.InUse;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNG_SelectTable
implements VetoableChangeListener {
    private final AbstractBase _base;
    private final InUse _inUse;
    private NamedBeanAddressing _tableNameAddressing = NamedBeanAddressing.Direct;
    private NamedBeanHandle<NamedTable> _tableHandle;
    private String _tableNameReference = "";
    private NamedBeanHandle<Memory> _tableNameMemoryHandle;
    private String _tableNameLocalVariable = "";
    private String _tableNameFormula = "";
    private ExpressionNode _tableNameExpressionNode;
    private LogixNG_SelectTable _tableNameSelectTable;
    private NamedBeanAddressing _tableRowAddressing = NamedBeanAddressing.Direct;
    private String _tableRowName = "";
    private String _tableRowReference = "";
    private NamedBeanHandle<Memory> _tableRowMemoryHandle;
    private String _tableRowLocalVariable = "";
    private String _tableRowFormula = "";
    private ExpressionNode _tableRowExpressionNode;
    private LogixNG_SelectTable _tableRowSelectTable;
    private NamedBeanAddressing _tableColumnAddressing = NamedBeanAddressing.Direct;
    private String _tableColumnName = "";
    private String _tableColumnReference = "";
    private NamedBeanHandle<Memory> _tableColumnMemoryHandle;
    private String _tableColumnLocalVariable = "";
    private String _tableColumnFormula = "";
    private ExpressionNode _tableColumnExpressionNode;
    private LogixNG_SelectTable _tableColumnSelectTable;
    private static final Logger log = LoggerFactory.getLogger(LogixNG_SelectTable.class);

    public LogixNG_SelectTable(AbstractBase base, InUse inUse) {
        this._base = base;
        this._inUse = inUse;
    }

    public void copy(LogixNG_SelectTable copy) throws ParserException {
        copy.setTableNameAddressing(this._tableNameAddressing);
        if (this._tableHandle != null) {
            copy.setTable(this._tableHandle);
        }
        copy.setTableNameLocalVariable(this._tableNameLocalVariable);
        copy.setTableNameReference(this._tableNameReference);
        copy.setTableNameMemory(this._tableNameMemoryHandle);
        copy.setTableNameFormula(this._tableNameFormula);
        if (this._tableNameSelectTable != null) {
            this._tableNameSelectTable.copy(copy._tableNameSelectTable);
        }
        copy.setTableRowAddressing(this._tableRowAddressing);
        copy.setTableRowName(this._tableRowName);
        copy.setTableRowLocalVariable(this._tableRowLocalVariable);
        copy.setTableRowReference(this._tableRowReference);
        copy.setTableRowMemory(this._tableRowMemoryHandle);
        copy.setTableRowFormula(this._tableRowFormula);
        if (this._tableRowSelectTable != null) {
            this._tableRowSelectTable.copy(copy._tableRowSelectTable);
        }
        copy.setTableColumnAddressing(this._tableColumnAddressing);
        copy.setTableColumnName(this._tableColumnName);
        copy.setTableColumnLocalVariable(this._tableColumnLocalVariable);
        copy.setTableColumnReference(this._tableColumnReference);
        copy.setTableColumnMemory(this._tableColumnMemoryHandle);
        copy.setTableColumnFormula(this._tableColumnFormula);
        if (this._tableColumnSelectTable != null) {
            this._tableColumnSelectTable.copy(copy._tableColumnSelectTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableNameAddressing(@Nonnull NamedBeanAddressing addressing) {
        this._tableNameAddressing = addressing;
        LogixNG_SelectTable logixNG_SelectTable = this;
        synchronized (logixNG_SelectTable) {
            if (this._tableNameAddressing == NamedBeanAddressing.Table && this._tableNameSelectTable == null) {
                this._tableNameSelectTable = new LogixNG_SelectTable(this._base, this._inUse);
            }
        }
    }

    public NamedBeanAddressing getTableNameAddressing() {
        return this._tableNameAddressing;
    }

    public void setTable(@Nonnull NamedBeanHandle<NamedTable> handle) {
        this._base.assertListenersAreNotRegistered(log, "setTable");
        this._tableHandle = handle;
        InstanceManager.getDefault(NamedTableManager.class).addVetoableChangeListener(this);
    }

    public void setTable(@Nonnull NamedTable table) {
        this._base.assertListenersAreNotRegistered(log, "setTable");
        this.setTable(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(table.getDisplayName(), table));
    }

    public void removeTable() {
        this._base.assertListenersAreNotRegistered(log, "setTable");
        if (this._tableHandle != null) {
            InstanceManager.getDefault(NamedTableManager.class).removeVetoableChangeListener(this);
            this._tableHandle = null;
        }
    }

    public NamedBeanHandle<NamedTable> getTable() {
        return this._tableHandle;
    }

    public void setTableNameReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._tableNameReference = reference;
    }

    public String getTableNameReference() {
        return this._tableNameReference;
    }

    public void setTableNameMemory(@Nonnull String memoryName) {
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setTableNameMemory(memory);
        } else {
            this.removeTableNameMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setTableNameMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this._tableNameMemoryHandle = handle;
        this.addRemoveVetoListener();
    }

    public void setTableNameMemory(@Nonnull Memory memory) {
        this.setTableNameMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeTableNameMemory() {
        if (this._tableNameMemoryHandle != null) {
            this._tableNameMemoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getTableNameMemory() {
        return this._tableNameMemoryHandle;
    }

    public void setTableNameLocalVariable(@Nonnull String localVariable) {
        this._tableNameLocalVariable = localVariable;
    }

    public String getTableNameLocalVariable() {
        return this._tableNameLocalVariable;
    }

    public void setTableNameFormula(@Nonnull String formula) throws ParserException {
        this._tableNameFormula = formula;
        this.parseTableNameFormula();
    }

    public String getTableNameFormula() {
        return this._tableNameFormula;
    }

    private void parseTableNameFormula() throws ParserException {
        if (this._tableNameAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._tableNameExpressionNode = parser.parseExpression(this._tableNameFormula);
        } else {
            this._tableNameExpressionNode = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogixNG_SelectTable getSelectTableName() {
        LogixNG_SelectTable logixNG_SelectTable = this;
        synchronized (logixNG_SelectTable) {
            if (this._tableNameSelectTable == null) {
                this._tableNameSelectTable = new LogixNG_SelectTable(this._base, this._inUse);
            }
        }
        return this._tableNameSelectTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableRowAddressing(@Nonnull NamedBeanAddressing addressing) {
        this._tableRowAddressing = addressing;
        LogixNG_SelectTable logixNG_SelectTable = this;
        synchronized (logixNG_SelectTable) {
            if (this._tableRowAddressing == NamedBeanAddressing.Table && this._tableRowSelectTable == null) {
                this._tableRowSelectTable = new LogixNG_SelectTable(this._base, this._inUse);
            }
        }
    }

    public NamedBeanAddressing getTableRowAddressing() {
        return this._tableRowAddressing;
    }

    public String getTableRowName() {
        return this._tableRowName;
    }

    public void setTableRowName(@Nonnull String rowName) {
        this._tableRowName = rowName;
    }

    public void setTableRowReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._tableRowReference = reference;
    }

    public String getTableRowReference() {
        return this._tableRowReference;
    }

    public void setTableRowMemory(@Nonnull String memoryName) {
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setTableRowMemory(memory);
        } else {
            this.removeTableRowMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setTableRowMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this._tableRowMemoryHandle = handle;
        this.addRemoveVetoListener();
    }

    public void setTableRowMemory(@Nonnull Memory memory) {
        this.setTableRowMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeTableRowMemory() {
        if (this._tableRowMemoryHandle != null) {
            this._tableRowMemoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getTableRowMemory() {
        return this._tableRowMemoryHandle;
    }

    public void setTableRowLocalVariable(@Nonnull String localVariable) {
        this._tableRowLocalVariable = localVariable;
    }

    public String getTableRowLocalVariable() {
        return this._tableRowLocalVariable;
    }

    public void setTableRowFormula(@Nonnull String formula) throws ParserException {
        this._tableRowFormula = formula;
        this.parseTableRowFormula();
    }

    public String getTableRowFormula() {
        return this._tableRowFormula;
    }

    private void parseTableRowFormula() throws ParserException {
        if (this._tableRowAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._tableRowExpressionNode = parser.parseExpression(this._tableRowFormula);
        } else {
            this._tableRowExpressionNode = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogixNG_SelectTable getSelectTableRow() {
        LogixNG_SelectTable logixNG_SelectTable = this;
        synchronized (logixNG_SelectTable) {
            if (this._tableRowSelectTable == null) {
                this._tableRowSelectTable = new LogixNG_SelectTable(this._base, this._inUse);
            }
        }
        return this._tableRowSelectTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableColumnAddressing(@Nonnull NamedBeanAddressing addressing) {
        this._tableColumnAddressing = addressing;
        LogixNG_SelectTable logixNG_SelectTable = this;
        synchronized (logixNG_SelectTable) {
            if (this._tableColumnAddressing == NamedBeanAddressing.Table && this._tableColumnSelectTable == null) {
                this._tableColumnSelectTable = new LogixNG_SelectTable(this._base, this._inUse);
            }
        }
    }

    public NamedBeanAddressing getTableColumnAddressing() {
        return this._tableColumnAddressing;
    }

    public void setTableColumnReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._tableColumnReference = reference;
    }

    public String getTableColumnReference() {
        return this._tableColumnReference;
    }

    public void setTableColumnMemory(@Nonnull String memoryName) {
        Memory memory = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName);
        if (memory != null) {
            this.setTableColumnMemory(memory);
        } else {
            this.removeTableColumnMemory();
            log.warn("memory \"{}\" is not found", (Object)memoryName);
        }
    }

    public void setTableColumnMemory(@Nonnull NamedBeanHandle<Memory> handle) {
        this._tableColumnMemoryHandle = handle;
        this.addRemoveVetoListener();
    }

    public void setTableColumnMemory(@Nonnull Memory memory) {
        this.setTableColumnMemory(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory));
    }

    public void removeTableColumnMemory() {
        if (this._tableColumnMemoryHandle != null) {
            this._tableColumnMemoryHandle = null;
            this.addRemoveVetoListener();
        }
    }

    public NamedBeanHandle<Memory> getTableColumnMemory() {
        return this._tableColumnMemoryHandle;
    }

    public void setTableColumnLocalVariable(@Nonnull String localVariable) {
        this._tableColumnLocalVariable = localVariable;
    }

    public String getTableColumnLocalVariable() {
        return this._tableColumnLocalVariable;
    }

    public void setTableColumnFormula(@Nonnull String formula) throws ParserException {
        this._tableColumnFormula = formula;
        this.parseTableColumnFormula();
    }

    public String getTableColumnFormula() {
        return this._tableColumnFormula;
    }

    private void parseTableColumnFormula() throws ParserException {
        if (this._tableColumnAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._tableColumnExpressionNode = parser.parseExpression(this._tableColumnFormula);
        } else {
            this._tableColumnExpressionNode = null;
        }
    }

    public String getTableColumnName() {
        return this._tableColumnName;
    }

    public void setTableColumnName(@Nonnull String columnName) {
        this._tableColumnName = columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogixNG_SelectTable getSelectTableColumn() {
        LogixNG_SelectTable logixNG_SelectTable = this;
        synchronized (logixNG_SelectTable) {
            if (this._tableColumnSelectTable == null) {
                this._tableColumnSelectTable = new LogixNG_SelectTable(this._base, this._inUse);
            }
        }
        return this._tableColumnSelectTable;
    }

    private void addRemoveVetoListener() {
        if (this._tableNameMemoryHandle != null || this._tableRowMemoryHandle != null || this._tableColumnMemoryHandle != null) {
            InstanceManager.getDefault(MemoryManager.class).addVetoableChangeListener(this);
        } else {
            InstanceManager.getDefault(MemoryManager.class).removeVetoableChangeListener(this);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && this._inUse.isInUse()) {
            if (evt.getOldValue() instanceof NamedTable && evt.getOldValue().equals(this.getTable().getBean())) {
                throw new PropertyVetoException(this._base.getDisplayName(), evt);
            }
            if (evt.getOldValue() instanceof Memory) {
                boolean doVeto = false;
                if (this._tableNameAddressing == NamedBeanAddressing.Memory && this._tableNameMemoryHandle != null && evt.getOldValue().equals(this._tableNameMemoryHandle.getBean())) {
                    doVeto = true;
                }
                if (this._tableRowAddressing == NamedBeanAddressing.Memory && this._tableRowMemoryHandle != null && evt.getOldValue().equals(this._tableRowMemoryHandle.getBean())) {
                    doVeto = true;
                }
                if (this._tableColumnAddressing == NamedBeanAddressing.Memory && this._tableColumnMemoryHandle != null && evt.getOldValue().equals(this._tableColumnMemoryHandle.getBean())) {
                    doVeto = true;
                }
                if (doVeto) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("MemoryInUseMemoryExpressionVeto", this._base.getDisplayName()), e);
                }
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof NamedTable && evt.getOldValue().equals(this.getTable().getBean())) {
                this.removeTable();
            }
            if (evt.getOldValue() instanceof Memory) {
                if (evt.getOldValue().equals(this._tableNameMemoryHandle.getBean())) {
                    this.removeTableNameMemory();
                }
                if (evt.getOldValue().equals(this._tableRowMemoryHandle.getBean())) {
                    this.removeTableRowMemory();
                }
                if (evt.getOldValue().equals(this._tableColumnMemoryHandle.getBean())) {
                    this.removeTableColumnMemory();
                }
            }
        }
    }

    private NamedTable evaluateTableBean(ConditionalNG conditionalNG) throws JmriException {
        String name;
        if (this._tableNameAddressing == NamedBeanAddressing.Direct) {
            return this._tableHandle != null ? this._tableHandle.getBean() : null;
        }
        switch (this._tableNameAddressing) {
            case Reference: {
                name = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._tableNameReference);
                break;
            }
            case Memory: {
                name = TypeConversionUtil.convertToString(this._tableNameMemoryHandle.getBean().getValue(), false);
                break;
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                name = TypeConversionUtil.convertToString(symbolTable.getValue(this._tableNameLocalVariable), false);
                break;
            }
            case Formula: {
                name = this._tableNameExpressionNode != null ? TypeConversionUtil.convertToString(this._tableNameExpressionNode.calculate(conditionalNG.getSymbolTable()), false) : null;
                break;
            }
            case Table: {
                name = TypeConversionUtil.convertToString(this._tableNameSelectTable.evaluateTableData(conditionalNG), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._tableNameAddressing.name());
            }
        }
        NamedTable table = null;
        if (name != null) {
            table = (NamedTable)InstanceManager.getDefault(NamedTableManager.class).getNamedBean(name);
        }
        return table;
    }

    private String evaluateTableRow(ConditionalNG conditionalNG) throws JmriException {
        switch (this._tableRowAddressing) {
            case Direct: {
                return this._tableRowName;
            }
            case Reference: {
                return ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._tableRowReference);
            }
            case Memory: {
                return TypeConversionUtil.convertToString(this._tableRowMemoryHandle.getBean().getValue(), false);
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._tableRowLocalVariable), false);
            }
            case Formula: {
                return this._tableRowExpressionNode != null ? TypeConversionUtil.convertToString(this._tableRowExpressionNode.calculate(conditionalNG.getSymbolTable()), false) : null;
            }
            case Table: {
                return TypeConversionUtil.convertToString(this._tableRowSelectTable.evaluateTableData(conditionalNG), false);
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._tableRowAddressing.name());
    }

    private String evaluateTableColumn(ConditionalNG conditionalNG) throws JmriException {
        switch (this._tableColumnAddressing) {
            case Direct: {
                return this._tableColumnName;
            }
            case Reference: {
                return ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._tableColumnReference);
            }
            case Memory: {
                return TypeConversionUtil.convertToString(this._tableColumnMemoryHandle.getBean().getValue(), false);
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._tableColumnLocalVariable), false);
            }
            case Formula: {
                return this._tableColumnExpressionNode != null ? TypeConversionUtil.convertToString(this._tableColumnExpressionNode.calculate(conditionalNG.getSymbolTable()), false) : null;
            }
            case Table: {
                return TypeConversionUtil.convertToString(this._tableColumnSelectTable.evaluateTableData(conditionalNG), false);
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._tableColumnAddressing.name());
    }

    public Object evaluateTableData(ConditionalNG conditionalNG) throws JmriException {
        return this.evaluateTableBean(conditionalNG).getCell(this.evaluateTableRow(conditionalNG), this.evaluateTableColumn(conditionalNG));
    }

    public void evaluateAndSetTableData(ConditionalNG conditionalNG, Object value) throws JmriException {
        this.evaluateTableBean(conditionalNG).setCell(value, this.evaluateTableRow(conditionalNG), this.evaluateTableColumn(conditionalNG));
    }

    public String getTableNameDescription(Locale locale) {
        String namedBean;
        String memoryName = this._tableNameMemoryHandle != null ? this._tableNameMemoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._tableNameAddressing) {
            case Direct: {
                String tableName = this._tableHandle != null ? this._tableHandle.getBean().getDisplayName() : Bundle.getMessage(locale, "BeanNotSelected");
                namedBean = Bundle.getMessage(locale, "AddressByDirect", tableName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage(locale, "AddressByReference", this._tableNameReference);
                break;
            }
            case Memory: {
                namedBean = Bundle.getMessage(locale, "AddressByMemory", memoryName);
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage(locale, "AddressByLocalVariable", this._tableNameLocalVariable);
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage(locale, "AddressByFormula", this._tableNameFormula);
                break;
            }
            case Table: {
                namedBean = Bundle.getMessage(locale, "AddressByTable", this._tableNameSelectTable.getTableNameDescription(locale), this._tableNameSelectTable.getTableRowDescription(locale), this._tableNameSelectTable.getTableColumnDescription(locale));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _tableNameAddressing: " + this._tableNameAddressing.name());
            }
        }
        return namedBean;
    }

    public String getTableRowDescription(Locale locale) {
        String row;
        String memoryName = this._tableRowMemoryHandle != null ? this._tableRowMemoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._tableRowAddressing) {
            case Direct: {
                row = Bundle.getMessage(locale, "AddressByDirect", this._tableRowName);
                break;
            }
            case Reference: {
                row = Bundle.getMessage(locale, "AddressByReference", this._tableRowReference);
                break;
            }
            case Memory: {
                row = Bundle.getMessage(locale, "AddressByMemory", memoryName);
                break;
            }
            case LocalVariable: {
                row = Bundle.getMessage(locale, "AddressByLocalVariable", this._tableRowLocalVariable);
                break;
            }
            case Formula: {
                row = Bundle.getMessage(locale, "AddressByFormula", this._tableRowFormula);
                break;
            }
            case Table: {
                row = Bundle.getMessage(locale, "AddressByTable", this._tableRowSelectTable.getTableNameDescription(locale), this._tableRowSelectTable.getTableRowDescription(locale), this._tableRowSelectTable.getTableColumnDescription(locale));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _tableRowAddressing: " + this._tableRowAddressing.name());
            }
        }
        return row;
    }

    public String getTableColumnDescription(Locale locale) {
        String column;
        String memoryName = this._tableColumnMemoryHandle != null ? this._tableColumnMemoryHandle.getName() : Bundle.getMessage(locale, "BeanNotSelected");
        switch (this._tableColumnAddressing) {
            case Direct: {
                column = Bundle.getMessage(locale, "AddressByDirect", this._tableColumnName);
                break;
            }
            case Reference: {
                column = Bundle.getMessage(locale, "AddressByReference", this._tableColumnReference);
                break;
            }
            case Memory: {
                column = Bundle.getMessage(locale, "AddressByMemory", memoryName);
                break;
            }
            case LocalVariable: {
                column = Bundle.getMessage(locale, "AddressByLocalVariable", this._tableColumnLocalVariable);
                break;
            }
            case Formula: {
                column = Bundle.getMessage(locale, "AddressByFormula", this._tableColumnFormula);
                break;
            }
            case Table: {
                column = Bundle.getMessage(locale, "AddressByTable", this._tableColumnSelectTable.getTableNameDescription(locale), this._tableColumnSelectTable.getTableRowDescription(locale), this._tableColumnSelectTable.getTableColumnDescription(locale));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _tableRowAddressing: " + this._tableColumnAddressing.name());
            }
        }
        return column;
    }
}

