/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util;

import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Reference;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.ModuleManager;
import jmri.jmrit.logixng.util.Bundle;

public class WhereUsed {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String PAD = "   ";

    private WhereUsed() {
    }

    public static String whereUsed(NamedBean bean) {
        Reference ref = new Reference();
        InstanceManager.getDefault(LogixNG_Manager.class).getNamedBeanSet().forEach(logixNG -> {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < logixNG.getNumConditionalNGs(); ++i) {
                ConditionalNG conditionalNG = logixNG.getConditionalNG(i);
                String s = WhereUsed.checkFemaleSocket(conditionalNG.getFemaleSocket(), bean, conditionalNG, "      ");
                if (s == null) continue;
                sb.append(PAD);
                sb.append(conditionalNG.getLongDescription());
                sb.append(NEW_LINE);
                sb.append(s);
            }
            if (sb.length() > 0) {
                String str = logixNG.getLongDescription() + NEW_LINE + sb.toString() + NEW_LINE;
                if (ref.get() != null) {
                    ref.set((String)ref.get() + str);
                } else {
                    ref.set(str);
                }
            }
        });
        InstanceManager.getDefault(ModuleManager.class).getNamedBeanSet().forEach(module -> {
            String s = WhereUsed.checkFemaleSocket(module.getRootSocket(), bean, null, PAD);
            if (s != null) {
                String str = module.getLongDescription() + NEW_LINE + s + NEW_LINE;
                if (ref.get() != null) {
                    ref.set((String)ref.get() + str);
                } else {
                    ref.set(str);
                }
            }
        });
        Object result = (String)ref.get();
        String s = WhereUsed.checkFemaleSocket(InstanceManager.getDefault(LogixNG_Manager.class).getClipboard().getFemaleSocket(), bean, null, PAD);
        if (s != null) {
            String str = Bundle.getMessage("Clipboard") + NEW_LINE + s;
            result = result != null ? (String)result + str : str;
        }
        return result != null ? result : "";
    }

    private static String checkFemaleSocket(FemaleSocket femaleSocket, NamedBean bean, ConditionalNG conditionalNG, String pad) {
        if (!femaleSocket.isConnected()) {
            return null;
        }
        Base b = femaleSocket.getConnectedSocket();
        while (b instanceof MaleSocket) {
            b = b.getObject();
        }
        if (b == null) {
            throw new UnsupportedOperationException("object is null");
        }
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        b.getUsageDetail(0, bean, report, conditionalNG);
        StringBuilder sb = new StringBuilder();
        if (!report.isEmpty()) {
            sb.append((String)pad).append(femaleSocket.getLongDescription()).append(NEW_LINE);
            sb.append((String)pad).append(PAD).append(b.getLongDescription()).append("   <<====").append(NEW_LINE);
            pad = (String)pad + PAD;
        }
        String padding = sb.length() > 0 ? (String)pad + PAD : (String)pad + "      ";
        for (int i = 0; i < b.getChildCount(); ++i) {
            String temp = WhereUsed.checkFemaleSocket(b.getChild(i), bean, conditionalNG, padding);
            if (temp == null) continue;
            if (sb.length() == 0) {
                sb.append((String)pad).append(femaleSocket.getLongDescription()).append(NEW_LINE);
                sb.append((String)pad).append(PAD).append(b.getLongDescription()).append(NEW_LINE);
                pad = (String)pad + PAD;
            }
            sb.append(temp);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }
}

