/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectTableXml;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.jdom2.Content;
import org.jdom2.Element;

public class LogixNG_SelectEnumXml<E extends Enum<?>> {
    public Element store(LogixNG_SelectEnum<E> selectEnum, String tagName) {
        NamedBeanHandle<Memory> memory;
        LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
        Element enumElement = new Element(tagName);
        enumElement.addContent((Content)new Element("addressing").addContent(selectEnum.getAddressing().name()));
        enumElement.addContent((Content)new Element("enum").addContent(((Enum)selectEnum.getEnum()).name()));
        if (selectEnum.getReference() != null && !selectEnum.getReference().isEmpty()) {
            enumElement.addContent((Content)new Element("reference").addContent(selectEnum.getReference()));
        }
        if ((memory = selectEnum.getMemory()) != null) {
            enumElement.addContent((Content)new Element("memory").addContent(memory.getName()));
        }
        enumElement.addContent((Content)new Element("listenToMemory").addContent(selectEnum.getListenToMemory() ? "yes" : "no"));
        if (selectEnum.getLocalVariable() != null && !selectEnum.getLocalVariable().isEmpty()) {
            enumElement.addContent((Content)new Element("localVariable").addContent(selectEnum.getLocalVariable()));
        }
        if (selectEnum.getFormula() != null && !selectEnum.getFormula().isEmpty()) {
            enumElement.addContent((Content)new Element("formula").addContent(selectEnum.getFormula()));
        }
        if (selectEnum.getAddressing() == NamedBeanAddressing.Table) {
            enumElement.addContent((Content)selectTableXml.store(selectEnum.getSelectTable(), "table"));
        }
        return enumElement;
    }

    public void load(Element enumElement, LogixNG_SelectEnum<E> selectEnum) throws JmriConfigureXmlException {
        if (enumElement != null) {
            LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
            try {
                Element listenToMemoryElem;
                Element memoryName;
                Element elem = enumElement.getChild("addressing");
                if (elem != null) {
                    selectEnum.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
                }
                if ((elem = enumElement.getChild("enum")) != null) {
                    selectEnum.setEnum(selectEnum.getEnum(elem.getTextTrim()));
                }
                if ((elem = enumElement.getChild("reference")) != null) {
                    selectEnum.setReference(elem.getTextTrim());
                }
                if ((memoryName = enumElement.getChild("memory")) != null) {
                    Memory m = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName.getTextTrim());
                    if (m != null) {
                        selectEnum.setMemory(m);
                    } else {
                        selectEnum.removeMemory();
                    }
                }
                if ((listenToMemoryElem = enumElement.getChild("listenToMemory")) != null) {
                    selectEnum.setListenToMemory("yes".equals(listenToMemoryElem.getTextTrim()));
                }
                if ((elem = enumElement.getChild("localVariable")) != null) {
                    selectEnum.setLocalVariable(elem.getTextTrim());
                }
                if ((elem = enumElement.getChild("formula")) != null) {
                    selectEnum.setFormula(elem.getTextTrim());
                }
                if (enumElement.getChild("table") != null) {
                    selectTableXml.load(enumElement.getChild("table"), selectEnum.getSelectTable());
                }
            }
            catch (ParserException e) {
                throw new JmriConfigureXmlException(e);
            }
        }
    }

    public void loadLegacy(Element shared, LogixNG_SelectEnum<E> selectEnum, String addressingElementName, String enumElementName, String referenceElementName, String localVariableElementName, String formulaElementName) throws JmriConfigureXmlException {
        Element name = shared.getChild(enumElementName);
        if (name != null) {
            selectEnum.setEnum(selectEnum.getEnum(name.getTextTrim()));
        }
        try {
            Element elem;
            if (addressingElementName != null && (elem = shared.getChild(addressingElementName)) != null) {
                selectEnum.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if (referenceElementName != null && (elem = shared.getChild(referenceElementName)) != null) {
                selectEnum.setReference(elem.getTextTrim());
            }
            if (localVariableElementName != null && (elem = shared.getChild(localVariableElementName)) != null) {
                selectEnum.setLocalVariable(elem.getTextTrim());
            }
            if (formulaElementName != null && (elem = shared.getChild(formulaElementName)) != null) {
                selectEnum.setFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
    }
}

