/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.util.LogixNG_SelectInteger;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectTableXml;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.jdom2.Content;
import org.jdom2.Element;

public class LogixNG_SelectIntegerXml {
    public Element store(LogixNG_SelectInteger selectInt, String tagName) {
        NamedBeanHandle<Memory> memory;
        LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
        Element intElement = new Element(tagName);
        intElement.addContent((Content)new Element("addressing").addContent(selectInt.getAddressing().name()));
        intElement.addContent((Content)new Element("value").addContent(Integer.toString(selectInt.getValue())));
        if (selectInt.getReference() != null && !selectInt.getReference().isEmpty()) {
            intElement.addContent((Content)new Element("reference").addContent(selectInt.getReference()));
        }
        if ((memory = selectInt.getMemory()) != null) {
            intElement.addContent((Content)new Element("memory").addContent(memory.getName()));
        }
        intElement.addContent((Content)new Element("listenToMemory").addContent(selectInt.getListenToMemory() ? "yes" : "no"));
        if (selectInt.getLocalVariable() != null && !selectInt.getLocalVariable().isEmpty()) {
            intElement.addContent((Content)new Element("localVariable").addContent(selectInt.getLocalVariable()));
        }
        if (selectInt.getFormula() != null && !selectInt.getFormula().isEmpty()) {
            intElement.addContent((Content)new Element("formula").addContent(selectInt.getFormula()));
        }
        if (selectInt.getAddressing() == NamedBeanAddressing.Table) {
            intElement.addContent((Content)selectTableXml.store(selectInt.getSelectTable(), "table"));
        }
        return intElement;
    }

    public void load(Element intElement, LogixNG_SelectInteger selectInt) throws JmriConfigureXmlException {
        if (intElement != null) {
            LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
            try {
                Element listenToMemoryElem;
                Element memoryName;
                Element elem = intElement.getChild("addressing");
                if (elem != null) {
                    selectInt.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
                }
                if ((elem = intElement.getChild("value")) != null) {
                    selectInt.setValue(Integer.parseInt(elem.getTextTrim()));
                }
                if ((elem = intElement.getChild("reference")) != null) {
                    selectInt.setReference(elem.getTextTrim());
                }
                if ((memoryName = intElement.getChild("memory")) != null) {
                    Memory m = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName.getTextTrim());
                    if (m != null) {
                        selectInt.setMemory(m);
                    } else {
                        selectInt.removeMemory();
                    }
                }
                if ((listenToMemoryElem = intElement.getChild("listenToMemory")) != null) {
                    selectInt.setListenToMemory("yes".equals(listenToMemoryElem.getTextTrim()));
                }
                if ((elem = intElement.getChild("localVariable")) != null) {
                    selectInt.setLocalVariable(elem.getTextTrim());
                }
                if ((elem = intElement.getChild("formula")) != null) {
                    selectInt.setFormula(elem.getTextTrim());
                }
                if (intElement.getChild("table") != null) {
                    selectTableXml.load(intElement.getChild("table"), selectInt.getSelectTable());
                }
            }
            catch (ParserException e) {
                throw new JmriConfigureXmlException(e);
            }
        }
    }

    public void loadLegacy(Element shared, LogixNG_SelectInteger selectInt, String addressingElementName, String valueElementName, String referenceElementName, String localVariableElementName, String formulaElementName) throws JmriConfigureXmlException {
        Element name = shared.getChild(valueElementName);
        if (name != null) {
            selectInt.setValue(Integer.parseInt(name.getTextTrim()));
        }
        try {
            Element elem = shared.getChild(addressingElementName);
            if (addressingElementName != null && elem != null) {
                selectInt.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            elem = shared.getChild(referenceElementName);
            if (referenceElementName != null && elem != null) {
                selectInt.setReference(elem.getTextTrim());
            }
            elem = shared.getChild(localVariableElementName);
            if (localVariableElementName != null && elem != null) {
                selectInt.setLocalVariable(elem.getTextTrim());
            }
            elem = shared.getChild(formulaElementName);
            if (formulaElementName != null && elem != null) {
                selectInt.setFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
    }
}

