/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectTableXml;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.jdom2.Content;
import org.jdom2.Element;

public class LogixNG_SelectStringXml {
    public Element store(LogixNG_SelectString selectStr, String tagName) {
        NamedBeanHandle<Memory> memory;
        LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
        Element enumElement = new Element(tagName);
        enumElement.addContent((Content)new Element("addressing").addContent(selectStr.getAddressing().name()));
        if (selectStr.getValue() != null) {
            enumElement.addContent((Content)new Element("value").addContent(selectStr.getValue()));
        }
        if (selectStr.getReference() != null && !selectStr.getReference().isEmpty()) {
            enumElement.addContent((Content)new Element("reference").addContent(selectStr.getReference()));
        }
        if ((memory = selectStr.getMemory()) != null) {
            enumElement.addContent((Content)new Element("memory").addContent(memory.getName()));
        }
        enumElement.addContent((Content)new Element("listenToMemory").addContent(selectStr.getListenToMemory() ? "yes" : "no"));
        if (selectStr.getLocalVariable() != null && !selectStr.getLocalVariable().isEmpty()) {
            enumElement.addContent((Content)new Element("localVariable").addContent(selectStr.getLocalVariable()));
        }
        if (selectStr.getFormula() != null && !selectStr.getFormula().isEmpty()) {
            enumElement.addContent((Content)new Element("formula").addContent(selectStr.getFormula()));
        }
        if (selectStr.getAddressing() == NamedBeanAddressing.Table) {
            enumElement.addContent((Content)selectTableXml.store(selectStr.getSelectTable(), "table"));
        }
        return enumElement;
    }

    public void load(Element strElement, LogixNG_SelectString selectStr) throws JmriConfigureXmlException {
        if (strElement != null) {
            LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
            try {
                Element listenToMemoryElem;
                Element memoryName;
                Element elem = strElement.getChild("addressing");
                if (elem != null) {
                    selectStr.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
                }
                if ((elem = strElement.getChild("value")) != null) {
                    selectStr.setValue(elem.getTextTrim());
                }
                if ((elem = strElement.getChild("reference")) != null) {
                    selectStr.setReference(elem.getTextTrim());
                }
                if ((memoryName = strElement.getChild("memory")) != null) {
                    Memory m = InstanceManager.getDefault(MemoryManager.class).getMemory(memoryName.getTextTrim());
                    if (m != null) {
                        selectStr.setMemory(m);
                    } else {
                        selectStr.removeMemory();
                    }
                }
                if ((listenToMemoryElem = strElement.getChild("listenToMemory")) != null) {
                    selectStr.setListenToMemory("yes".equals(listenToMemoryElem.getTextTrim()));
                }
                if ((elem = strElement.getChild("localVariable")) != null) {
                    selectStr.setLocalVariable(elem.getTextTrim());
                }
                if ((elem = strElement.getChild("formula")) != null) {
                    selectStr.setFormula(elem.getTextTrim());
                }
                if (strElement.getChild("table") != null) {
                    selectTableXml.load(strElement.getChild("table"), selectStr.getSelectTable());
                }
            }
            catch (ParserException e) {
                throw new JmriConfigureXmlException(e);
            }
        }
    }

    public void loadLegacy(Element shared, LogixNG_SelectString selectStr, String addressingElementName, String valueElementName, String referenceElementName, String localVariableElementName, String formulaElementName) throws JmriConfigureXmlException {
        Element name = shared.getChild(valueElementName);
        if (name != null) {
            selectStr.setValue(name.getTextTrim());
        }
        try {
            Element elem = shared.getChild(addressingElementName);
            if (elem != null) {
                selectStr.setAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((elem = shared.getChild(referenceElementName)) != null) {
                selectStr.setReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild(localVariableElementName)) != null) {
                selectStr.setLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild(formulaElementName)) != null) {
                selectStr.setFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
    }
}

