/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.Bundle;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.TokenType;
import jmri.util.TypeConversionUtil;

public class ExpressionNodeArithmeticOperator
implements ExpressionNode {
    private final TokenType _tokenType;
    private final ExpressionNode _leftSide;
    private final ExpressionNode _rightSide;

    public ExpressionNodeArithmeticOperator(TokenType tokenType, ExpressionNode leftSide, ExpressionNode rightSide) {
        this._tokenType = tokenType;
        this._leftSide = leftSide;
        this._rightSide = rightSide;
        if (this._rightSide == null) {
            throw new IllegalArgumentException("rightSide must not be null");
        }
        switch (this._tokenType) {
            case ADD: 
            case SUBTRACKT: 
            case BINARY_NOT: {
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case UNSIGNED_SHIFT_RIGHT: {
                if (this._leftSide != null) break;
                throw new IllegalArgumentException("leftSide must not be null for operators *, / and %");
            }
            default: {
                throw new IllegalArgumentException("Unknown arithmetic operator: " + this._tokenType.name());
            }
        }
    }

    private Object add(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left) && TypeConversionUtil.isIntegerNumber(right)) {
            return ((Number)left).longValue() + ((Number)right).longValue();
        }
        if (TypeConversionUtil.isFloatingNumber(left) && TypeConversionUtil.isFloatingNumber(right)) {
            return ((Number)left).doubleValue() + ((Number)right).doubleValue();
        }
        if (TypeConversionUtil.isString(left) && TypeConversionUtil.isString(right)) {
            return (String)left + (String)right;
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotCompatibleOperands", left, right));
    }

    private Object subtract(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() - ((Number)right).longValue();
            }
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() - ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        if (TypeConversionUtil.isFloatingNumber(left)) {
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() - ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", left));
    }

    private Object multiply(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() * ((Number)right).longValue();
            }
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() * ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        if (TypeConversionUtil.isFloatingNumber(left)) {
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() * ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", left));
    }

    private Object divide(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() / ((Number)right).longValue();
            }
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() / ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        if (TypeConversionUtil.isFloatingNumber(left)) {
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() / ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", left));
    }

    private Object modulo(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() % ((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object shiftLeft(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() << (int)((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object shiftRight(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() >> (int)((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object unsignedShiftRight(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() >>> (int)((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        Object left = this._leftSide != null ? this._leftSide.calculate(symbolTable) : null;
        Object right = this._rightSide.calculate(symbolTable);
        if (left == null && (this._tokenType == TokenType.ADD || this._tokenType == TokenType.SUBTRACKT)) {
            left = 0;
        }
        if (left instanceof Boolean) {
            left = (Boolean)left != false ? 1 : 0;
        }
        if (right instanceof Boolean) {
            right = (Boolean)right != false ? 1 : 0;
        }
        if (this._tokenType == TokenType.BINARY_NOT) {
            if (!TypeConversionUtil.isIntegerNumber(right)) {
                return 0;
            }
            return TypeConversionUtil.convertToLong(right) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (this._tokenType == TokenType.ADD) {
            return this.add(left, right);
        }
        if (!TypeConversionUtil.isFloatingNumber(left)) {
            return 0;
        }
        if (!TypeConversionUtil.isFloatingNumber(right)) {
            return 0;
        }
        switch (this._tokenType) {
            case SUBTRACKT: {
                return this.subtract(left, right);
            }
            case MULTIPLY: {
                return this.multiply(left, right);
            }
            case DIVIDE: {
                return this.divide(left, right);
            }
            case MODULO: {
                return this.modulo(left, right);
            }
            case SHIFT_LEFT: {
                return this.shiftLeft(left, right);
            }
            case SHIFT_RIGHT: {
                return this.shiftRight(left, right);
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return this.unsignedShiftRight(left, right);
            }
        }
        throw new CalculateException("Unknown arithmetic operator: " + this._tokenType.name());
    }

    @Override
    public String getDefinitionString() {
        String operStr;
        switch (this._tokenType) {
            case ADD: {
                operStr = "+";
                break;
            }
            case SUBTRACKT: {
                operStr = "-";
                break;
            }
            case BINARY_NOT: {
                operStr = "~";
                break;
            }
            case MULTIPLY: {
                operStr = "*";
                break;
            }
            case DIVIDE: {
                operStr = "/";
                break;
            }
            case MODULO: {
                operStr = "%";
                break;
            }
            case SHIFT_LEFT: {
                operStr = "<<";
                break;
            }
            case SHIFT_RIGHT: {
                operStr = ">>";
                break;
            }
            case UNSIGNED_SHIFT_RIGHT: {
                operStr = ">>>";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown arithmetic operator: " + this._tokenType.name());
            }
        }
        String leftSideString = this._leftSide != null ? "(" + this._leftSide.getDefinitionString() + ")" : "";
        String rightSideString = "(" + this._rightSide.getDefinitionString() + ")";
        return leftSideString + operStr + rightSideString;
    }
}

