/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.lang.reflect.Array;
import java.util.List;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ExpressionNodeWithParameter;
import jmri.jmrit.logixng.util.parser.FunctionNotExistsException;
import jmri.util.TypeConversionUtil;

public class ExpressionNodeArray
implements ExpressionNodeWithParameter {
    private final ExpressionNode _exprNode;

    public ExpressionNodeArray(ExpressionNode exprNode) throws FunctionNotExistsException {
        this._exprNode = exprNode;
    }

    @Override
    public Object calculate(Object parameter, SymbolTable symbolTable) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        int index = (int)TypeConversionUtil.convertToLong(this._exprNode.calculate(symbolTable));
        if (parameter instanceof ArrayNode) {
            return ((ArrayNode)parameter).get(index);
        }
        if (parameter.getClass().isArray()) {
            return Array.get(parameter, index);
        }
        if (parameter instanceof List) {
            return ((List)parameter).get(index);
        }
        throw new IllegalArgumentException("Parameter is not a List nor an array");
    }

    @Override
    public boolean canBeAssigned() {
        return true;
    }

    @Override
    public void assignValue(Object parameter, SymbolTable symbolTable, Object value) throws JmriException {
        int index = (int)TypeConversionUtil.convertToLong(this._exprNode.calculate(symbolTable));
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        if (parameter.getClass().isArray()) {
            Array.set(parameter, index, value);
        } else if (parameter instanceof List) {
            ((List)parameter).set(index, value);
        } else {
            throw new IllegalArgumentException("Parameter is not a List nor an array");
        }
    }

    @Override
    public String getDefinitionString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this._exprNode.getDefinitionString());
        str.append("]");
        return str.toString();
    }
}

