/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.Bundle;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.TokenType;
import jmri.util.TypeConversionUtil;

public class ExpressionNodeAssignmentOperator
implements ExpressionNode {
    private final TokenType _tokenType;
    private final ExpressionNode _leftSide;
    private final ExpressionNode _rightSide;

    public ExpressionNodeAssignmentOperator(TokenType tokenType, ExpressionNode leftSide, ExpressionNode rightSide) {
        this._tokenType = tokenType;
        this._leftSide = leftSide;
        this._rightSide = rightSide;
        if (this._leftSide == null) {
            throw new IllegalArgumentException("leftSide must not be null");
        }
        if (!this._leftSide.canBeAssigned()) {
            throw new IllegalArgumentException("leftSide must assignable");
        }
        switch (this._tokenType) {
            case ASSIGN: 
            case ASSIGN_ADD: 
            case ASSIGN_SUBTRACKT: {
                break;
            }
            case ASSIGN_MULTIPLY: 
            case ASSIGN_DIVIDE: 
            case ASSIGN_MODULO: 
            case ASSIGN_AND: 
            case ASSIGN_OR: 
            case ASSIGN_XOR: 
            case ASSIGN_SHIFT_LEFT: 
            case ASSIGN_SHIFT_RIGHT: 
            case ASSIGN_UNSIGNED_SHIFT_RIGHT: {
                if (this._leftSide != null) break;
                throw new IllegalArgumentException("leftSide must not be null for operators *, /, %, <<, >>, >>>");
            }
            default: {
                throw new IllegalArgumentException("Unknown arithmetic operator: " + this._tokenType.name());
            }
        }
    }

    private Object add(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left) && TypeConversionUtil.isIntegerNumber(right)) {
            return ((Number)left).longValue() + ((Number)right).longValue();
        }
        if (TypeConversionUtil.isFloatingNumber(left) && TypeConversionUtil.isFloatingNumber(right)) {
            return ((Number)left).doubleValue() + ((Number)right).doubleValue();
        }
        if (TypeConversionUtil.isString(left) && TypeConversionUtil.isString(right)) {
            return (String)left + (String)right;
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotCompatibleOperands", left, right));
    }

    private Object subtract(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() - ((Number)right).longValue();
            }
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() - ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        if (TypeConversionUtil.isFloatingNumber(left)) {
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() - ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", left));
    }

    private Object multiply(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() * ((Number)right).longValue();
            }
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() * ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        if (TypeConversionUtil.isFloatingNumber(left)) {
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() * ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", left));
    }

    private Object divide(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() / ((Number)right).longValue();
            }
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() / ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        if (TypeConversionUtil.isFloatingNumber(left)) {
            if (TypeConversionUtil.isFloatingNumber(right)) {
                return ((Number)left).doubleValue() / ((Number)right).doubleValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotNumberError", left));
    }

    private Object modulo(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() % ((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object and(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() & ((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object or(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() | ((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object xor(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() ^ ((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object shiftLeft(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() << (int)((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object shiftRight(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() >> (int)((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    private Object unsignedShiftRight(Object left, Object right) throws CalculateException {
        if (TypeConversionUtil.isIntegerNumber(left)) {
            if (TypeConversionUtil.isIntegerNumber(right)) {
                return ((Number)left).longValue() >>> (int)((Number)right).longValue();
            }
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", right));
        }
        throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", left));
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        Object result;
        if (this._tokenType == TokenType.ASSIGN) {
            Object value = this._rightSide.calculate(symbolTable);
            this._leftSide.assignValue(symbolTable, value);
            return value;
        }
        Object left = this._leftSide.calculate(symbolTable);
        Object right = this._rightSide.calculate(symbolTable);
        if (left instanceof Boolean) {
            left = (Boolean)left != false ? 1 : 0;
        }
        if (right instanceof Boolean) {
            right = (Boolean)right != false ? 1 : 0;
        }
        if (this._tokenType == TokenType.ASSIGN_ADD) {
            result = this.add(left, right);
        } else if (!TypeConversionUtil.isFloatingNumber(left)) {
            result = 0;
        } else if (!TypeConversionUtil.isFloatingNumber(right)) {
            result = 0;
        } else {
            switch (this._tokenType) {
                case ASSIGN_SUBTRACKT: {
                    result = this.subtract(left, right);
                    break;
                }
                case ASSIGN_MULTIPLY: {
                    result = this.multiply(left, right);
                    break;
                }
                case ASSIGN_DIVIDE: {
                    result = this.divide(left, right);
                    break;
                }
                case ASSIGN_MODULO: {
                    result = this.modulo(left, right);
                    break;
                }
                case ASSIGN_AND: {
                    result = this.and(left, right);
                    break;
                }
                case ASSIGN_OR: {
                    result = this.or(left, right);
                    break;
                }
                case ASSIGN_XOR: {
                    result = this.xor(left, right);
                    break;
                }
                case ASSIGN_SHIFT_LEFT: {
                    result = this.shiftLeft(left, right);
                    break;
                }
                case ASSIGN_SHIFT_RIGHT: {
                    result = this.shiftRight(left, right);
                    break;
                }
                case ASSIGN_UNSIGNED_SHIFT_RIGHT: {
                    result = this.unsignedShiftRight(left, right);
                    break;
                }
                default: {
                    throw new CalculateException("Unknown arithmetic operator: " + this._tokenType.name());
                }
            }
        }
        this._leftSide.assignValue(symbolTable, result);
        return result;
    }

    @Override
    public String getDefinitionString() {
        String operStr;
        switch (this._tokenType) {
            case ADD: {
                operStr = "+";
                break;
            }
            case SUBTRACKT: {
                operStr = "-";
                break;
            }
            case MULTIPLY: {
                operStr = "*";
                break;
            }
            case DIVIDE: {
                operStr = "/";
                break;
            }
            case MODULO: {
                operStr = "%";
                break;
            }
            case ASSIGN: {
                operStr = "=";
                break;
            }
            case ASSIGN_ADD: {
                operStr = "+=";
                break;
            }
            case ASSIGN_SUBTRACKT: {
                operStr = "-=";
                break;
            }
            case ASSIGN_MULTIPLY: {
                operStr = "*=";
                break;
            }
            case ASSIGN_DIVIDE: {
                operStr = "/=";
                break;
            }
            case ASSIGN_MODULO: {
                operStr = "%=";
                break;
            }
            case ASSIGN_AND: {
                operStr = "&=";
                break;
            }
            case ASSIGN_OR: {
                operStr = "|=";
                break;
            }
            case ASSIGN_XOR: {
                operStr = "^=";
                break;
            }
            case ASSIGN_SHIFT_LEFT: {
                operStr = "<<=";
                break;
            }
            case ASSIGN_SHIFT_RIGHT: {
                operStr = ">>=";
                break;
            }
            case ASSIGN_UNSIGNED_SHIFT_RIGHT: {
                operStr = ">>>=";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown arithmetic operator: " + this._tokenType.name());
            }
        }
        String leftSideString = this._leftSide != null ? this._leftSide.getDefinitionString() : "null";
        String rightSideString = this._rightSide != null ? this._rightSide.getDefinitionString() : "null";
        return "(" + leftSideString + ")" + operStr + "(" + rightSideString + ")";
    }
}

