/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.Bundle;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.TokenType;
import jmri.util.TypeConversionUtil;

public class ExpressionNodeBinaryOperator
implements ExpressionNode {
    private final TokenType _tokenType;
    private final ExpressionNode _leftSide;
    private final ExpressionNode _rightSide;

    public ExpressionNodeBinaryOperator(TokenType tokenType, ExpressionNode leftSide, ExpressionNode rightSide) {
        this._tokenType = tokenType;
        this._leftSide = leftSide;
        this._rightSide = rightSide;
        if (this._rightSide == null) {
            throw new IllegalArgumentException("rightSide must not be null");
        }
        switch (this._tokenType) {
            case BINARY_OR: 
            case BINARY_XOR: 
            case BINARY_AND: {
                if (this._leftSide != null) break;
                throw new IllegalArgumentException("leftSide must not be null for operators BINARY AND, BINARY OR and BINARY XOR");
            }
            case BINARY_NOT: {
                if (this._leftSide == null) break;
                throw new IllegalArgumentException("leftSide must be null for operator BINARY NOT");
            }
            default: {
                throw new IllegalArgumentException("Unsupported binary operator: " + this._tokenType.name());
            }
        }
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        Object rightValue;
        Object leftValue = null;
        if (this._tokenType != TokenType.BINARY_NOT) {
            leftValue = this._leftSide.calculate(symbolTable);
        }
        if (leftValue == null) {
            leftValue = false;
        }
        if ((rightValue = this._rightSide.calculate(symbolTable)) == null) {
            rightValue = false;
        }
        if (!TypeConversionUtil.isIntegerNumber(rightValue)) {
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", rightValue));
        }
        long right = TypeConversionUtil.convertToLong(rightValue);
        if (this._tokenType == TokenType.BINARY_NOT) {
            return right ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (!TypeConversionUtil.isIntegerNumber(leftValue)) {
            throw new CalculateException(Bundle.getMessage("ArithmeticNotIntegerNumberError", leftValue));
        }
        long left = TypeConversionUtil.convertToLong(leftValue);
        switch (this._tokenType) {
            case BINARY_OR: {
                return left | right;
            }
            case BINARY_XOR: {
                return left ^ right;
            }
            case BINARY_AND: {
                return left & right;
            }
        }
        throw new CalculateException("Unknown binary operator: " + this._tokenType.name());
    }

    @Override
    public String getDefinitionString() {
        String operStr;
        switch (this._tokenType) {
            case BINARY_OR: {
                operStr = "|";
                break;
            }
            case BINARY_XOR: {
                operStr = "^";
                break;
            }
            case BINARY_AND: {
                operStr = "&";
                break;
            }
            case BINARY_NOT: {
                operStr = "~";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown arithmetic operator: " + this._tokenType.name());
            }
        }
        if (this._leftSide != null) {
            return "(" + this._leftSide.getDefinitionString() + ")" + operStr + "(" + this._rightSide.getDefinitionString() + ")";
        }
        return operStr + "(" + this._rightSide.getDefinitionString() + ")";
    }
}

