/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.Bundle;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.TokenType;
import jmri.util.TypeConversionUtil;

public class ExpressionNodeBooleanOperator
implements ExpressionNode {
    private final TokenType _tokenType;
    private final ExpressionNode _leftSide;
    private final ExpressionNode _rightSide;

    public ExpressionNodeBooleanOperator(TokenType tokenType, ExpressionNode leftSide, ExpressionNode rightSide) {
        this._tokenType = tokenType;
        this._leftSide = leftSide;
        this._rightSide = rightSide;
        if (this._rightSide == null) {
            throw new IllegalArgumentException("rightSide must not be null");
        }
        switch (this._tokenType) {
            case BOOLEAN_OR: 
            case BOOLEAN_XOR: 
            case BOOLEAN_AND: {
                if (this._leftSide != null) break;
                throw new IllegalArgumentException("leftSide must not be null for operators AND, OR and XOR");
            }
            case BOOLEAN_NOT: {
                if (this._leftSide == null) break;
                throw new IllegalArgumentException("leftSide must be null for operator NOT");
            }
            default: {
                throw new IllegalArgumentException("Unsupported boolean operator: " + this._tokenType.name());
            }
        }
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        Object rightValue;
        Object leftValue = null;
        if (this._tokenType != TokenType.BOOLEAN_NOT) {
            leftValue = this._leftSide.calculate(symbolTable);
        }
        if (leftValue == null) {
            leftValue = false;
        }
        if ((rightValue = this._rightSide.calculate(symbolTable)) == null) {
            rightValue = false;
        }
        if (!(rightValue instanceof Boolean)) {
            if (TypeConversionUtil.isIntegerNumber(rightValue)) {
                rightValue = ((Number)rightValue).longValue() != 0L;
            } else {
                throw new CalculateException(Bundle.getMessage("ArithmeticNotBooleanOrIntegerNumberError", rightValue));
            }
        }
        boolean right = (Boolean)rightValue;
        if (this._tokenType == TokenType.BOOLEAN_NOT) {
            return !right;
        }
        if (!(leftValue instanceof Boolean)) {
            if (TypeConversionUtil.isIntegerNumber(leftValue)) {
                leftValue = ((Number)leftValue).longValue() != 0L;
            } else {
                throw new CalculateException(Bundle.getMessage("ArithmeticNotBooleanOrIntegerNumberError", leftValue));
            }
        }
        boolean left = (Boolean)leftValue;
        switch (this._tokenType) {
            case BOOLEAN_OR: {
                return left || right;
            }
            case BOOLEAN_XOR: {
                return left && !right || !left && right;
            }
            case BOOLEAN_AND: {
                return left && right;
            }
        }
        throw new CalculateException("Unknown boolean operator: " + this._tokenType.name());
    }

    @Override
    public String getDefinitionString() {
        String operStr;
        switch (this._tokenType) {
            case BOOLEAN_OR: {
                operStr = "||";
                break;
            }
            case BOOLEAN_XOR: {
                operStr = "^^";
                break;
            }
            case BOOLEAN_AND: {
                operStr = "&&";
                break;
            }
            case BOOLEAN_NOT: {
                operStr = "!";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown arithmetic operator: " + this._tokenType.name());
            }
        }
        if (this._leftSide != null) {
            return "(" + this._leftSide.getDefinitionString() + ")" + operStr + "(" + this._rightSide.getDefinitionString() + ")";
        }
        return operStr + "(" + this._rightSide.getDefinitionString() + ")";
    }
}

