/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.util.Map;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.IdentifierNotExistsException;
import jmri.jmrit.logixng.util.parser.LocalVariableExpressionVariable;
import jmri.jmrit.logixng.util.parser.Token;
import jmri.jmrit.logixng.util.parser.Variable;

public class ExpressionNodeIdentifier
implements ExpressionNode {
    private final Token _token;
    private final Variable _variable;

    public ExpressionNodeIdentifier(Token token, Map<String, Variable> variables) throws IdentifierNotExistsException {
        this._token = token;
        Variable variable = variables.get(token.getString());
        if (variable == null) {
            variable = new LocalVariableExpressionVariable(token.getString());
        }
        this._variable = variable;
    }

    public String getIdentifier() {
        return this._token.getString();
    }

    @Override
    public Object calculate(SymbolTable symbolTable) throws JmriException {
        return this._variable.getValue(symbolTable);
    }

    @Override
    public boolean canBeAssigned() {
        return true;
    }

    @Override
    public void assignValue(SymbolTable symbolTable, Object value) throws JmriException {
        if (this._variable != null) {
            this._variable.setValue(symbolTable, value);
        }
    }

    @Override
    public String getDefinitionString() {
        return "Identifier:" + this._token.getString();
    }
}

