/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CannotCallMethodException;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ExpressionNodeWithParameter;
import jmri.jmrit.logixng.util.parser.FunctionNotExistsException;
import jmri.jmrit.logixng.util.parser.ReflectionException;
import jmri.jmrit.logixng.util.parser.Variable;

public class ExpressionNodeMethod
implements ExpressionNodeWithParameter {
    private final String _method;
    private final List<ExpressionNode> _parameterList;

    public ExpressionNodeMethod(String method, Map<String, Variable> variables, List<ExpressionNode> parameterList) throws FunctionNotExistsException {
        this._method = method;
        this._parameterList = parameterList;
    }

    private boolean isAssignableFrom(Class<?> type, Object param) {
        if (param == null) {
            return true;
        }
        if (type.isAssignableFrom(param.getClass())) {
            return true;
        }
        if (type == Boolean.TYPE && param instanceof Boolean) {
            return true;
        }
        if (type == Byte.TYPE && param instanceof Byte) {
            return true;
        }
        if (type == Short.TYPE && param instanceof Byte) {
            return true;
        }
        if (type == Integer.TYPE && param instanceof Byte) {
            return true;
        }
        if (type == Long.TYPE && param instanceof Byte) {
            return true;
        }
        if (type == Float.TYPE && param instanceof Byte) {
            return true;
        }
        if (type == Double.TYPE && param instanceof Byte) {
            return true;
        }
        if (type == Byte.TYPE && param instanceof Short) {
            return true;
        }
        if (type == Short.TYPE && param instanceof Short) {
            return true;
        }
        if (type == Integer.TYPE && param instanceof Short) {
            return true;
        }
        if (type == Long.TYPE && param instanceof Short) {
            return true;
        }
        if (type == Float.TYPE && param instanceof Short) {
            return true;
        }
        if (type == Double.TYPE && param instanceof Short) {
            return true;
        }
        if (type == Byte.TYPE && param instanceof Integer) {
            return true;
        }
        if (type == Short.TYPE && param instanceof Integer) {
            return true;
        }
        if (type == Integer.TYPE && param instanceof Integer) {
            return true;
        }
        if (type == Long.TYPE && param instanceof Integer) {
            return true;
        }
        if (type == Float.TYPE && param instanceof Integer) {
            return true;
        }
        if (type == Double.TYPE && param instanceof Integer) {
            return true;
        }
        if (type == Byte.TYPE && param instanceof Long) {
            return true;
        }
        if (type == Short.TYPE && param instanceof Long) {
            return true;
        }
        if (type == Integer.TYPE && param instanceof Long) {
            return true;
        }
        if (type == Long.TYPE && param instanceof Long) {
            return true;
        }
        if (type == Float.TYPE && param instanceof Long) {
            return true;
        }
        if (type == Double.TYPE && param instanceof Long) {
            return true;
        }
        if (type == Float.TYPE && param instanceof Float) {
            return true;
        }
        if (type == Double.TYPE && param instanceof Float) {
            return true;
        }
        if (type == Float.TYPE && param instanceof Double) {
            return true;
        }
        return type == Double.TYPE && param instanceof Double;
    }

    private boolean canCall(Method m, Object[] params) {
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != params.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (this.isAssignableFrom(paramTypes[i], params[i])) continue;
            return false;
        }
        return true;
    }

    private Object callMethod(Method method, Object obj, Object[] params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ReflectionException {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] newParams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object newParam;
            if (params[i] == null || paramTypes[i].isAssignableFrom(params[i].getClass())) {
                newParam = params[i];
            } else if (paramTypes[i] == Boolean.TYPE && params[i] instanceof Boolean) {
                newParam = params[i];
            } else if (paramTypes[i] == Byte.TYPE && params[i] instanceof Byte) {
                newParam = params[i];
            } else if (paramTypes[i] == Short.TYPE && params[i] instanceof Byte) {
                newParam = (short)((Byte)params[i]).byteValue();
            } else if (paramTypes[i] == Integer.TYPE && params[i] instanceof Byte) {
                newParam = (int)((Byte)params[i]).byteValue();
            } else if (paramTypes[i] == Long.TYPE && params[i] instanceof Byte) {
                newParam = (long)((Byte)params[i]).byteValue();
            } else if (paramTypes[i] == Float.TYPE && params[i] instanceof Byte) {
                newParam = Float.valueOf(((Byte)params[i]).byteValue());
            } else if (paramTypes[i] == Double.TYPE && params[i] instanceof Byte) {
                newParam = (double)((Byte)params[i]).byteValue();
            } else if (paramTypes[i] == Byte.TYPE && params[i] instanceof Short) {
                newParam = (byte)((Short)params[i]).shortValue();
            } else if (paramTypes[i] == Short.TYPE && params[i] instanceof Short) {
                newParam = params[i];
            } else if (paramTypes[i] == Integer.TYPE && params[i] instanceof Short) {
                newParam = (int)((Short)params[i]).shortValue();
            } else if (paramTypes[i] == Long.TYPE && params[i] instanceof Short) {
                newParam = (long)((Short)params[i]).shortValue();
            } else if (paramTypes[i] == Float.TYPE && params[i] instanceof Short) {
                newParam = Float.valueOf(((Short)params[i]).shortValue());
            } else if (paramTypes[i] == Double.TYPE && params[i] instanceof Short) {
                newParam = (double)((Short)params[i]).shortValue();
            } else if (paramTypes[i] == Byte.TYPE && params[i] instanceof Integer) {
                newParam = (byte)((Integer)params[i]).intValue();
            } else if (paramTypes[i] == Short.TYPE && params[i] instanceof Integer) {
                newParam = (short)((Integer)params[i]).intValue();
            } else if (paramTypes[i] == Integer.TYPE && params[i] instanceof Integer) {
                newParam = params[i];
            } else if (paramTypes[i] == Long.TYPE && params[i] instanceof Integer) {
                newParam = (long)((Integer)params[i]).intValue();
            } else if (paramTypes[i] == Float.TYPE && params[i] instanceof Integer) {
                newParam = Float.valueOf(((Integer)params[i]).intValue());
            } else if (paramTypes[i] == Double.TYPE && params[i] instanceof Integer) {
                newParam = (double)((Integer)params[i]).intValue();
            } else if (paramTypes[i] == Byte.TYPE && params[i] instanceof Long) {
                newParam = (byte)((Long)params[i]).longValue();
            } else if (paramTypes[i] == Short.TYPE && params[i] instanceof Long) {
                newParam = (short)((Long)params[i]).longValue();
            } else if (paramTypes[i] == Integer.TYPE && params[i] instanceof Long) {
                newParam = (int)((Long)params[i]).longValue();
            } else if (paramTypes[i] == Long.TYPE && params[i] instanceof Long) {
                newParam = params[i];
            } else if (paramTypes[i] == Float.TYPE && params[i] instanceof Long) {
                newParam = Float.valueOf(((Long)params[i]).longValue());
            } else if (paramTypes[i] == Double.TYPE && params[i] instanceof Long) {
                newParam = (double)((Long)params[i]).longValue();
            } else if (paramTypes[i] == Float.TYPE && params[i] instanceof Float) {
                newParam = params[i];
            } else if (paramTypes[i] == Double.TYPE && params[i] instanceof Float) {
                newParam = (double)((Float)params[i]).floatValue();
            } else if (paramTypes[i] == Float.TYPE && params[i] instanceof Double) {
                newParam = Float.valueOf((float)((Double)params[i]).doubleValue());
            } else if (paramTypes[i] == Double.TYPE && params[i] instanceof Double) {
                newParam = params[i];
            } else {
                throw new RuntimeException(String.format("%s can not be assigned to %s", params[i].getClass().getName(), paramTypes[i].getName()));
            }
            newParams[i] = newParam;
        }
        try {
            return method.invoke(obj, newParams);
        }
        catch (IllegalAccessException ex) {
            if (obj instanceof Map.Entry && newParams.length == 0) {
                switch (method.getName()) {
                    case "toString": {
                        return obj.toString();
                    }
                    case "getKey": {
                        return ((Map.Entry)obj).getKey();
                    }
                    case "getValue": {
                        return ((Map.Entry)obj).getValue();
                    }
                }
            }
            if (!Modifier.isPublic(obj.getClass().getModifiers())) {
                throw new ReflectionException("Can't call methods on object since it's private", ex);
            }
            throw ex;
        }
    }

    @Override
    public Object calculate(Object parameter, SymbolTable symbolTable) throws JmriException {
        if (parameter == null) {
            throw new NullPointerException("Parameter is null");
        }
        Method[] methods = parameter.getClass().getMethods();
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (ExpressionNode exprNode : this._parameterList) {
            parameters.add(exprNode.calculate(symbolTable));
        }
        Object[] params = parameters.toArray();
        Exception exception = null;
        for (Method m : methods) {
            if (!m.getName().equals(this._method)) continue;
            try {
                if (!this.canCall(m, params)) continue;
                return this.callMethod(m, parameter, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw new ReflectionException("Reflection exception", exception);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        for (Object o : params) {
            paramList.add(String.format("%s:%s", o, o != null ? o.getClass().getName() : "null"));
        }
        throw new CannotCallMethodException(String.format("Can not call method %s(%s) on object %s", this._method, String.join((CharSequence)", ", paramList), parameter), this._method);
    }

    @Override
    public String getDefinitionString() {
        StringBuilder str = new StringBuilder();
        str.append("Method:");
        str.append(this._method);
        str.append("(");
        for (int i = 0; i < this._parameterList.size(); ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this._parameterList.get(i).getDefinitionString());
        }
        str.append(")");
        return str.toString();
    }
}

