/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Timebase;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.AbstractFunction;
import jmri.jmrit.logixng.util.parser.functions.Bundle;

public class ClockFunctions
implements FunctionFactory {
    private final Timebase _fastClock = InstanceManager.getDefault(Timebase.class);

    @Override
    public String getModule() {
        return "Clock";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        this.addCurrentTimeMillisFunction(functionClasses);
        this.addSystemClockFunction(functionClasses);
        this.addFastClockFunction(functionClasses);
        this.addFastClockRateFunction(functionClasses);
        this.addFastClockRunningFunction(functionClasses);
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        return new HashSet<Constant>();
    }

    @Override
    public String getConstantDescription() {
        return null;
    }

    private void addCurrentTimeMillisFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "currentTimeMillis", Bundle.getMessage("Clock.currentTimeMillis_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    return System.currentTimeMillis();
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addSystemClockFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "systemClock", Bundle.getMessage("Clock.systemClock_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                Date currentTime = Date.from(Instant.now());
                if (parameterList.isEmpty()) {
                    return currentTime.getHours() * 60 + currentTime.getMinutes();
                }
                if (parameterList.size() == 1) {
                    Object param = parameterList.get(0).calculate(symbolTable);
                    if (param instanceof String) {
                        switch ((String)param) {
                            case "hour": {
                                return currentTime.getHours();
                            }
                            case "min": {
                                return currentTime.getMinutes();
                            }
                            case "sec": {
                                return currentTime.getSeconds();
                            }
                            case "minOfDay": {
                                return currentTime.getHours() * 60 + currentTime.getMinutes();
                            }
                            case "secOfDay": {
                                return (currentTime.getHours() * 60 + currentTime.getMinutes()) * 60 + currentTime.getSeconds();
                            }
                        }
                        throw new CalculateException(Bundle.getMessage("IllegalParameter", 1, param, this.getName()));
                    }
                    throw new CalculateException(Bundle.getMessage("IllegalParameter", 1, param, this.getName()));
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addFastClockFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "fastClock", Bundle.getMessage("Clock.fastClock_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
                Date currentTime = ClockFunctions.this._fastClock.getTime();
                if (parameterList.isEmpty()) {
                    return currentTime.getHours() * 60 + currentTime.getMinutes();
                }
                if (parameterList.size() == 1) {
                    Object param = parameterList.get(0).calculate(symbolTable);
                    if (param instanceof String) {
                        switch ((String)param) {
                            case "hour": {
                                return currentTime.getHours();
                            }
                            case "min": {
                                return currentTime.getMinutes();
                            }
                            case "minOfDay": {
                                return currentTime.getHours() * 60 + currentTime.getMinutes();
                            }
                        }
                        throw new CalculateException(Bundle.getMessage("IllegalParameter", 1, param, this.getName()));
                    }
                    throw new CalculateException(Bundle.getMessage("IllegalParameter", 1, param, this.getName()));
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addFastClockRateFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "fastClockRate", Bundle.getMessage("Clock.fastClockRate_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
                double rate = ClockFunctions.this._fastClock.userGetRate();
                if (parameterList.isEmpty()) {
                    return rate;
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addFastClockRunningFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "isFastClockRunning", Bundle.getMessage("Clock.isFastClockRunning_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
                boolean rate = ClockFunctions.this._fastClock.getRun();
                if (parameterList.isEmpty()) {
                    return rate;
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }
}

