/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.AbstractFunction;
import jmri.jmrit.logixng.util.parser.functions.Bundle;

public class CommonFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "Common";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        this.addLengthFunction(functionClasses);
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        return new HashSet<Constant>();
    }

    @Override
    public String getConstantDescription() {
        return null;
    }

    private void addLengthFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "length", Bundle.getMessage("Common.length_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.size() != 1) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName(), 1));
                }
                Object parameter = parameterList.get(0).calculate(symbolTable);
                if (parameter == null) {
                    throw new NullPointerException("Parameter is null");
                }
                if (parameter instanceof String) {
                    return ((String)parameter).length();
                }
                if (parameter.getClass().isArray()) {
                    return ((Object[])parameter).length;
                }
                if (parameter instanceof Collection) {
                    return ((Collection)parameter).size();
                }
                if (parameter instanceof Map) {
                    return ((Map)parameter).size();
                }
                throw new IllegalArgumentException("Parameter is not a String, Array, List, Set or Map: " + parameter.getClass().getName());
            }
        });
    }
}

