/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.CannotCreateInstanceException;
import jmri.jmrit.logixng.util.parser.ClassIsNotFoundException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.ReflectionException;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.AbstractFunction;
import jmri.jmrit.logixng.util.parser.functions.Bundle;
import jmri.util.TypeConversionUtil;

public class JavaFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "Java";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        this.addNewFunction(functionClasses);
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        HashSet<Constant> constantClasses = new HashSet<Constant>();
        constantClasses.add(new Constant(this.getModule(), "null", null));
        constantClasses.add(new Constant(this.getModule(), "None", null));
        return constantClasses;
    }

    @Override
    public String getConstantDescription() {
        return Bundle.getMessage("Java.ConstantDescriptions");
    }

    private void addNewFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "new", Bundle.getMessage("Java.new_Descr")){

            private boolean isAssignableFrom(Class<?> type, Object param) {
                if (param == null) {
                    return true;
                }
                if (type.isAssignableFrom(param.getClass())) {
                    return true;
                }
                if (type == Byte.TYPE && param instanceof Long) {
                    return true;
                }
                if (type == Short.TYPE && param instanceof Long) {
                    return true;
                }
                if (type == Integer.TYPE && param instanceof Long) {
                    return true;
                }
                return type == Float.TYPE && param instanceof Double;
            }

            private boolean canCall(Constructor<?> constructor, Object[] params) {
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (paramTypes.length != params.length) {
                    return false;
                }
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (this.isAssignableFrom(paramTypes[i], params[i])) continue;
                    return false;
                }
                return true;
            }

            private Object callConstructor(Constructor<?> constructor, Object[] params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
                Class<?>[] paramTypes = constructor.getParameterTypes();
                Object[] newParams = new Object[params.length];
                for (int i = 0; i < params.length; ++i) {
                    Object newParam;
                    if (params[i] == null || paramTypes[i].isAssignableFrom(params[i].getClass())) {
                        newParam = params[i];
                    } else if (paramTypes[i] == Byte.TYPE && params[i] instanceof Long) {
                        newParam = (byte)((Long)params[i]).longValue();
                    } else if (paramTypes[i] == Short.TYPE && params[i] instanceof Long) {
                        newParam = (short)((Long)params[i]).longValue();
                    } else if (paramTypes[i] == Integer.TYPE && params[i] instanceof Long) {
                        newParam = (int)((Long)params[i]).longValue();
                    } else if (paramTypes[i] == Float.TYPE && params[i] instanceof Double) {
                        newParam = Float.valueOf((float)((Double)params[i]).doubleValue());
                    } else {
                        throw new RuntimeException(String.format("%s cannot be assigned to %s", params[i].getClass().getName(), paramTypes[i].getName()));
                    }
                    newParams[i] = newParam;
                }
                return constructor.newInstance(newParams);
            }

            public Object createInstance(String className, List<Object> parameters) throws JmriException, ClassNotFoundException, InstantiationException {
                if (className == null) {
                    throw new NullPointerException("Class name is null");
                }
                Class<?> clazz = Class.forName(className);
                Constructor<?>[] constructors = clazz.getConstructors();
                Object[] params = parameters.toArray();
                Exception exception = null;
                for (Constructor<?> c : constructors) {
                    try {
                        if (!this.canCall(c, params)) continue;
                        return this.callConstructor(c, params);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        exception = ex;
                    }
                }
                if (exception != null) {
                    throw new ReflectionException("Reflection exception", exception);
                }
                ArrayList<String> paramList = new ArrayList<String>();
                for (Object o : params) {
                    paramList.add(String.format("%s:%s", o, o != null ? o.getClass().getName() : "null"));
                }
                throw new CannotCreateInstanceException(String.format("Can not create new instance of class %s with parameters %s", clazz.getName(), String.join((CharSequence)", ", paramList)), clazz.getName());
            }

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName(), 1));
                }
                String className = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 1; i < parameterList.size(); ++i) {
                    list.add(parameterList.get(i).calculate(symbolTable));
                }
                try {
                    return this.createInstance(className, list);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassIsNotFoundException(String.format("The class %s is not found", className), className);
                }
                catch (InstantiationException e) {
                    throw new ReflectionException("Reflection exception", e);
                }
            }
        });
    }
}

