/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jmri.AddressedProgrammerManager;
import jmri.AudioManager;
import jmri.BlockManager;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.LightManager;
import jmri.MemoryManager;
import jmri.PowerManager;
import jmri.ReporterManager;
import jmri.RouteManager;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.ShutDownManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.TransitManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.AbstractFunction;
import jmri.jmrit.logixng.util.parser.functions.Bundle;
import jmri.util.TypeConversionUtil;

public class LayoutFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "Layout";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        this.addTurnoutExistsFunction(functionClasses);
        this.addGetTurnoutStateFunction(functionClasses);
        this.addSetTurnoutStateFunction(functionClasses);
        this.addSensorExistsFunction(functionClasses);
        this.addGetSensorStateFunction(functionClasses);
        this.addSetSensorStateFunction(functionClasses);
        this.addLightExistsFunction(functionClasses);
        this.addGetLightStateFunction(functionClasses);
        this.addSetLightStateFunction(functionClasses);
        this.addSignalHeadExistsFunction(functionClasses);
        this.addGetSignalHeadAppearanceFunction(functionClasses);
        this.addSetSignalHeadAppearanceFunction(functionClasses);
        this.addSignalMastExistsFunction(functionClasses);
        this.addGetSignalMastAspectFunction(functionClasses);
        this.addSetSignalMastAspectFunction(functionClasses);
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        HashSet<Constant> constantClasses = new HashSet<Constant>();
        constantClasses.add(new Constant(this.getModule(), "Unknown", 1));
        constantClasses.add(new Constant(this.getModule(), "Inconsistent", 8));
        constantClasses.add(new Constant(this.getModule(), "Off", 4));
        constantClasses.add(new Constant(this.getModule(), "On", 2));
        constantClasses.add(new Constant(this.getModule(), "Inactive", 4));
        constantClasses.add(new Constant(this.getModule(), "Active", 2));
        constantClasses.add(new Constant(this.getModule(), "Closed", 2));
        constantClasses.add(new Constant(this.getModule(), "Thrown", 4));
        constantClasses.add(new Constant(this.getModule(), "CabLockout", 1));
        constantClasses.add(new Constant(this.getModule(), "PushButtonLockout", 2));
        constantClasses.add(new Constant(this.getModule(), "Unlocked", 0));
        constantClasses.add(new Constant(this.getModule(), "Locked", 1));
        constantClasses.add(new Constant(this.getModule(), "Dark", 0));
        constantClasses.add(new Constant(this.getModule(), "Red", 1));
        constantClasses.add(new Constant(this.getModule(), "FlashRed", 2));
        constantClasses.add(new Constant(this.getModule(), "Yellow", 4));
        constantClasses.add(new Constant(this.getModule(), "FlashYellow", 8));
        constantClasses.add(new Constant(this.getModule(), "Green", 16));
        constantClasses.add(new Constant(this.getModule(), "FlashGreen", 32));
        constantClasses.add(new Constant(this.getModule(), "Lunar", 64));
        constantClasses.add(new Constant(this.getModule(), "FlashLunar", 128));
        constantClasses.add(new Constant(this.getModule(), "Held", 256));
        constantClasses.add(new Constant(this.getModule(), "sensors", InstanceManager.getNullableDefault(SensorManager.class)));
        constantClasses.add(new Constant(this.getModule(), "turnouts", InstanceManager.getNullableDefault(TurnoutManager.class)));
        constantClasses.add(new Constant(this.getModule(), "lights", InstanceManager.getNullableDefault(LightManager.class)));
        constantClasses.add(new Constant(this.getModule(), "signals", InstanceManager.getNullableDefault(SignalHeadManager.class)));
        constantClasses.add(new Constant(this.getModule(), "masts", InstanceManager.getNullableDefault(SignalMastManager.class)));
        constantClasses.add(new Constant(this.getModule(), "routes", InstanceManager.getNullableDefault(RouteManager.class)));
        constantClasses.add(new Constant(this.getModule(), "blocks", InstanceManager.getNullableDefault(BlockManager.class)));
        constantClasses.add(new Constant(this.getModule(), "oblocks", InstanceManager.getNullableDefault(OBlockManager.class)));
        constantClasses.add(new Constant(this.getModule(), "reporters", InstanceManager.getNullableDefault(ReporterManager.class)));
        constantClasses.add(new Constant(this.getModule(), "memories", InstanceManager.getNullableDefault(MemoryManager.class)));
        constantClasses.add(new Constant(this.getModule(), "powermanager", InstanceManager.getNullableDefault(PowerManager.class)));
        constantClasses.add(new Constant(this.getModule(), "addressedProgrammers", InstanceManager.getNullableDefault(AddressedProgrammerManager.class)));
        constantClasses.add(new Constant(this.getModule(), "globalProgrammers", InstanceManager.getNullableDefault(GlobalProgrammerManager.class)));
        constantClasses.add(new Constant(this.getModule(), "dcc", InstanceManager.getNullableDefault(CommandStation.class)));
        constantClasses.add(new Constant(this.getModule(), "audio", InstanceManager.getNullableDefault(AudioManager.class)));
        constantClasses.add(new Constant(this.getModule(), "shutdown", InstanceManager.getNullableDefault(ShutDownManager.class)));
        constantClasses.add(new Constant(this.getModule(), "layoutblocks", InstanceManager.getNullableDefault(LayoutBlockManager.class)));
        constantClasses.add(new Constant(this.getModule(), "warrants", InstanceManager.getNullableDefault(WarrantManager.class)));
        constantClasses.add(new Constant(this.getModule(), "sections", InstanceManager.getNullableDefault(SectionManager.class)));
        constantClasses.add(new Constant(this.getModule(), "transits", InstanceManager.getNullableDefault(TransitManager.class)));
        constantClasses.add(new Constant(this.getModule(), "InstanceManager", InstanceManager.getDefault()));
        return constantClasses;
    }

    @Override
    public String getConstantDescription() {
        return Bundle.getMessage("Layout.ConstantDescriptions");
    }

    private void addTurnoutExistsFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "turnoutExists", Bundle.getMessage("LayoutFunctions.turnoutExists_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                Turnout t = (Turnout)InstanceManager.getDefault(TurnoutManager.class).getNamedBean(name);
                return t != null;
            }
        });
    }

    private void addGetTurnoutStateFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "getTurnoutState", Bundle.getMessage("LayoutFunctions.getTurnoutState_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                Turnout t = (Turnout)InstanceManager.getDefault(TurnoutManager.class).getNamedBean(name);
                if (t == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetTurnoutState_TurnoutNotFound", name));
                }
                return t.getKnownState();
            }
        });
    }

    private void addSetTurnoutStateFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "setTurnoutState", Bundle.getMessage("LayoutFunctions.setTurnoutState_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                int value = (int)TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
                Turnout t = (Turnout)InstanceManager.getDefault(TurnoutManager.class).getNamedBean(name);
                if (t == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetTurnoutState_TurnoutNotFound", name));
                }
                t.setState(value);
                return t.getKnownState();
            }
        });
    }

    private void addSensorExistsFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "sensorExists", Bundle.getMessage("LayoutFunctions.sensorExists_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                Sensor s = (Sensor)InstanceManager.getDefault(SensorManager.class).getNamedBean(name);
                return s != null;
            }
        });
    }

    private void addGetSensorStateFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "getSensorState", Bundle.getMessage("LayoutFunctions.getSensorState_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                Sensor s = (Sensor)InstanceManager.getDefault(SensorManager.class).getNamedBean(name);
                if (s == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetSensorState_SensorNotFound", name));
                }
                return s.getKnownState();
            }
        });
    }

    private void addSetSensorStateFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "setSensorState", Bundle.getMessage("LayoutFunctions.setSensorState_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                int value = (int)TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
                Sensor s = (Sensor)InstanceManager.getDefault(SensorManager.class).getNamedBean(name);
                if (s == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetSensorState_SensorNotFound", name));
                }
                s.setState(value);
                return s.getKnownState();
            }
        });
    }

    private void addLightExistsFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "lightExists", Bundle.getMessage("LayoutFunctions.lightExists_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                Light l = (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(name);
                return l != null;
            }
        });
    }

    private void addGetLightStateFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "getLightState", Bundle.getMessage("LayoutFunctions.getLightState_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                Light l = (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(name);
                if (l == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetLightState_LightNotFound", name));
                }
                return l.getKnownState();
            }
        });
    }

    private void addSetLightStateFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "setLightState", Bundle.getMessage("LayoutFunctions.setLightState_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                int value = (int)TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
                Light l = (Light)InstanceManager.getDefault(LightManager.class).getNamedBean(name);
                if (l == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetLightState_LightNotFound", name));
                }
                l.setState(value);
                return l.getKnownState();
            }
        });
    }

    private void addSignalHeadExistsFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "signalHeadExists", Bundle.getMessage("LayoutFunctions.signalHeadExists_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                SignalHead sh = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(name);
                return sh != null;
            }
        });
    }

    private void addGetSignalHeadAppearanceFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "getSignalHeadAppearance", Bundle.getMessage("LayoutFunctions.getSignalHeadAppearance_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                SignalHead sh = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(name);
                if (sh == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetSignalHeadAppearance_SignalHeadNotFound", name));
                }
                return sh.getAppearance();
            }
        });
    }

    private void addSetSignalHeadAppearanceFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "setSignalHeadAppearance", Bundle.getMessage("LayoutFunctions.setSignalHeadAppearance_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                int aspect = (int)TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
                SignalHead sh = (SignalHead)InstanceManager.getDefault(SignalHeadManager.class).getNamedBean(name);
                if (sh == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetSignalHeadAppearance_SignalHeadNotFound", name));
                }
                sh.setAppearance(aspect);
                return sh.getAppearance();
            }
        });
    }

    private void addSignalMastExistsFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "signalMastExists", Bundle.getMessage("LayoutFunctions.signalMastExists_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                SignalMast sh = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(name);
                return sh != null;
            }
        });
    }

    private void addGetSignalMastAspectFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "getSignalMastAspect", Bundle.getMessage("LayoutFunctions.getSignalMastAspect_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 1));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                SignalMast sm = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(name);
                if (sm == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_GetSignalMastAspect_SignalMastNotFound", name));
                }
                return sm.getAspect();
            }
        });
    }

    private void addSetSignalMastAspectFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "setSignalMastAspect", Bundle.getMessage("LayoutFunctions.setSignalMastAspect_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                if (parameterList.isEmpty()) {
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters2", this.getName(), 2));
                }
                String name = TypeConversionUtil.convertToString(parameterList.get(0).calculate(symbolTable), false);
                String aspect = TypeConversionUtil.convertToString(parameterList.get(1).calculate(symbolTable), false);
                SignalMast sm = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(name);
                if (sm == null) {
                    throw new CalculateException(Bundle.getMessage("LayoutFunctions_SetSignalMastAspect_SignalMastNotFound", name));
                }
                sm.setAspect(aspect);
                return sm.getAspect();
            }
        });
    }
}

