/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.parser.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import jmri.JmriException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.util.parser.CalculateException;
import jmri.jmrit.logixng.util.parser.Constant;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.Function;
import jmri.jmrit.logixng.util.parser.FunctionFactory;
import jmri.jmrit.logixng.util.parser.WrongNumberOfParametersException;
import jmri.jmrit.logixng.util.parser.functions.AbstractFunction;
import jmri.jmrit.logixng.util.parser.functions.Bundle;
import jmri.util.TypeConversionUtil;

public class MathFunctions
implements FunctionFactory {
    @Override
    public String getModule() {
        return "Math";
    }

    @Override
    public Set<Function> getFunctions() {
        HashSet<Function> functionClasses = new HashSet<Function>();
        this.addRandomFunction(functionClasses);
        this.addAbsFunction(functionClasses);
        this.addSinFunction(functionClasses);
        this.addCosFunction(functionClasses);
        this.addTanFunction(functionClasses);
        this.addArctanFunction(functionClasses);
        this.addSqrFunction(functionClasses);
        this.addSqrtFunction(functionClasses);
        this.addRoundFunction(functionClasses);
        this.addCeilFunction(functionClasses);
        this.addFloorFunction(functionClasses);
        return functionClasses;
    }

    @Override
    public Set<Constant> getConstants() {
        HashSet<Constant> constantClasses = new HashSet<Constant>();
        constantClasses.add(new Constant(this.getModule(), "MathPI", Math.PI));
        constantClasses.add(new Constant(this.getModule(), "MathE", Math.E));
        return constantClasses;
    }

    @Override
    public String getConstantDescription() {
        return Bundle.getMessage("Math.ConstantDescriptions");
    }

    private void addRandomFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "random", Bundle.getMessage("Math.random_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                switch (parameterList.size()) {
                    case 0: {
                        return Math.random();
                    }
                    case 1: {
                        double max = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                        return Math.random() * max;
                    }
                    case 2: {
                        double min = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                        double max = TypeConversionUtil.convertToDouble(parameterList.get(1).calculate(symbolTable), false);
                        return min + Math.random() * (max - min);
                    }
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addAbsFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "abs", Bundle.getMessage("Math.abs_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                switch (parameterList.size()) {
                    case 1: {
                        Object value = parameterList.get(0).calculate(symbolTable);
                        if (value instanceof AtomicInteger || value instanceof AtomicLong || value instanceof BigInteger || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof LongAccumulator || value instanceof LongAdder) {
                            return Math.abs(((Number)value).longValue());
                        }
                        if (value instanceof BigDecimal || value instanceof Float || value instanceof Double || value instanceof DoubleAccumulator || value instanceof DoubleAdder) {
                            return Math.abs(((Number)value).doubleValue());
                        }
                        return Math.abs(TypeConversionUtil.convertToDouble(value, false));
                    }
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addSinFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "sin", Bundle.getMessage("Math.sin_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
                if (parameterList.size() == 1) {
                    double param = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    return Math.sin(param);
                }
                if (parameterList.size() >= 2) {
                    double result;
                    double param0 = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    Object param1 = parameterList.get(1).calculate(symbolTable);
                    if (param1 instanceof String) {
                        switch ((String)param1) {
                            case "rad": {
                                result = Math.sin(param0);
                                break;
                            }
                            case "deg": {
                                result = Math.sin(Math.toRadians(param0));
                                break;
                            }
                            default: {
                                throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                            }
                        }
                    } else if (param1 instanceof Number) {
                        double p1 = TypeConversionUtil.convertToDouble(param1, false);
                        double angle = param0 / p1 * 2.0 * Math.PI;
                        result = Math.sin(angle);
                    } else {
                        throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                    }
                    switch (parameterList.size()) {
                        case 2: {
                            return result;
                        }
                        case 4: {
                            double min = TypeConversionUtil.convertToDouble(parameterList.get(2).calculate(symbolTable), false);
                            double max = TypeConversionUtil.convertToDouble(parameterList.get(3).calculate(symbolTable), false);
                            return (result + 1.0) / 2.0 * (max - min) + min;
                        }
                    }
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addCosFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "cos", Bundle.getMessage("Math.cos_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
                if (parameterList.size() == 1) {
                    double param = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    return Math.cos(param);
                }
                if (parameterList.size() >= 2) {
                    double result;
                    double param0 = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    Object param1 = parameterList.get(1).calculate(symbolTable);
                    if (param1 instanceof String) {
                        switch ((String)param1) {
                            case "rad": {
                                result = Math.cos(param0);
                                break;
                            }
                            case "deg": {
                                result = Math.cos(Math.toRadians(param0));
                                break;
                            }
                            default: {
                                throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                            }
                        }
                    } else if (param1 instanceof Number) {
                        double p1 = TypeConversionUtil.convertToDouble(param1, false);
                        double angle = param0 / p1 * 2.0 * Math.PI;
                        result = Math.cos(angle);
                    } else {
                        throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                    }
                    switch (parameterList.size()) {
                        case 2: {
                            return result;
                        }
                        case 4: {
                            double min = TypeConversionUtil.convertToDouble(parameterList.get(2).calculate(symbolTable), false);
                            double max = TypeConversionUtil.convertToDouble(parameterList.get(3).calculate(symbolTable), false);
                            return (result + 1.0) / 2.0 * (max - min) + min;
                        }
                    }
                    throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addTanFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "tan", Bundle.getMessage("Math.tan_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
                if (parameterList.size() == 1) {
                    double param = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    return Math.tan(param);
                }
                if (parameterList.size() == 2) {
                    double param0 = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    Object param1 = parameterList.get(1).calculate(symbolTable);
                    if (param1 instanceof String) {
                        switch ((String)param1) {
                            case "rad": {
                                return Math.tan(param0);
                            }
                            case "deg": {
                                return Math.tan(Math.toRadians(param0));
                            }
                        }
                        throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                    }
                    if (param1 instanceof Number) {
                        double p1 = TypeConversionUtil.convertToDouble(param1, false);
                        double angle = param0 / p1 * 2.0 * Math.PI;
                        return Math.tan(angle);
                    }
                    throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addArctanFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "atan", Bundle.getMessage("Math.atan_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
                if (parameterList.size() == 1) {
                    double param = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    return Math.atan(param);
                }
                if (parameterList.size() == 2) {
                    double param0 = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    Object param1 = parameterList.get(1).calculate(symbolTable);
                    if (param1 instanceof String) {
                        switch ((String)param1) {
                            case "rad": {
                                return Math.atan(param0);
                            }
                            case "deg": {
                                return Math.toDegrees(Math.atan(param0));
                            }
                        }
                        throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                    }
                    if (param1 instanceof Number) {
                        double p1 = TypeConversionUtil.convertToDouble(param1, false);
                        double angle = Math.atan(param0);
                        return angle * p1 / 2.0 / Math.PI;
                    }
                    throw new CalculateException(Bundle.getMessage("IllegalParameter", 2, param1, this.getName()));
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addSqrFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "sqr", Bundle.getMessage("Math.sqr_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                switch (parameterList.size()) {
                    case 1: {
                        Object value = parameterList.get(0).calculate(symbolTable);
                        if (value instanceof AtomicInteger || value instanceof AtomicLong || value instanceof BigInteger || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof LongAccumulator || value instanceof LongAdder) {
                            long val = ((Number)value).longValue();
                            return val * val;
                        }
                        if (value instanceof BigDecimal || value instanceof Float || value instanceof Double || value instanceof DoubleAccumulator || value instanceof DoubleAdder) {
                            double val = ((Number)value).doubleValue();
                            return val * val;
                        }
                        double val = TypeConversionUtil.convertToDouble(value, false);
                        return val * val;
                    }
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addSqrtFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "sqrt", Bundle.getMessage("Math.sqrt_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws JmriException {
                if (parameterList.size() == 1) {
                    double param = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                    return Math.sqrt(param);
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addRoundFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "round", Bundle.getMessage("Math.round_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                double value = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                switch (parameterList.size()) {
                    case 1: {
                        return (double)Math.round(value);
                    }
                    case 2: {
                        long numDecimals = TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
                        double multiply = 1.0;
                        int i = 0;
                        while ((long)i < Math.abs(numDecimals)) {
                            multiply *= 10.0;
                            ++i;
                        }
                        if (numDecimals < 0L) {
                            multiply = 1.0 / multiply;
                        }
                        return (double)Math.round(value * multiply) / multiply;
                    }
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addCeilFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "ceil", Bundle.getMessage("Math.ceil_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                double value = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                switch (parameterList.size()) {
                    case 1: {
                        return Math.ceil(value);
                    }
                    case 2: {
                        long numDecimals = TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
                        double multiply = 1.0;
                        int i = 0;
                        while ((long)i < Math.abs(numDecimals)) {
                            multiply *= 10.0;
                            ++i;
                        }
                        if (numDecimals < 0L) {
                            multiply = 1.0 / multiply;
                        }
                        return Math.ceil(value * multiply) / multiply;
                    }
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }

    private void addFloorFunction(Set<Function> functionClasses) {
        functionClasses.add(new AbstractFunction(this, "floor", Bundle.getMessage("Math.floor_Descr")){

            @Override
            public Object calculate(SymbolTable symbolTable, List<ExpressionNode> parameterList) throws CalculateException, JmriException {
                double value = TypeConversionUtil.convertToDouble(parameterList.get(0).calculate(symbolTable), false);
                switch (parameterList.size()) {
                    case 1: {
                        return Math.floor(value);
                    }
                    case 2: {
                        long numDecimals = TypeConversionUtil.convertToLong(parameterList.get(1).calculate(symbolTable));
                        double multiply = 1.0;
                        int i = 0;
                        while ((long)i < Math.abs(numDecimals)) {
                            multiply *= 10.0;
                            ++i;
                        }
                        if (numDecimals < 0L) {
                            multiply = 1.0 / multiply;
                        }
                        return Math.floor(value * multiply) / multiply;
                    }
                }
                throw new WrongNumberOfParametersException(Bundle.getMessage("WrongNumberOfParameters1", this.getName()));
            }
        });
    }
}

