/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.swing;

import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.LogixNG_SelectCharset;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectStringSwing;
import jmri.util.swing.JComboBoxUtil;

public class LogixNG_SelectCharsetSwing {
    private final JDialog _dialog;
    private final LogixNG_SelectStringSwing _selectUserSpecified;
    private JTabbedPane _tabbedPane;
    private JPanel _panelStandard;
    private JPanel _panelAll;
    private JPanel _panelUserSpecified;
    private JComboBox<Charset> _standardValueComboBox;
    private JComboBox<Charset> _allValueComboBox;

    public LogixNG_SelectCharsetSwing(@Nonnull JDialog dialog, @Nonnull SwingConfiguratorInterface swi) {
        this._dialog = dialog;
        this._selectUserSpecified = new LogixNG_SelectStringSwing(this._dialog, swi);
    }

    public JPanel createPanel(@CheckForNull LogixNG_SelectCharset selectCharset) {
        JPanel panel = new JPanel();
        this._tabbedPane = new JTabbedPane();
        this._panelStandard = new JPanel();
        this._panelAll = new JPanel();
        this._standardValueComboBox = new JComboBox();
        this._standardValueComboBox = new JComboBox();
        for (Charset charset : LogixNG_SelectCharset.STANDARD_CHARSETS) {
            this._standardValueComboBox.addItem(charset);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._standardValueComboBox);
        this._panelStandard.add(this._standardValueComboBox);
        this._allValueComboBox = new JComboBox();
        this._allValueComboBox = new JComboBox();
        for (Charset charset : Charset.availableCharsets().values()) {
            this._allValueComboBox.addItem(charset);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._allValueComboBox);
        this._panelAll.add(this._allValueComboBox);
        this._panelUserSpecified = selectCharset != null ? this._selectUserSpecified.createPanel(selectCharset.getSelectUserSpecified()) : this._selectUserSpecified.createPanel(null);
        this._tabbedPane.addTab(LogixNG_SelectCharset.Addressing.Standard.toString(), this._panelStandard);
        this._tabbedPane.addTab(LogixNG_SelectCharset.Addressing.All.toString(), this._panelAll);
        this._tabbedPane.addTab(LogixNG_SelectCharset.Addressing.UserSpecified.toString(), this._panelUserSpecified);
        if (selectCharset != null) {
            switch (selectCharset.getAddressing()) {
                case Standard: {
                    this._tabbedPane.setSelectedComponent(this._panelStandard);
                    break;
                }
                case All: {
                    this._tabbedPane.setSelectedComponent(this._panelAll);
                    break;
                }
                case UserSpecified: {
                    this._tabbedPane.setSelectedComponent(this._panelUserSpecified);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + selectCharset.getAddressing().name());
                }
            }
            if (selectCharset.getStandardValue() != null) {
                this._standardValueComboBox.setSelectedItem(selectCharset.getStandardValue());
            }
            if (selectCharset.getAllValue() != null) {
                this._allValueComboBox.setSelectedItem(selectCharset.getAllValue());
            }
        }
        panel.add(this._tabbedPane);
        return panel;
    }

    public boolean validate(@Nonnull LogixNG_SelectCharset selectCharset, @Nonnull List<String> errorMessages) {
        this._selectUserSpecified.validate(selectCharset.getSelectUserSpecified(), errorMessages);
        return errorMessages.isEmpty();
    }

    public void updateObject(@Nonnull LogixNG_SelectCharset selectCharset) {
        if (this._tabbedPane.getSelectedComponent() == this._panelStandard) {
            selectCharset.setAddressing(LogixNG_SelectCharset.Addressing.Standard);
            selectCharset.setStandardValue(this._standardValueComboBox.getItemAt(this._standardValueComboBox.getSelectedIndex()));
        } else if (this._tabbedPane.getSelectedComponent() == this._panelAll) {
            selectCharset.setAddressing(LogixNG_SelectCharset.Addressing.All);
            selectCharset.setAllValue(this._allValueComboBox.getItemAt(this._allValueComboBox.getSelectedIndex()));
        } else if (this._tabbedPane.getSelectedComponent() == this._panelUserSpecified) {
            selectCharset.setAddressing(LogixNG_SelectCharset.Addressing.UserSpecified);
        } else {
            throw new IllegalArgumentException("_tabbedPaneEnum has unknown selection");
        }
        this._selectUserSpecified.updateObject(selectCharset.getSelectUserSpecified());
    }

    public void dispose() {
        this._selectUserSpecified.dispose();
    }
}

