/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.LogixNG_SelectComboBox;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.Bundle;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectTableSwing;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;

public class LogixNG_SelectComboBoxSwing {
    private final JDialog _dialog;
    private final LogixNG_SelectTableSwing _selectTableSwing;
    private JTabbedPane _tabbedPane;
    private JComboBox<String> _valuesComboBox;
    private JPanel _panelDirect;
    private JPanel _panelReference;
    private JPanel _panelMemory;
    private JPanel _panelLocalVariable;
    private JPanel _panelFormula;
    private JPanel _panelTable;
    private JTextField _referenceTextField;
    private BeanSelectPanel<Memory> _memoryPanel;
    private JCheckBox _listenToMemoryCheckBox;
    private JTextField _localVariableTextField;
    private JTextField _formulaTextField;

    public LogixNG_SelectComboBoxSwing(@Nonnull JDialog dialog, @Nonnull SwingConfiguratorInterface swi) {
        this._dialog = dialog;
        this._selectTableSwing = new LogixNG_SelectTableSwing(this._dialog, swi);
    }

    public JPanel createPanel(@Nonnull LogixNG_SelectComboBox selectComboBox) {
        return this.createPanel(selectComboBox, null);
    }

    public JPanel createPanel(@Nonnull LogixNG_SelectComboBox selectComboBox, String defaultValue) {
        JPanel panel = new JPanel();
        this._tabbedPane = new JTabbedPane();
        this._panelDirect = new JPanel();
        this._panelReference = new JPanel();
        this._panelMemory = new JPanel();
        this._panelLocalVariable = new JPanel();
        this._panelFormula = new JPanel();
        this._panelTable = this._selectTableSwing.createPanel(selectComboBox.getSelectTable());
        this._memoryPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._listenToMemoryCheckBox = new JCheckBox(Bundle.getMessage("ListenToMemory"));
        this._panelMemory.setLayout(new BoxLayout(this._panelMemory, 1));
        this._panelMemory.add(this._memoryPanel);
        this._panelMemory.add(this._listenToMemoryCheckBox);
        this._tabbedPane.addTab(NamedBeanAddressing.Direct.toString(), this._panelDirect);
        this._tabbedPane.addTab(NamedBeanAddressing.Reference.toString(), this._panelReference);
        this._tabbedPane.addTab(NamedBeanAddressing.Memory.toString(), this._panelMemory);
        this._tabbedPane.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLocalVariable);
        this._tabbedPane.addTab(NamedBeanAddressing.Formula.toString(), this._panelFormula);
        this._tabbedPane.addTab(NamedBeanAddressing.Table.toString(), this._panelTable);
        this._valuesComboBox = new JComboBox();
        for (String value : selectComboBox.getValues()) {
            this._valuesComboBox.addItem(value);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._valuesComboBox);
        this._valuesComboBox.setRenderer(new ComboBoxRenderer<String>(this._valuesComboBox.getRenderer()));
        this._panelDirect.add(this._valuesComboBox);
        this._referenceTextField = new JTextField();
        this._referenceTextField.setColumns(30);
        this._panelReference.add(this._referenceTextField);
        this._localVariableTextField = new JTextField();
        this._localVariableTextField.setColumns(30);
        this._panelLocalVariable.add(this._localVariableTextField);
        this._formulaTextField = new JTextField();
        this._formulaTextField.setColumns(30);
        this._panelFormula.add(this._formulaTextField);
        if (defaultValue != null) {
            this._valuesComboBox.setSelectedItem(defaultValue);
        }
        switch (selectComboBox.getAddressing()) {
            case Direct: {
                this._tabbedPane.setSelectedComponent(this._panelDirect);
                break;
            }
            case Reference: {
                this._tabbedPane.setSelectedComponent(this._panelReference);
                break;
            }
            case Memory: {
                this._tabbedPane.setSelectedComponent(this._panelMemory);
                break;
            }
            case LocalVariable: {
                this._tabbedPane.setSelectedComponent(this._panelLocalVariable);
                break;
            }
            case Formula: {
                this._tabbedPane.setSelectedComponent(this._panelFormula);
                break;
            }
            case Table: {
                this._tabbedPane.setSelectedComponent(this._panelTable);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + selectComboBox.getAddressing().name());
            }
        }
        if (selectComboBox.getValue() != null) {
            this._valuesComboBox.setSelectedItem(selectComboBox.getValue());
        }
        this._referenceTextField.setText(selectComboBox.getReference());
        this._memoryPanel.setDefaultNamedBean(selectComboBox.getMemory());
        this._listenToMemoryCheckBox.setSelected(selectComboBox.getListenToMemory());
        this._localVariableTextField.setText(selectComboBox.getLocalVariable());
        this._formulaTextField.setText(selectComboBox.getFormula());
        panel.add(this._tabbedPane);
        return panel;
    }

    public void addAddressingListener(ChangeListener listener) {
        this._tabbedPane.addChangeListener(listener);
    }

    public void addEnumListener(ActionListener listener) {
        this._valuesComboBox.addActionListener(listener);
    }

    public boolean validate(@Nonnull LogixNG_SelectComboBox selectComboBox, @Nonnull List<String> errorMessages) {
        try {
            if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                selectComboBox.setReference(this._referenceTextField.getText());
            }
        }
        catch (IllegalArgumentException e) {
            errorMessages.add(e.getMessage());
            return false;
        }
        try {
            selectComboBox.setFormula(this._formulaTextField.getText());
            selectComboBox.setAddressing(this.getAddressing());
        }
        catch (ParserException e) {
            errorMessages.add("Cannot parse formula: " + e.getMessage());
            return false;
        }
        this._selectTableSwing.validate(selectComboBox.getSelectTable(), errorMessages);
        return errorMessages.isEmpty();
    }

    public void updateObject(@Nonnull LogixNG_SelectComboBox selectComboBox) {
        block9: {
            if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                selectComboBox.setValue(this._valuesComboBox.getItemAt(this._valuesComboBox.getSelectedIndex()));
            }
            try {
                if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                    selectComboBox.setAddressing(NamedBeanAddressing.Direct);
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                    selectComboBox.setAddressing(NamedBeanAddressing.Reference);
                    selectComboBox.setReference(this._referenceTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
                    selectComboBox.setAddressing(NamedBeanAddressing.Memory);
                    selectComboBox.setMemory(this._memoryPanel.getNamedBean());
                    selectComboBox.setListenToMemory(this._listenToMemoryCheckBox.isSelected());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
                    selectComboBox.setAddressing(NamedBeanAddressing.LocalVariable);
                    selectComboBox.setLocalVariable(this._localVariableTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
                    selectComboBox.setAddressing(NamedBeanAddressing.Formula);
                    selectComboBox.setFormula(this._formulaTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
                    selectComboBox.setAddressing(NamedBeanAddressing.Table);
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPaneEnum has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
        this._selectTableSwing.updateObject(selectComboBox.getSelectTable());
    }

    public boolean isValueSelected(String value) {
        if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            return this._valuesComboBox.getItemAt(this._valuesComboBox.getSelectedIndex()).equals(value);
        }
        return false;
    }

    public boolean isValueSelectedOrIndirectAddressing(String value) {
        if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            return this._valuesComboBox.getItemAt(this._valuesComboBox.getSelectedIndex()).equals(value);
        }
        return true;
    }

    public NamedBeanAddressing getAddressing() {
        if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            return NamedBeanAddressing.Direct;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
            return NamedBeanAddressing.Reference;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
            return NamedBeanAddressing.Memory;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
            return NamedBeanAddressing.LocalVariable;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
            return NamedBeanAddressing.Formula;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
            return NamedBeanAddressing.Table;
        }
        throw new IllegalArgumentException("_tabbedPane has unknown selection");
    }

    public String getValue() {
        return this._valuesComboBox.getItemAt(this._valuesComboBox.getSelectedIndex());
    }

    public void setValue(String value) {
        this._valuesComboBox.setSelectedItem(value);
    }

    public void setValues(String[] valuesArray) {
        String selectedValue = this._valuesComboBox.getItemAt(this._valuesComboBox.getSelectedIndex());
        this._valuesComboBox.removeAllItems();
        for (String value : valuesArray) {
            this._valuesComboBox.addItem(value);
        }
        this._valuesComboBox.setSelectedItem(selectedValue);
    }

    public void dispose() {
        this._selectTableSwing.dispose();
    }

    private static class ComboBoxRenderer<E>
    extends JLabel
    implements ListCellRenderer<E> {
        private final JSeparator _separator = new JSeparator(0);
        private final ListCellRenderer<E> _old;

        private ComboBoxRenderer(ListCellRenderer<E> old) {
            this._old = old;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
            if ("---------------".equals(value)) {
                return this._separator;
            }
            return this._old.getListCellRendererComponent(list, (E)value, index, isSelected, cellHasFocus);
        }
    }
}

